
#ifndef VUC_PROTO_DBGF
#  warning VUC_PROTO_DBGF not set
#  define VUC_PROTO_DBGF(...)	
#endif


#if (VUC_PKT_SEQ)
extern u8 vuc_pkt_no;
#endif
#if (VUC_PKT_CHK)
extern u8 vuc_pkt_code;
#endif


static u8 vuc_in_buf[VUC_IN_DATA_SIZE+1];
static u8 vuc_in_buf_p= 0;
static u8 vuc_deco_state= 0;

static void __inline__ vuc_in_decode (u8 c)
{
//  static u8 state= 0;
  static u8 rep= 0;
  static u8 adr, cmd;
  static u16 data_len, data_cnt;

  switch (vuc_deco_state) {
    case 0:
      cmd= c&0xc0; adr= c&0x3f;
      if (cmd>VUC_CMD__MAX)
        { vuc_in_err(VUC_ERR_BAD_CMD, c); break; }
      if (cmd==VUC_CMD_META) {
        if (adr>=VUC_META__STRING)
          { vuc_deco_state= 1; break; }
        if (adr>=VUC_META__1_BYTE)
          { data_len= data_cnt= 1; vuc_deco_state= 10; break; }
        if (adr>=VUC_META__2_BYTE)
          { data_len= data_cnt= 2; vuc_deco_state= 10; break; }
#if (VUC_FLOW_CTR)
        if (adr==VUC_META_XON)
          { vuc_out_on= 1; break; }
        if (adr==VUC_META_XOFF)
          { vuc_out_on= 0; break; }
#endif
        rep= vuc_in_meta(adr, 0, NULL);
        break;
      }
      // TODO: adr above 64
      if (cmd==VUC_CMD_PUT) {
        if (adr>=VUC_PUT_ADRS)
          { vuc_in_err(VUC_ERR_PUT_ADR, adr); break; }
        data_len= data_cnt= vuc_put_data[adr].no_of_bytes; vuc_deco_state= 10; break;
      }
//    if (cmd==VUC_CMD_GET) { // can only be VUC_CMD_GET
        if (adr>=VUC_GET_ADRS)
          { vuc_in_err(VUC_ERR_GET_ADR, adr); break; }
        VUC_PROTO_DBGF("Get %x", adr);
#if (VUC_CB_HAS_USER)
        rep= vuc_get_data[adr].func(vuc_in_buf, vuc_get_data[adr].user);
#else
        rep= vuc_get_data[adr].func(vuc_in_buf);
#endif
//    }
      break;
    case 1:
      data_len= data_cnt= c; vuc_deco_state= 10; break;
    case 10:
      if (vuc_in_buf_p<VUC_IN_DATA_SIZE)
        vuc_in_buf[vuc_in_buf_p++]= c;
      else
        errf("Buffer overflow!");
      if (--data_cnt)
        break;
      vuc_deco_state= 0;
      if (cmd==VUC_CMD_META) {
        vuc_in_buf[vuc_in_buf_p]= 0;
#if (VUC_DBG_PROTO)
        if (adr==VUC_META_HELLO) {
          VUC_PROTO_DBGF("Meta Hello: %x.%x", c>>4, c&0x0f);
        } else {
          VUC_PROTO_DBGF("Meta %x: '%s'", adr, vuc_in_buf);
        }
#endif
        rep= vuc_in_meta(adr, data_len, vuc_in_buf);
         vuc_in_buf_p= 0; break;
      }
//      if (cmd==VUC_CMD_PUT) { // can only be VUC_CMD_PUT
        VUC_PROTO_DBGF("Put %x: %x-%x", adr, vuc_in_buf_p, vuc_in_buf[0]);
#if (VUC_CB_HAS_USER)
        rep= vuc_put_data[adr].func(vuc_in_buf, vuc_put_data[adr].user);
#else
        rep= vuc_put_data[adr].func(vuc_in_buf);
#endif
//        vuc_in_buf_p= vuc_deco_state= 0; break;
//      }
      vuc_in_buf_p= 0; break;
  }
}

#if (VUC_PACKET)

static void __inline__ vuc_input (u8 c)
{
  i8 rep= 0;
  static u8 pkt_len, pkt_buf_p, pkt_state= 0;
#if (VUC_PKT_CHK)
  static u8 pkt_chk;
#endif
#if (VUC_PKT_SEQ)
  static u8 pkt_status;
#endif
  u8 i;

  switch (pkt_state) {
    case 0:
      if (c==(VUC_CMD_META|VUC_META_PKT)) {
        pkt_buf_p= 0; pkt_state= 2; vuc_in_pkt_start(); return;
      }
      if (c==(VUC_CMD_META|VUC_META_ALIVE)) {
        vuc_in_meta(c&0x3f, 0, NULL); return;
      }
      if (c==(VUC_CMD_META|VUC_META_PKT_OK)
       || c==(VUC_CMD_META|VUC_META_PKT_BAD)
       || c==(VUC_CMD_META|VUC_META_PKT_WTF)
      ) {
        VUC_OPT(PKT_SEQ, pkt_status= c&0x3f; pkt_state= 1; return;)
        vuc_in_handshake(c&0x3f, 0, NULL); return;
      }
      vuc_in_err(VUC_ERR_PKT_HDR, c);
      // throw away
      return;
#if (VUC_PKT_SEQ)
    case 1:
      pkt_state= 0;
      vuc_in_handshake(pkt_status, 1, &c);
      return;
#endif
    case 2:
      pkt_len= c; pkt_state++;
//      VUC_OPT(PKT_CHK, pkt_len++; pkt_chk= 0;)
      VUC_OPT(PKT_CHK, pkt_len++; pkt_chk= 0;)
#if (!VUC_PKT_SEQ)
      VUC_PROTO_DBGF("Pkt: %x bytes", c);
#endif
      return;
    case 3:
#if (VUC_PKT_SEQ)
      VUC_PROTO_DBGF("Pkt #%x: %x bytes", c, pkt_len);
      if (VUC_OPT_CHK(PKT_SEQ)) {
        if (!vuc_is_warm)
          vuc_in_pkt_no= c;
        if (c==vuc_in_pkt_no) {
          pkt_state++;
        } else {
          // wrong sequence -> throw away
          pkt_state= 0; vuc_in_send_hs(-1);
        }
        return;
      }
      // fall through
    case 4:
#endif
      if (--pkt_len) {
        VUC_OPT(PKT_CHK, pkt_chk= VUC_CHK(pkt_chk, c);)
        if (vuc_in_buf_p<VUC_IN_DATA_SIZE)
          vuc_in_buf[pkt_buf_p++]= c;
        else
          errf("Packet buffer overflow!");
        return;
      }
      pkt_state= 0;
#if (VUC_PKT_CHK)
      if (!VUC_OPT_CHK(PKT_CHK) || pkt_chk==c) {
        VUC_PROTO_DBGF("Pkt ok");
        rep= 1;
      } else {
        VUC_PROTO_DBGF("Pkt [%x %x] bad. Got %x, want %x", vuc_in_buf[0], vuc_in_buf[1], c, pkt_chk);
        rep= -1;
      }
#else /* VUC_PKT_CHK */
      VUC_PROTO_DBGF("Pkt ok");
      vuc_in_buf[pkt_buf_p++]= c;
      rep= 1;
#endif /* VUC_PKT_CHK */
//      if (vuc_deco_state!=0 || vuc_in_buf[0]!=(VUC_CMD_META|VUC_META_DBG))
      vuc_in_send_hs(rep);
      if (rep>0) {
        for (i=0; i<pkt_buf_p; i++)
          vuc_in_decode(vuc_in_buf[i]);
        vuc_in_pkt_no++; vuc_is_warm= 1;
      }
  }
}

#else

static void __inline__ vuc_input (u8 c)
{
  vuc_in_decode(c);
}

#endif
