
#include <config.h>

#include <math.h>
#include <stdio.h>

#if (GTK_MAJOR_VERSION<2)
#  include <gdk/gdk.h>
#endif
#include <gtk/gtkmain.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkprivate.h>

#include "anygtk.h"
#include "vuc_host.h"
#include "vuc_proto.h"

#include "vuc_object.h"


enum {
  PROP_0,

  PROP_VUC_SIZE,
  PROP_VUC_ADDR,
  PROP_VUC_INIT,
  PROP_VUC_RUN,
  PROP_VUC_DECL,
};

static void set_property
  (GObject * obj, guint prop_id, const GValue * value, GParamSpec * pspec);
static void get_property
  (GObject * obj, guint prop_id, GValue * value, GParamSpec * pspec);


static void vuc_object_class_init (VucObjectClass * class)
{
  GtkObjectClass * object_class= (GtkObjectClass*)class;
  GtkWidgetClass * widget_class= (GtkWidgetClass*)class;

  object_class->agtk_set_prop_func= set_property;
  object_class->agtk_get_prop_func= get_property;
  agtk_add_prop_int(
    object_class, "VucObject", PROP_VUC_SIZE, GTK_PARAM_READWRITE,
    "vuc-size", NULL, NULL, 0, 0xffff, 0
  );
  agtk_add_prop_int(
    object_class, "VucObject", PROP_VUC_ADDR, GTK_PARAM_READWRITE,
    "vuc-addr", NULL, NULL, -1, VUC_ADDR_MAX, -1
  );
  agtk_add_prop_string(
    object_class, "VucObject", PROP_VUC_INIT, GTK_PARAM_WRITABLE,
    "vuc-init", NULL, NULL, ""
  );
  agtk_add_prop_string(
    object_class, "VucObject", PROP_VUC_RUN, GTK_PARAM_WRITABLE,
    "vuc-run", NULL, NULL, ""
  );
  agtk_add_prop_string(
    object_class, "VucObject", PROP_VUC_RUN, GTK_PARAM_WRITABLE,
    "vuc-decl", NULL, NULL, ""
  );
}

static void vuc_object_init (VucObject * obj)
{
  obj->vuc_size= 0; obj->vuc_addr= -1;
  obj->xdata= NULL;
}

G_DEFINE_TYPE(VucObject, vuc_object, GTK_TYPE_OBJECT)

static void property_handler
  (gint dir, GObject * g_obj, guint prop_id, GValue * value, GParamSpec * pspec)
{
  VucObject * obj= VUC_OBJECT(g_obj);

  switch (prop_id) {
    case PROP_VUC_SIZE: vuc_prop_hdl_int(dir, value, &obj->vuc_size); break;
    case PROP_VUC_ADDR: vuc_prop_hdl_int(dir, value, &obj->vuc_addr); break;
    case PROP_VUC_INIT: case PROP_VUC_RUN: case PROP_VUC_DECL: break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID(obj, prop_id, pspec);
  }
}

static void set_property
  (GObject * g_obj, guint prop_id, const GValue * value, GParamSpec * pspec)
{
  property_handler(1, g_obj, prop_id, (void *)value, pspec);
}

static void get_property
  (GObject * g_obj, guint prop_id, GValue * value, GParamSpec * pspec)
{
  property_handler(0, g_obj, prop_id, value, pspec);
}

/*
gpointer vuc_object_get_data (VucObject * obj)
{
  return obj->xdata;
}
*/
