/*****************************************************\

  The V.U.C. Protocol

\*****************************************************/

#ifndef __VUC_PROTO_H__
#define __VUC_PROTO_H__

// Protocol version
#define VUC_PROTO_MAJOR		0
#define VUC_PROTO_MINOR		1
#define VUC_PROTO_VER		G_STRINGIFY(VUC_PROTO_MAJOR) "." G_STRINGIFY(VUC_PROTO_MINOR)

// Maximum address we can handle
#define VUC_ADDR_MAX		59

// Byte-order is fixed to little-endian (for now)
#define VUC_I16_TO_VE		GINT16_TO_LE
#define VUC_U16_TO_VE		GUINT16_TO_LE
#define VUC_I32_TO_VE		GINT32_TO_LE
#define VUC_U32_TO_VE		GUINT32_TO_LE
#define VUC_VE_TO_I16		GINT16_FROM_LE
#define VUC_VE_TO_U16		GUINT16_FROM_LE
#define VUC_VE_TO_I32		GINT32_FROM_LE
#define VUC_VE_TO_U32		GUINT32_FROM_LE

// Commands from control-panel
#define VUC_CMD_META		0x00	// "Meta"-command
#define VUC_CMD_PUT		0x40	// Send value(s) to uC
#define VUC_CMD_GET		0x80	// Get Value(s) from uC
#define VUC_CMD__MAX		0xbf

// Replies from uC
//#define VUC_REP_META		0x00	// dito
//#define VUC_REP_PUT		0x40	// Send Value(s) to PC
//#define VUC_REP__MAX		0x7f

// Protocol-overhead
#define VUC_META_INIT		0x04	// uC<>PC Reset
//#define VUC_META_ACK		0x06	// uC<>PC Ok
//#define VUC_META_XON		0x11	// uC<>PC Start  obsolete
//#define VUC_META_XOFF		0x13	// uC<>PC Stop  obsolete
//#define VUC_META_NAK		0x15	// uC<>PC Nope
#define VUC_META_ALIVE		0x16	// uC<>PC I'm fine, thanks!
#define VUC_META_PKT		0x01	// uC<>PC Start of packet - length-byte follows
#define VUC_META_PKT_WTF	0x05	// uC<>PC WTF happend to the last handshake?
#define VUC_META_PKT_OK		0x07	// uC<>PC Packet received
#define VUC_META_PKT_BAD	0x1a	// uC<>PC Packet checksum err

#define VUC_META__1_BYTE	0x20	// Metas with 1-byte-parameters start here
#define VUC_META_HELLO		0x21	// uC->PC set protocol-version - 1 byte follows ("1.4" = 0x14)

#define VUC_META__2_BYTE	0x28	// Metas with 2-byte-parameters start here

#define VUC_META__STRING	0x30	// Metas with variable-length-parameters start here
#define VUC_META_ID		0x30	// uC->PC identify board - 1 byte length and arbitrary data follows
#define VUC_META_EXT		0x31	// uC<>PC Extended command (to be defined) - 1 byte length and UTF-8-data follows
#define VUC_META_MSG		0x36	// uC->PC Tell the user - 1 byte length and UTF-8-data follows
#define VUC_META_DBG		0x37	// uC->PC Debug msg - dito


// Errorcodes
#define VUC_ERR_BAD_CMD		0x01	// illegal command
#define VUC_ERR_PUT_ADR		0x02	// channel-address out of range in "put"
#define VUC_ERR_GET_ADR		0x03	// channel-address out of range in "get"
#define VUC_ERR_META_SUB	0x04	// illegal "meta"-subcommand
#define VUC_ERR_PKG_BAD		0x05	// wrong packet checksum
#define VUC_ERR_PKT_HDR		0x06	// No packet-header received - Line error
#define VUC_ERR__MAX		0x06


// Statuscodes
#define VUC_ST_PKG_DONE		0
#define VUC_ST_PKG_CONTINUE	1
#define VUC_ST_PKG_WAIT_ACK	3


// Function to compute the check-value
#ifndef VUC_CHK
#  define VUC_CHK(a,b)	(a+b)
#endif


#define VUC_OPT_FLG_PACKET	0x0001
#define VUC_OPT_FLG_PKT_CHK	0x0002
#define VUC_OPT_FLG_PKT_SEQ	0x0004

#define VUC_CONCAT__2(a, b)	a ## b
#define VUC_CONCAT(a, b)	VUC_CONCAT__2(a, b)
#define VUC_CONCAT__3(a, b, c)	a ## b ## c
#define VUC_CONCAT3(a, b, c)	VUC_CONCAT__3(a, b, c)

#if (VUC_IS_HOST)
#  define VUC_OPT_CHK(opt)	VUC_CONCAT(VUC_OPT_CHK_, opt)
#  define VUC_OPT(opt, ...) \
    if (VUC_CONCAT(VUC_, opt) && VUC_OPT_CHK(opt)) \
      { __VA_ARGS__ }
#else
#  define VUC_OPT_CHK(opt)	1
#  define VUC_OPT(opt, ...) \
    if (VUC_CONCAT(VUC_, opt)) \
      { __VA_ARGS__ }
#endif

#endif /* __VUC_PROTO_H__ */
