/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef __VUC_SCOPE_H__
#define __VUC_SCOPE_H__


#include <gdk/gdk.h>
#include <gtk/gtkadjustment.h>
#include <gtk/gtkwidget.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define VUC_SCOPE(obj)		GTK_CHECK_CAST(obj, vuc_scope_get_type(), VucScope)
#define VUC_SCOPE_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, vuc_scope_get_type(), VucScopeClass)
#define VUC_IS_SCOPE(obj)	GTK_CHECK_TYPE(obj, vuc_scope_get_type())


#define VUC_SCOPE_NORM		0xffff

/* Defaults */
#define VUC_SCOPE_WIDTH		300
#define VUC_SCOPE_HEIGHT	300

#define VUC_SCOPE_BG_COLOR	"#000"

#define VUC_SCOPE_GRID_COLOR	"#333"

//#define VUC_SCOPE_BEAM_COLOR	"#41ff00"	// P1 "Green"
#define VUC_SCOPE_BEAM_COLOR	"#66ffaa"	// P2 "Blue-Green"
//#define VUC_SCOPE_BEAM_COLOR	"#0066ff"	// P11 "blue"
//#define VUC_SCOPE_BEAM_COLOR	"#4cff00"	// P31 "Yellowish-green"



typedef struct _VucScope        VucScope;
typedef struct _VucScopeClass   VucScopeClass;

struct _VucScope
{
  GtkWidget p;

  gint vuc_size, vuc_addr;

  gint p_max, p_cnt;
  GdkPoint * points;

  gchar * bg_col_str, * grid_col_str, * beam_col_str;
  GdkColor bg_color, grid_color, beam_color;

#if (GTK_3)
  cairo_surface_t * csurf;
#else
  GdkPixmap * pixmap;
  GdkGC * gc;
#endif
};

struct _VucScopeClass
{
  GtkWidgetClass p;
};


GtkWidget * vuc_scope_new (void);
guint vuc_scope_get_type (void);

i8 vuc_scope_in (u8 * data, void * user);
//gint vuc_scope_set_samples (VucScope * sc, gint size_x, gint size_y, gint size_d, gpointer data);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __VUC_SCOPE_H */
