
#include <config.h>

#include <math.h>
#include <stdio.h>

#if (GTK_MAJOR_VERSION<2)
#  include <gdk/gdk.h>
#endif
#include <gtk/gtkmain.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkprivate.h>

#include "anygtk.h"
#include "vuc_host.h"
#include "vuc_proto.h"

#include "vuc_vfader.h"


enum {
  PROP_0,

  PROP_VUC_SIZE,
  PROP_VUC_ADDR,
  PROP_VUC_INIT,
  PROP_VUC_RUN,
};

static void set_property
  (GObject * obj, guint prop_id, const GValue * value, GParamSpec * pspec);
static void get_property
  (GObject * obj, guint prop_id, GValue * value, GParamSpec * pspec);


static void vuc_vfader_class_init (VucVFaderClass * class)
{
  GtkObjectClass * object_class= (GtkObjectClass*)class;
  GtkWidgetClass * widget_class= (GtkWidgetClass*)class;

  object_class->agtk_set_prop_func= set_property;
  object_class->agtk_get_prop_func= get_property;
  agtk_add_prop_int(
    object_class, "VucVFader", PROP_VUC_SIZE, GTK_PARAM_READWRITE,
    "vuc-size", NULL, NULL, 0, 0xffff, 0
  );
  agtk_add_prop_int(
    object_class, "VucVFader", PROP_VUC_ADDR, GTK_PARAM_READWRITE,
    "vuc-addr", NULL, NULL, -1, VUC_ADDR_MAX, -1
  );
  agtk_add_prop_string(
    object_class, "VucVFader", PROP_VUC_INIT, GTK_PARAM_WRITABLE,
    "vuc-init", NULL, NULL, ""
  );
  agtk_add_prop_string(
    object_class, "VucVFader", PROP_VUC_RUN, GTK_PARAM_WRITABLE,
    "vuc-run", NULL, NULL, ""
  );
}

static void vuc_vfader_init (VucVFader * obj)
{
  obj->vuc_size= 0; obj->vuc_addr= -1;
}

G_DEFINE_TYPE(VucVFader, vuc_vfader, GTK_TYPE_VSCALE)

static void property_handler
  (gint dir, GObject * g_obj, guint prop_id, GValue * value, GParamSpec * pspec)
{
  VucVFader * obj= VUC_VFADER(g_obj);

  switch (prop_id) {
    case PROP_VUC_SIZE: vuc_prop_hdl_int(dir, value, &obj->vuc_size); break;
    case PROP_VUC_ADDR: vuc_prop_hdl_int(dir, value, &obj->vuc_addr); break;
    case PROP_VUC_INIT: case PROP_VUC_RUN: break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID(g_obj, prop_id, pspec);
  }
}

static void set_property
  (GObject * g_obj, guint prop_id, const GValue * value, GParamSpec * pspec)
{
  property_handler(1, g_obj, prop_id, (void *)value, pspec);
}

static void get_property
  (GObject * g_obj, guint prop_id, GValue * value, GParamSpec * pspec)
{
  property_handler(0, g_obj, prop_id, value, pspec);
}

gdouble vuc_vfader_get_val (VucVFader * obj)
{
  return gtk_adjustment_get_value(gtk_range_get_adjustment(GTK_RANGE(&obj->p)));
}
