.include "m16def.inc"


.def null = r0
.def eins = r1
.def voll = r2
.def bla = r3
.def temp = r16
.def flags = r17
.def addrL = r18
.def addrM = r19
.def addrH = r20
.def RCount = r21
.def RamByte = r22
.def ADCData = r23
.def timer = r24
.def timer2 = r25


;PORTA
.equ A8 = 0
.equ A9 = 1
.equ A10 = 2
.equ RAS = 3
.equ WE = 4
.equ CAS = 5

.equ NewADCData = 0
.equ DramRefreshBusy = 1
.equ NeedDramRefresh = 2
.equ startFlushDram = 3
.equ flushDram = 4
.equ RWOpRunning = 5

.equ CLOCK = 16000000
.equ BAUD = 38400
.equ UBRRVAL = 16000000/(BAUD*16)-1


.org 0x00
	rjmp RESET
.org OVF0addr
	rjmp OVF0_i
.org OVF1addr
	rjmp OVF1_i
.org UTXCaddr
	rjmp TXC_i
.org ADCCaddr
	rjmp ADC_i



OVF0_i:
	sbr flags,(1<<NeedDramRefresh)

	sbrc flags,RWOpRunning
	rjmp OVF0_i_ende

	rcall Refresh
	clr timer2
OVF0_i_ende:
reti

OVF1_i:
	push temp
	in temp,SREG
	push temp
	
	inc timer
	cpi timer,5
	brne OVF1_i_ende
	sbr flags,(1<<flushDram)|(1<<startFlushDram)
	
	ldi temp,0x00
	out TCCR1B,temp


OVF1_i_ende:
	pop temp
	out SREG,temp
	pop temp
reti


TXC_i:
	sbrs flags,flushDram
	rjmp TXC_i_ende

	sbi PORTA,RAS
	sbi PORTA,CAS
	
TXC_i_send:
	sbis UCSRA,UDRE                   ; Warten bis UDR fr das nchste
                                          ; Byte bereit ist
    rjmp TXC_i_send
    out UDR, RamByte	

	add addrL,eins			;24 bit Adresszhler hochzhlen
	adc addrM,null
	adc addrH,null
	sbrc addrH,3			;Speicher voll ?
	rjmp TXC_i_speicher_voll

	rcall ReadByte
	rjmp TxC_i_ende
		
	TXC_i_speicher_voll:
	cbr flags,(1<<flushDram)

	TXC_i_ende:
reti


ADC_i:
	push temp
	in temp,SREG
	push temp

	sbr flags,(1<<NewADCData)
	in ADCData,ADCH
	inc bla
	//mov ADCData,bla

	pop temp
	out SREG,temp
	pop temp
reti


RESET:

ldi temp,0
mov null,temp
ldi temp,1
mov eins,temp
ldi temp,0xFF
mov voll,temp
clr bla
clr flags


ldi temp,HIGH(RAMEND)
out SPH,temp
ldi temp,LOW(RAMEND)
out SPL,temp


ldi temp,0b00111111
out DDRA,temp
ser temp
out DDRB,temp
out DDRD,temp
clr temp
out DDRC,temp
out PORTC,temp



cbi PORTA,A8
cbi PORTA,A9
cbi PORTA,A10
cbi PORTA,A10
sbi PORTA,RAS
sbi PORTA,CAS
sbi PORTA,WE


 ; Baudrate einstellen
ldi temp, HIGH(UBRRVAL)
out UBRRH, temp
ldi temp, LOW(UBRRVAL)
out UBRRL, temp

 
; Frame-Format: 8 Bit
ldi temp, (1<<URSEL)|(3<<UCSZ0)
out UCSRC, temp
 
sbi UCSRB,TXEN                    ; TX aktivieren
sbi UCSRB,RXEN					  ; RX aktivieren
sbi UCSRB,TXCIE


ldi temp,0b01100111	; ADC 7, Left Adjust Result
out ADMUX,temp
ldi temp,0b11101101	; ADC aktivieren,  Aref = AVCC, Prescaler = 32, Free Running mode
out ADCSRA,temp

;ldi temp,0b01111001	; Timer 2 als PWM, Prescaler = 1
;out TCCR2,temp

ldi temp,0b00000010	; Timer fr Refresh
out TCCR0,temp

ldi temp,0b00000101
out TCCR1B,temp

ldi temp,0b00000101	;Interrupt fr Refresh und Interrupt fr die Ausgabe
out TIMSK,temp

clr addrL			;24bit Adresszhler (21bit bentigt fr 2MByte)
clr addrM
clr addrH

clr RCount			;Refresh Counter
clr timer
clr timer2

	
/*ldi RamByte, 255
ramtst:					        ;Memory Test
	rcall WriteByte
	inc addrL
	dec RamByte
	brne ramtst

ldi addrL, 0
ldi temp, 255
ramtst2:
	rcall ReadByte
	mov temp,RamByte
	rcall serout
	inc addrL
	brne ramtst2


ldi addrL, 0*/



sei


Main:
	sbrc flags,NeedDramRefresh
	rcall Refresh
	sbrc flags,startFlushDram
	rcall leereRam
	sbrc flags,NewADCData
	rcall writeADCDataByte
	rjmp Main


Refresh:
	cli

	sbr flags,(1<<DRamRefreshBusy)
	sbi PORTA,WE
	cbi PORTA,CAS

	cbi PORTA,RAS	; 8 Refreshcycles to save Interrupt overhead
	nop
	sbi PORTA,RAS
	nop
	cbi PORTA,RAS	
	nop
	sbi PORTA,RAS
	nop
	cbi PORTA,RAS	
	nop
	sbi PORTA,RAS
	nop
	cbi PORTA,RAS	
	nop
	sbi PORTA,RAS
	nop
	cbi PORTA,RAS	
	nop
	sbi PORTA,RAS
	nop
	cbi PORTA,RAS	
	nop
	sbi PORTA,RAS
	nop
	cbi PORTA,RAS	
	nop
	sbi PORTA,RAS
	nop
	cbi PORTA,RAS	
	nop
	sbi PORTA,RAS


	sbi PORTA,CAS
	clr RCount
	cbr flags,(1<<NeedDramRefresh)|(1<<DRamRefreshBusy)
	sei
ret


leereRam:
	clr addrL
	clr addrM
	clr addrH
	rcall readByte
	mov temp,RamByte
	rcall serout
	cbr flags, (1<<startFlushDram)
ret

writeADCDataByte:
	mov RamByte,ADCData
	rcall WriteByte

	cbr flags,(1<<NewADCData)	

	add addrL,eins			;24 bit Adresszhler hochzhlen
	adc addrM,null
	adc addrH,null
	sbrc addrH,3			;Speicher voll ?
	rjmp writeADCDataByte_speicher_voll

	rjmp writeADCDataByte_ende

writeADCDataByte_speicher_voll:
	cbi ADCSRA,ADEN

writeADCDataByte_ende:	
ret


WriteByte:

	sbr flags, (1<<RWOpRunning)

	sbi PORTA, CAS
	sbi PORTA, RAS

	out PORTB, addrL			;Low Adressbyte ausgeben
	cbi PORTA, A8				;A8 Ausgeben, ist beim AVR etwas kompliziert, da kein direkter Bit -> IO Transfer mglich ist
	sbrc addrH, 0
	sbi PORTA, A8	 

	/*cbi PORTA, A9				;A9 Ausgeben, ist beim AVR etwas kompliziert, da kein direkter Bit -> IO Transfer mglich ist
	sbrc addrH, 1
	sbi PORTA, A9
	
	cbi PORTA, A10				;A10 ... blablabla
	sbrc addrH,2
	sbi PORTA, A10	 */
	
	nop
	cbi PORTA, RAS				;Zeilen Adresse im DRAM Speichern

	out PORTB, addrM			;Mid Adressbyte ausgeben
	cbi PORTA, A8				;A8 Ausgeben, ist beim AVR etwas kompliziert, da kein direkter Bit -> IO Transfer mglich ist
	sbrc addrH, 1
	sbi PORTA, A8	 

	/*cbi PORTA, A9				;A9 Ausgeben, ist beim AVR etwas kompliziert, da kein direkter Bit -> IO Transfer mglich ist
	sbrc addrH, 4
	sbi PORTA, A9	

	cbi PORTA, A10				;A10 ... blablabla ;)
	sbrc addrH, 5
	sbi PORTA, A10*/

	out DDRC,voll
	nop

	out PORTC, RamByte				;Byte ausgeben

	nop
	cbi PORTA, WE				;Eearly Write aktivieren

	nop	 
	cbi PORTA, CAS				;Spalten Adresse im DRAM Speichern


	nop
	nop

	sbi PORTA, WE				;Write deaktivieren

	sbi PORTA, CAS				;CAS deaktivieren


	sbi PORTA, RAS				;RAS deaktivieren

	out DDRC,null
	out PORTC,null

	cbr flags, (1<<RWOpRunning)

	sbrc flags, NeedDramRefresh
	rcall Refresh

ret

ReadByte:

	sbr flags, (1<<RWOpRunning)	

	sbi PORTA, CAS
	sbi PORTA, RAS
	out DDRC, null				;IO auf Eingang schalten
	out PORTC,voll

	out PORTB, addrL			;Low Adressbyte ausgeben
	cbi PORTA, A8				;A8 Ausgeben, ist beim AVR etwas kompliziert, da kein direkter Bit -> IO Transfer mglich ist
	sbrc addrH, 0
	sbi PORTA, A8	 

	/*cbi PORTA, A9				;A9 Ausgeben, ist beim AVR etwas kompliziert, da kein direkter Bit -> IO Transfer mglich ist
	sbrc addrH, 1
	sbi PORTA, A9	 

	cbi PORTA, A10				;A10 ... blablabla
	sbrc addrH,2
	sbi PORTA, A10*/
	
	cbi PORTA, RAS				;Zeilen Adresse im DRAM Speichern

	out PORTB, addrM			;Mid Adressbyte ausgeben
	cbi PORTA, A8				;A8 Ausgeben, ist beim AVR etwas kompliziert, da kein direkter Bit -> IO Transfer mglich ist
	sbrc addrH, 1
	sbi PORTA, A8	 

	/*cbi PORTA, A9				;A9 Ausgeben, ist beim AVR etwas kompliziert, da kein direkter Bit -> IO Transfer mglich ist
	sbrc addrH, 4
	sbi PORTA, A9	 

	cbi PORTA, A10				;A10 ... blablabla ;)
	sbrc addrH, 5
	sbi PORTA, A10*/
	
	nop
	cbi PORTA, CAS				;Spalten Adresse im DRAM Speichern

	
	
	;cbi PORTA, OE				;OE aktivieren

	nop
	nop
	nop
	in RamByte, PINC				;Byte lesen

	;sbi PORTA, OE				;OE deaktivieren

	sbi PORTA, CAS				;CAS deaktivieren

	sbi PORTA, RAS				;RAS deaktivieren

	out PORTC,null
	out DDRC, null				;IO auf Ausgang schalten

	cbr flags, (1<<RWOpRunning)

	sbrc flags, NeedDramRefresh
	rcall Refresh

ret

serout:
        sbis UCSRA,UDRE                   ; Warten bis UDR fr das nchste
                                          ; Byte bereit ist
        rjmp serout
        out UDR, temp
        ret                               ; zurck zum Hauptprogramm 
