/*************************************************************************
Title:    example program for the shift register library
Author:   DjElko <djelko@djelko.de>   http://www.djelko.de
Hardware: Any AVR, tested on ATmega32 at 16MHz
		  One or more74hc595 shift register IC
DESCRIPTION:
          This example shows how to use the Shift register library shift.c

*************************************************************************/

/* These Standard librarys are not necessary for the Shift register library
   to work but I included them nevertheless. */
   
/*********************/
#include <avr/pgmspace.h>
#include <stdint.h>
#include <stdlib.h>

/*********************/

/* Required librarys */
#include <avr/io.h>
#include <util/delay.h>

/* ...and the shift register library itself */
#include "shift.c"

/* Sleeping function (only for the running light required) */
void sleep_ms (uint16_t ms);
 
int main(void)
{
	/* Initalize the variable defining which led is on */
	uint16_t i=0;
	
	/* Initalize outputs for the shift register */
	shift_init(); 
	
	while(1){
			
		/* Send i to Shift register */
		shift_out(_BV(i));
		
		/* Increase i with 1 */
		i++;
		
		/* Reset i if it reaches the last led (if you are using more than one shift registers, */
		/* replace the 8 with the number of driven leds) */
		if(i>=8){
			i=0;
		}
		
		/* Wait a bit so the human eye can see the light "running" */
		sleep_ms(100);
	
	}
	
}


void sleep_ms (uint16_t ms)
{
    while (ms--)
        _delay_ms (1);
}