/************************************************************************
Title:    Shift register library for 74hc595
Author:   DjElko <djelko@djelko.de>   http://www.djelko.de
Hardware: Any AVR, tested on ATmega32 at 16MHz and 32MHz
		  (i know that 32MHz is over the limit but my AVR worked fine)
		  One or more74hc595 shift register IC
DESCRIPTION:
          This library can control multiple shift register ICs 74hc595
************************************************************************/

#define DATA_PORT  PORTC
#define DATA_PIN   0
#define LATCH_PORT PORTC
#define LATCH_PIN  1
#define CLOCK_PORT PORTC
#define CLOCK_PIN  2
 
#define DATA_low()  DATA_PORT&=~_BV(DATA_PIN)
#define DATA_high() DATA_PORT|=_BV(DATA_PIN)
#define CLOCK_low()  CLOCK_PORT&=~_BV(CLOCK_PIN)
#define CLOCK_high() CLOCK_PORT|=_BV(CLOCK_PIN)
#define LATCH_low()  LATCH_PORT&=~_BV(LATCH_PIN)
#define LATCH_high() LATCH_PORT|=_BV(LATCH_PIN)


void shift_init (void)
{
    DDRC  = 0b00000111;
    PORTC = 0b00000000;
}
 
void shift_out(unsigned char __led_state)
{

	/* Loop for the individual outputs */
	/* Replace the 8 with the number of driven leds if you are using more than one shift register */
	for (int i=0;i<8;i++)
	{
		if (bit_is_set(__led_state, i)) 
			/* Bit is high -> put high signal on Data line */
			DATA_high();	
		else 
			/* Bit is low -> put low signal on Data line */
			DATA_low();
			
		/* Gernerate rising edge on Clock line (shift signal of the Data-line into the storage register) */
		CLOCK_low();
		CLOCK_high();
		DATA_low();
	}
		/* Generate rising edge on Latch line (put the data from the storage register into the output register) */
		LATCH_low();
		LATCH_high();
	
}