#ifndef _ds18b20_h_
#define _ds18b20_h_


extern u8 idata onwi_buff[9];		// result up to 9 bytes

#define ONWI_DELAY_S(x) (u8)(XTAL / 6.0 / 65536 * x)	// X <= 4.5s !!!

#define LOAD60us	(u16)(-XTAL / 6.0 * 60e-6)
#define LOAD480us	(u16)(-XTAL / 6.0 * 480e-6)

#define ONWI_WIRE0	0x10		// P3.4
//#define ONWI_WIRE0	0x04		// P3.2
#define	ONWI_WIRE1	0x40		// P3.6
#define ONWI_PORT	P3

#define ONWI_START	21		// start one wire action

#define ONWI_SKIP_ROM	0xCC
#define ONWI_READ_ROM	0x33
#define ONWI_CONVERT_T	0x44
#define ONWI_READ_T	0xBE


#define onwi_busy()	TR0			// 0 = one wire finished

bit onwi_read_rom( u8 sensor );			// read ROM 8 byte
bit onwi_measure( void );			// start measuring
bit onwi_read_temp( u8 sensor, u8 delay );	// read data 9 byte
void onwi_init( void );				// initialization


#endif
