// --- [global.h] -------------------------------------------------------------

#include <avr/io.h>
//#include "BC_debug.H"

#ifndef EXTERN
#define EXTERN extern
#endif

// --- Globale Variables ------------------------------------------------------

#define TON					500			// 4.000.000 / (2 * 500) = 4000 Hz
//#define TON_H				3
//#define TON_L				232

#define ERR_NO_AKKU		1
#define ERR_UREF			2
#define ERR_TIMEOUT		3
#define ERR_TEMP			4
#define ERR_FULL			5
#define ERR_READY			6
#define ERR_AKKU_LOST	7
#define ERR_WDT			8

#define PWM_TOP			500			// Obergrenze fr 9Bit PWM (512)

#define U					0				// status[]
#define I					1					

#define U_REF		((1<<REFS0) + 0)	// ADC0
#define I_BATT		((1<<REFS0) + 1)	// ADC1
#define U_BATT		((1<<REFS0) + 2)	// ADC2
#define U_TEMP		((1<<REFS0) + 3)	// ADC3

// --- Function prototypes ----------------------------------------------------

void Stop_PWM(void);
void Start_PWM(void);
uint16_t messreihe(uint8_t channel);
uint8_t messung_uref(void);
void err_msg(uint8_t error);

// --- Extern function prototypes ---------------------------------------------

EXTERN volatile uint8_t COUNTER10;
EXTERN volatile uint8_t COUNTER80;
EXTERN volatile uint8_t FLAG;

EXTERN void FAST_charge(void);
EXTERN void TRICKLE_charge(void);

EXTERN uint16_t charge_time;
EXTERN uint16_t status[2];				// Messwerte Spannung, Strom, 
EXTERN char msg[6];						// globale Variable fr utoa() etc.

// --- Struct definition ------------------------------------------------------

typedef struct
{
uint8_t sec;                    		// global seconds
uint8_t min;                    		// global minutes
uint8_t hour;                   		// global hour
} time_struct;

typedef struct
{
uint16_t fast_C;                  	// Ladedauer der drei Phasen
uint16_t fast_U;             
uint16_t trickle;           
} lade_struct;

EXTERN time_struct time;            // Globale struct
EXTERN lade_struct charge;

// --- [ eof ] ----------------------------------------------------------------

