/*
 * PCB Exposure Timer, hal.h
 *
 * (c) Axel (XL) Schwenke, axel.schwenke@gmx.net
 *
 * $Id: hal.h 220 2013-10-29 20:36:44Z schwenke $
 *
 *
 *                    AT90S2313
 *                ------------------
 * ISP           | 1 Reset    Vcc 20| Vcc
 * NSM4202, /OE  | 2 PD0      SCK 19| ISP
 * NSM4202, CLK  | 3 PD1     MISO 18| ISP
 * Xtal          | 4 Xtal1   MOSI 17| ISP
 * Xtal          | 5 Xtal2    PB4 16|
 * NSM4202, DATA | 6 PD2      PB3 15|
 * Piezo Buzzer  | 7 PD3      PB2 14|
 * Bulb, H=on    | 8 PD4      PB1 13| Encoder, B
 * Piezo Buzzer  | 9 PD5      PB0 12| Encoder, A
 * GND           |10 GND      PD6 11| Encoder, Push-Button
 *                ------------------
 *
 *  NSM4202
 *  --------
 * | 1 /OE  | PD0
 * | 2 DATA | PD2
 * | 3 CLK  | PD1
 * | 4 Vcc1 | Vcc
 * | 6 GND  | GND
 * | 7 Vcc2 | Vcc
 * | 8 Aux1 | LED green  "Ready"   (data bit #34)
 * | 9 Aux2 | LED yellow "Running" (data bit #33)
 * |10 Aux3 | LED red    "Done"    (data bit #8)
 * |11 Aux4 |
 * |12 Aux5 |
 *  --------
 */

#ifndef HAL_H
#define HAL_H


/* hardware dependent macros */

#define oe_pin          0 /* port D */
#define clk_pin         1
#define data_pin        2
#define buzzer_pin_a    3
#define bulb_pin        4
#define buzzer_pin_b    5
#define button_pin      6

#define enc_pin_a       0 /* port B */
#define enc_pin_b       1

#define oe_hi()         PORTD |=  _BV(oe_pin)
#define oe_lo()         PORTD &= ~_BV(oe_pin)
#define clk_hi()        PORTD |=  _BV(clk_pin)
#define clk_lo()        PORTD &= ~_BV(clk_pin)
#define data_hi()       PORTD |=  _BV(data_pin)
#define data_lo()       PORTD &= ~_BV(data_pin)
#define bulb_on()       PORTD |=  _BV(bulb_pin)
#define bulb_off()      PORTD &= ~_BV(bulb_pin)

#define wait()          _delay_us(1)

#define phase_A         ( PINB & _BV(enc_pin_a) )
#define phase_B         ( PINB & _BV(enc_pin_b) )
#define sample_button   ( PIND & _BV(button_pin) ? 0 : 1 )


/* MCU dependent macros */

#if defined (__AVR_AT90S2313__)

#define buzzer_off()    TCCR0 = 0
#define buzzer_on()     TCCR0 = _BV(CS01)


#elif defined (__AVR_ATtiny2313__)

#define buzzer_off()    TCCR0B = 0
#define buzzer_on()     TCCR0B = _BV(CS01)

FUSES =
{
    /* CKSEL3..1 = 110 .... xtal oscillator 3..8MHz
       CKSEL0=1, SUT=01 ... xtal oscillator, BOD enabled */
    .low      = (FUSE_CKSEL1 & FUSE_SUT1),
    /* SPIEN = 1 .......... SPI enabled
       BOD2..0 = 100 ...... BOD @ 4.3V */
    .high     = (FUSE_SPIEN & FUSE_BODLEVEL1 & FUSE_BODLEVEL0),
    .extended = EFUSE_DEFAULT
};


#else
#error unknown MCU!
#endif


#endif /* HAL_H */
