/*
 * Copyright (c) 2001, Swedish Institute of Computer Science.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Author: Adam Dunkels <adam@sics.se>
 *
 * $Id: tapdev.c,v 1.8 2006/06/07 08:39:58 adam Exp $

 TUN und TAP sind virtuelle Netzwerk-Kernel-Treiber,
 die Netzwerkgeräte über Software simulieren.
 Während sich normalerweise hinter einem Netzwerkgerät
 (wie zum Beispiel eth0) direkt eine entsprechende Hardware
 in Form einer Netzwerkkarte verbirgt, werden Pakete, die
 an ein TUN/TAP-Gerät gesendet werden, an ein Programm im
 Userspace weitergeleitet und andersherum. Damit ein
 Userspace-Programm auch auf TUN/TAP-Geräte zugreifen kann,
 haben diese im Gegensatz zu realen Ethernet-Karten eine
 Gerätedatei mit der Bezeichnung tunN bzw. tapN unterhalb von
 /dev.

 */

#include "networkdevice.h"
#include "lpc17xx_emac.h"

/*---------------------------------------------------------------------------*/
void 
tapdev_init(void)
{
	EMAC_Init();
}

/*---------------------------------------------------------------------------*/
unsigned int
tapdev_read(void *pPacket)
{
	return EMAC_ReadPacket(pPacket);
}
//packet_length = ETH_PACKET_RECEIVE(MTU_SIZE,(uint8_t *)eth_buffer);
unsigned int
tapdev_readx(int abfr,void *pPacket)
{
	return EMAC_ReadPacket(pPacket);
}
/*---------------------------------------------------------------------------*/
void
tapdev_send(void *pPacket, unsigned int size)
{
	EMAC_SendPacket(pPacket, size);
}
/*---------------------------------------------------------------------------*/
tapdev_sendx( unsigned int size,void *pPacket)
{
	EMAC_SendPacket(pPacket, size);
}
/*---------------------------------------------------------------------------*/
