/*
 * bmc.c
 *
 *  Created on: 02.03.2014
 *      Author: ms
 */

#include <avr/interrupt.h>
#include <util/delay.h>
#include "bmc.h"
/*
 * twimaster.h		Peter Fleurys Lib
 * twi-master.h		Atmels Lib??
 */
#include "twi-master.h"

#define BLINKM_ADDR				0x12

unsigned char message[5];
unsigned char ret;

void BlinkM_Init()
{
#if defined(_TWIMASTER_H)		// FLeury
	i2c_start_wait(BLINKM_ADDR + I2C_WRITE);
	i2c_write(CMD_FADE_SPEED);
	i2c_write(0x04);
	i2c_stop();

	i2c_start_wait(BLINKM_ADDR + I2C_WRITE);
	i2c_write(CMD_PLAY_SCRIPT);
	i2c_write(0x0a); i2c_write(0x01); i2c_write(0x00);
	i2c_stop();
#else
	message[0] = (BLINKM_ADDR<<TWI_ADR_BITS) | (FALSE<<TWI_READ_BIT);
	message[1] = CMD_FADE_SPEED;
	message[2] = 0x04;
	TWI_Start_Transceiver_With_Data(message, 3);

	message[1] = CMD_PLAY_SCRIPT;
	message[2] = 0x0a;
	message[3] = 0x01;
	message[4] = 0x00;
	TWI_Start_Transceiver_With_Data(message, 5);
#endif

	BlinkM_Off();
}

void BlinkM_Off()
{
#if defined(_TWIMASTER_H)		// FLeury
	i2c_start_wait(BLINKM_ADDR + I2C_WRITE);
	i2c_write(CMD_FADE_RGB);
	i2c_write(0x00);
	i2c_write(0x00);
	i2c_write(0x00);
	i2c_stop();
#else
	message[0] = (BLINKM_ADDR<<TWI_ADR_BITS) | (FALSE<<TWI_READ_BIT);
	message[1] = CMD_FADE_RGB;
	message[2] = 0x00;
	message[3] = 0x00;
	message[4] = 0x00;
	TWI_Start_Transceiver_With_Data(message, 5);
#endif
}

void BlinkM_On()
{
#if defined(_TWIMASTER_H)
	i2c_start_wait(BLINKM_ADDR + I2C_WRITE);
	i2c_write(CMD_FADE_RGB);
	i2c_write(0x70);
	i2c_write(0x00);
	i2c_write(0x70);
	i2c_stop();
#else
	message[0] = (BLINKM_ADDR<<TWI_ADR_BITS) | (FALSE<<TWI_READ_BIT);
	message[1] = CMD_FADE_RGB;
	message[2] = 0x70;
	message[3] = 0x00;
	message[4] = 0x70;
	TWI_Start_Transceiver_With_Data(message, 5);
#endif
}
