//************************************************
//*** Debouncing 8 Keys                        ***
//*** Sampling 4 Times                         ***
//*** With Repeat Function                     ***
//***                                          ***
//*** Author:      Peter Dannegger             ***
//*** Modified by: Thomas Finke                ***
//************************************************

#define KEY_DDR         DDRB
#define KEY_PORT        PORTB
#define KEY_PIN         PINB

#define KEY0            0
#define KEY1            1
#define KEY2            2
#define KEY3            3

#define KEY_MENU		KEY0
#define KEY_ENTER		KEY1
#define KEY_UP			KEY2
#define KEY_DOWN		KEY3

#define ALL_KEYS        (1<<KEY0 | 1<<KEY1 | 1<<KEY2 | 1<<KEY3)
 
//#define REPEAT_MASK     0
#define REPEAT_MASK     (1<<KEY0 | 1<<KEY1 | 1<<KEY2 | 1<<KEY3)	// repeat: key1, key2
#define REPEAT_START    50                        			// after 500ms
#define REPEAT_NEXT     20                       			// every 200ms

unsigned char key_state;                                	// debounced and inverted key state: bit = 1 --> key pressed
unsigned char key_press;                                	// key press detect
unsigned char key_rpt;                                  	// key long press and repeat

//Functionprototypes
void key_init(void);
void key_debounce(void);
unsigned char get_key_press(unsigned char key_mask);
unsigned char get_key_rpt(unsigned char key_mask);
unsigned char get_key_short(unsigned char key_mask);
unsigned char get_key_long(unsigned char key_mask);

