
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
/*
 * twimaster.h		Peter Fleurys Lib
 * twi-master.h		Atmels Lib??
 */
#include "twi-master.h"		//TWI-Routinen von Peter Fleury <pfleury@gmx.ch> http://jump.to/fleury
#include "i2c_lcd.h"

unsigned char message[2];

void i2c_lcd_send(char data)
{
#if defined(_TWIMASTER_H)					// FLeury
	//	cli();
	i2c_start_wait(I2CLCD + I2C_WRITE);		// set device address and write mode
	i2c_write(data);						//Command Byte PCF8574
	i2c_stop();
	// sei();
#else
	message[0] = (I2CLCD<<TWI_ADR_BITS) | (FALSE<<TWI_READ_BIT);
	message[1] = data;
	TWI_Start_Transceiver_With_Data(message, 2);
#endif
}

void lcd_4bit(unsigned char data)
{
	i2c_lcd_send(data);
	lcd_enable();
	_delay_ms(3);
}

// sendet ein Datenbyte an das LCD
void lcd_data(unsigned char data)
{
	int temp;

	// Write to display upper nibble
	temp = data >> 4;
	temp = temp | 0x10;
	i2c_lcd_send(temp);					//oberes Nibbel Ausgeben
	lcd_enable();

	// Write to display lower nibble
	temp = data & 0x0f;
	temp = temp | 0x10;
	i2c_lcd_send(temp);					//unteres Nibbel Ausgeben
	lcd_enable();

	//kpause();
}

//sendet einen Befehl an das LCD
void lcd_command(unsigned char data)
{
	int temp;

	// Write to display upper nibble
	temp = data >> 4;
	i2c_lcd_send(temp);					//oberes Nibbel Ausgeben
	lcd_enable();

	// Write to display lower nibble
	temp = data & 0x0f;
	i2c_lcd_send(temp);					//unteres Nibbel Ausgeben
	lcd_enable();

	//kpause();
}

//erzeugt den Enable-Puls
void lcd_enable(void)
{
	PORTC |= (1<<LCD_E);					//Enable auf High
	kpause();							//kurze pause
	PORTC &= ~(1<<LCD_E);   				//Enable auf Low
}

void waitms(uint16_t sek)
{
	int cnt;
	sek*=20;
	for (cnt=0;cnt< sek+1;cnt++)
	{
		_delay_loop_2(200);
	}
}
void waitus(uint16_t sek)
{
	sek = sek * 4;
	_delay_loop_2(sek);
}

//Pause nach jeder Übertragung
void kpause(void)
{
	_delay_us(48);						//48us Pause
}


//Längere Pause für manche Befehle
void lpause(void)
{
	_delay_ms(5);						//5ms Pause
}

//Initialisierung
void lcd_linit(void)					//Wenn der Display gleich nachdem er mit Spannung versorgt wurde
{										//in Betrieb genommen werden soll
	unsigned char i;
	for(i=0;i<10;i++)
	{
		_delay_ms(10);
	}
	lcd_init();
}

//Initialisierung
void lcd_init(void)
{
	DDRC |= (1<<LCD_E);
	PORTC &= ~(1<<LCD_E);
	_delay_ms(20);

	// Start der Initialisierung
	lcd_4bit(0x03);
	lcd_4bit(0x03);
	lcd_4bit(0x03);
	lcd_4bit(0x02);

	lpause();

	lcd_command(0x28);			// Mode: 4-Bit, 2-line, 5x7
	lcd_command(0x01);			// Clear Display
	lpause();

#if KS0073_4LINES_MODE
	/* Display with KS0073 controller requires special commands for enabling 4 line mode */
	lcd_command(KS0073_EXTENDED_FUNCTION_REGISTER_ON);
	lcd_command(KS0073_4LINES_MODE);
	lcd_command(KS0073_EXTENDED_FUNCTION_REGISTER_OFF);
#else
	lcd_command(LCD_FUNCTION_DEFAULT);      /* function set: display lines  */
#endif

	lcd_command(0x10);  		// Set cursor to move
	lcd_command(0x06);			// set cursor to move right, no shifting of LCD display
	lcd_command(0x0c);			// turn display on, cursor off, cursor blinking off

	kpause();
}

//Sendet den Befehl zur Löschung des Displays
void lcd_clear(void)
{
	lcd_command(0x01);
	lpause();
}

/*************************************************************************
Set cursor to specified position
Input:    x  horizontal position  (0: left most position)
          y  vertical position    (0: first line)
Returns:  none
 *************************************************************************/
void lcd_goto(uint8_t x, uint8_t y)
{
	uint8_t temp = 0x80;

	if (y > LCD_LINES)
		y = 0;

	if (x > LCD_DISP_LENGTH)
		x = 0;

	switch (y)
	{
	case 0:
		break;
	case 1:
		temp = temp + LCD_START_LINE2;
		break;
	case 2:
		temp = temp + LCD_START_LINE3;
		break;
	case 3:
		temp = temp + LCD_START_LINE4;
	}
	lcd_command(temp + x);
}

void lcd_conf(uint8_t conf)
{
	lcd_command(0x03);
	lcd_command(0x01);
	lcd_command(conf);
}

void lcd_home()
{
	lcd_command(0x02);
}

//gibt einen Text aus
void lcd_write(char *s)
{
	while (*s)						//so lange *s != '\0' also ungleich dem "String-Endezeichen"
	{
		lcd_data(*s);				//Zeichen ausgeben
		s++;
	}
}

/*************************************************************************
Display character at current cursor position
Input:    character to be displayed
Returns:  none
 *************************************************************************/
void lcd_putc(char c)
{
	lcd_data(c);
}
/* lcd_putc */

static inline void lcd_nibble(uint8_t n)
{
	if (n<0x0A)
		lcd_putc('0'+n);
	else
		lcd_putc('A'-0x0A+n);
}

void lcd_hex(uint8_t v)
{
	lcd_nibble(v>>4);
	lcd_nibble(v&0x0F);
}
