
#ifndef I2C_LCD_H_
#define I2C_LCD_H_

#define LCD_IO_MODE      1
/**
 * @name  Definition for LCD controller type
 * Use 0 for HD44780 controller, change to 1 for displays with KS0073 controller.
 */
#define LCD_CONTROLLER_KS0073 0  /**< Use 0 for HD44780 controller, 1 for KS0073 controller */

#define I2CLCD		0x40			// device address of Portexpander PCF8574
#define LCD_E		PC2

#define LCD_LINES           2		/**< number of visible lines of the display */
#define LCD_DISP_LENGTH    16		/**< visibles characters per line of the display */
#define LCD_LINE_LENGTH  0x40		/**< internal line length of the display    */

#if LCD_CONTROLLER_KS0073
	#define LCD_START_LINE1  0x00		/**< DDRAM address of first char of line 1 */
	#define LCD_START_LINE2  0x20		/**< DDRAM address of first char of line 2 */
	#define LCD_START_LINE3  0x40		/**< DDRAM address of first char of line 3 */
	#define LCD_START_LINE4  0x60		/**< DDRAM address of first char of line 4 */
#else
	#define LCD_START_LINE1  0x00		/**< DDRAM address of first char of line 1 */
	#define LCD_START_LINE2  0x40		/**< DDRAM address of first char of line 2 */
	#define LCD_START_LINE3  0x20		/**< DDRAM address of first char of line 3 */
	#define LCD_START_LINE4  0x50		/**< DDRAM address of first char of line 4 */
#endif

#define LCD_WRAP_LINES      0		/**< 0: no wrap, 1: wrap at end of visibile line */

#define LCD_CLR					0      /* DB0: clear display                  */
#define LCD_HOME				1      /* DB1: return to home position        */
#define LCD_ENTRY_MODE			2      /* DB2: set entry mode                 */
#define LCD_ENTRY_INC			1      /*   DB1: 1=increment, 0=decrement     */
#define LCD_ENTRY_SHIFT			0      /*   DB2: 1=display shift on           */
#define LCD_ON					3		/* DB3: turn lcd/cursor on             */
#define LCD_ON_DISPLAY			2		/*   DB2: turn display on              */
#define LCD_ON_CURSOR			1		/*   DB1: turn cursor on               */
#define LCD_ON_BLINK			0		/*     DB0: blinking cursor ?          */
#define LCD_MOVE				4		/* DB4: move cursor/display            */
#define LCD_MOVE_DISP			3		/*   DB3: move display (0-> cursor) ?  */
#define LCD_MOVE_RIGHT			2		/*   DB2: move right (0-> left) ?      */
#define LCD_FUNCTION			5      /* DB5: function set                   */
#define LCD_FUNCTION_8BIT		4      /*   DB4: set 8BIT mode (0->4BIT mode) */
#define LCD_FUNCTION_2LINES		3      /*   DB3: two lines (0->one line)      */
#define LCD_FUNCTION_10DOTS		2      /*   DB2: 5x10 font (0->5x7 font)      */
#define LCD_CGRAM				6		/* DB6: set CG RAM address             */
#define LCD_DDRAM				7		/* DB7: set DD RAM address             */
#define LCD_BUSY				7		/* DB7: LCD is busy                    */

/* set entry mode: display shift on/off, dec/inc cursor move direction */
#define LCD_ENTRY_DEC            0x04   /* display shift off, dec cursor move dir */
#define LCD_ENTRY_DEC_SHIFT      0x05   /* display shift on,  dec cursor move dir */
#define LCD_ENTRY_INC_           0x06   /* display shift off, inc cursor move dir */
#define LCD_ENTRY_INC_SHIFT      0x07   /* display shift on,  inc cursor move dir */

/* display on/off, cursor on/off, blinking char at cursor position */
#define LCD_DISP_OFF             0x08   /* display off                            */
#define LCD_DISP_ON              0x0C   /* display on, cursor off                 */
#define LCD_DISP_ON_BLINK        0x0D   /* display on, cursor off, blink char     */
#define LCD_DISP_ON_CURSOR       0x0E   /* display on, cursor on                  */
#define LCD_DISP_ON_CURSOR_BLINK 0x0F   /* display on, cursor on, blink char      */

/* move cursor/shift display */
#define LCD_MOVE_CURSOR_LEFT     0x10   /* move cursor left  (decrement)          */
#define LCD_MOVE_CURSOR_RIGHT    0x14   /* move cursor right (increment)          */
#define LCD_MOVE_DISP_LEFT       0x18   /* shift display left                     */
#define LCD_MOVE_DISP_RIGHT      0x1C   /* shift display right                    */

/* function set: set interface data length and number of display lines */
#define LCD_FUNCTION_4BIT_1LINE  0x20   /* 4-bit interface, single line, 5x7 dots */
#define LCD_FUNCTION_4BIT_2LINES 0x28   /* 4-bit interface, dual line,   5x7 dots */
#define LCD_FUNCTION_8BIT_1LINE  0x30   /* 8-bit interface, single line, 5x7 dots */
#define LCD_FUNCTION_8BIT_2LINES 0x38   /* 8-bit interface, dual line,   5x7 dots */

#if LCD_IO_MODE
#if LCD_LINES==1
#define LCD_FUNCTION_DEFAULT    LCD_FUNCTION_4BIT_1LINE
#else
#define LCD_FUNCTION_DEFAULT    LCD_FUNCTION_4BIT_2LINES
#endif
#else
#if LCD_LINES==1
#define LCD_FUNCTION_DEFAULT    LCD_FUNCTION_8BIT_1LINE
#else
#define LCD_FUNCTION_DEFAULT    LCD_FUNCTION_8BIT_2LINES
#endif
#endif

#if LCD_CONTROLLER_KS0073
#if LCD_LINES==4

#define KS0073_EXTENDED_FUNCTION_REGISTER_ON  0x24   /* |0|010|0100 4-bit mode extension-bit RE = 1 */
#define KS0073_EXTENDED_FUNCTION_REGISTER_OFF 0x20   /* |0|000|1001 4 lines mode */
#define KS0073_4LINES_MODE                    0x09   /* |0|001|0000 4-bit mode, extension-bit RE = 0 */

#endif
#endif

#define LCD_MODE_DEFAULT     ((1<<LCD_ENTRY_MODE) | (1<<LCD_ENTRY_INC) )

void lcd_4bit(unsigned char data);
extern void lcd_data(unsigned char data);
extern void lcd_command(unsigned char data);
extern void lcd_enable(void);
extern void kpause(void);
extern void lpause(void);
extern void lcd_linit(void);
extern void lcd_init(void);
extern void lcd_clear(void);
extern void lcd_goto(uint8_t x, uint8_t y);
extern void lcd_conf(uint8_t conf);
extern void lcd_home();
extern void lcd_write(char *s);
extern void lcd_putc(char c);
extern void lcd_hex(uint8_t v);
#endif /* I2C_LCD_H_ */
