/*
 * main.c
 *
 *  Created on: 02.03.2014
 *      Author: ms
 */

#ifndef F_CPU
#define F_CPU 11059200UL     //Prozessor Frequenz in Hz
#endif

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <stdio.h>
/*
 * twimaster.h		Peter Fleurys Lib
 * twi-master.h		Atmels Lib??
 */
#include "twi-master.h"
#include "debounce.h"
#include "i2c_lcd.h"
#include "bmc.h"

unsigned char DauerFeuer = 0;
unsigned char LightOn = 0;
unsigned char LightTimer = 10;
unsigned char LightMode = 0;		// 0 - normal Light; 1 - BlinkM
unsigned char ToggleMode = 0;
unsigned char StartLight = 0;

void timer_init(void);
void switchLightOn();
void switchLightOff();
void toggleLight();

void init(void)
{
	//Ausgänge für LED-Boards konfigurieren
	PORTA &= ~( (1<<PA0) | (1<<PA1) | (1<<PA2) | (1<<PA3) | (1<<PA5) | (1<<PA6) );
	DDRA |= (1<<PA0) | (1<<PA1) | (1<<PA2) | (1<<PA5) | (1<<PA6);

#if defined(_TWIMASTER_H)
	i2c_init();
#else
	sei();
	TWI_Master_Initialise();
#endif

	timer_init();
	BlinkM_Init();

	lcd_linit();
	lcd_clear();

	key_init();
}

void timer_init(void)
{
	//Timer 0
	TCCR0 = (1<<CS02)|(1<<CS00);			// divide by 1024
	TIMSK = 1<<TOIE0;						// enable timer interrupt

	//Timer 1
	TCCR1A = (0<<COM1A1) | (0<<COM1A0) | (0<<COM1B1) | (0<<COM1B0) | (0<<WGM11) | (0<<WGM10);
	TCCR1B = (0<<ICNC1) | (0<<ICES1) | (0<<WGM13) | (1<<WGM12) | (1<<CS12) | (0<<CS11) | (1<<CS10);
	OCR1A = 11059; //15625; 				//jede Sekunde
	TIMSK |= (1<<OCIE1A);
}

int main(void)
{
	init();
	sei();

	char tmp[4];

	lcd_goto(0, 0);
	lcd_write("Restzeit: ");

	while (1)
	{
		// Lichttaster gedrückt
	    if (!LightOn && get_key_short(1<<KEY0))
	    {
	    	LightTimer = 10;
	    	StartLight = 1;
	    }

	    // Taster gedrückt während das Licht an ist -> Zeit verlängern
	    if (LightOn && get_key_short(1<<KEY0))
	    {
	    	LightTimer = LightTimer + 10;
	    }

	    // Lichtmodus wechseln
	    if (get_key_long(1<<KEY0))
	    {
	    	toggleLight();
	    }

	    // Dauerlicht an/aus
		if (get_key_long(1<<KEY3))
		{
			if (DauerFeuer == 0)
			{
				DauerFeuer = 1;
				PORTA |= (1<<PA6);
				switchLightOn();
			}
			else
			{
				DauerFeuer = 0;
				PORTA &= ~((1<<PA6));
				LightTimer = 10;
			}
		}

		if (StartLight == 1)
		{
			StartLight = 0;
			switchLightOn();
		}

//		lcd_goto(11, 0);
//		sprintf(tmp, "%03d", LightTimer);
//		lcd_write(tmp);
	}
	return 0;
}

void switchLightOn()
{
	if (LightMode == 0)
	{
		PORTA |= (1<<PA0);
	}
	else
	{
		BlinkM_On();
	}
	LightOn = 1;
}

void switchLightOff()
{
	if (DauerFeuer)
		return;

	if (LightMode == 0)
	{
		PORTA &= ~( (1<<PA0) );
	}
	else
	{
		BlinkM_Off();
	}
	LightOn = 0;
}

/*
 * Wechselt den LichtModus
 */
void toggleLight()
{
	if (LightMode == 0)
	{
		// Use BlinkM
		LightMode = 1;

		PORTA |= (1<<PA5);

		// Wenn Licht schon an
		if (LightOn)
		{
			PORTA &= ~( (1<<PA0) );
			BlinkM_On();
		}
	}
	else
	{
		// Use normal Light
		LightMode = 0;
		PORTA &= ~((1<<PA5));

		// Wenn Licht schon an
		if (LightOn)
		{
			BlinkM_Off();
			PORTA |= (1<<PA0);
		}
	}
}

//**********************************
//*** Interrupt Service Routinen ***
//**********************************
ISR (TIMER0_OVF_vect)                            				// every 10ms
{
	TCNT0 = 11; //(uint8_t)(int16_t)-(F_CPU / 1024 * 10e-3 + 0.5);  	// preload for 10ms
	key_debounce();
}

ISR (TIMER1_COMPA_vect)	//jede Sekunde
{
	if (LightOn && !DauerFeuer)
	{
		if (LightTimer > 0)
		{
			LightTimer--;
		}

		if (LightTimer == 0)
		{
			switchLightOff();
		}
	}
}
