//--------------------------------------------------------------
// File     : main.c
// Datum    : 06.10.2013
// Version  : 1.1
// Autor    : UB
// EMail    : mc-4u(@)t-online.de
// Web      : www.mikrocontroller-4u.de
// CPU      : STM32F4
// IDE      : CooCox CoIDE 1.7.0
// Module   : CMSIS_BOOT, M4_CMSIS_CORE
// Funktion : Demo der Font-Library
// Hinweis  : Diese zwei Files muessen auf 8MHz stehen
//              "cmsis_boot/stm32f4xx.h"
//              "cmsis_boot/system_stm32f4xx.c"
//--------------------------------------------------------------

#include "main.h"
#include "stm32_ub_lcd_ssd2119.h" //"stm32_ub_lcd_st7783.h"
#include "stm32_ub_font.h"s

int main(void)
{
	uint16_t i,j=0;
	char B2[80];

	SystemInit(); // Quarz Einstellungen aktivieren

	UB_LCD_Init(); // init vom LCD

	// Bildschirm lschen
	UB_LCD_FillScreen(RGB_COL_BLACK);

	for(i=0;i<240;i+=26){ // alle zwei Zeilen 40 zeichen des berhmten Text ausgeben
		UB_Font_DrawString(0,i,"The quick brown fox jumps over the lazy ",&Arial_8x13,RGB_COL_YELLOW,RGB_COL_BLACK);
	}

	// gnstiger Punkt fr breakpoint damit man sieht, dass der Text sauber auf dem Disp erscheint.
	while(1){

		// und nun Display RAM versemmeln...
		sprintf(B2,"%04X",j++);
		// oben links in magenta
		// diese Zeile auskommentieren und das Display bleibt sauber.
		UB_Font_DrawString(10,32,B2,&Arial_14x22,RGB_COL_MAGENTA,RGB_COL_BLACK);
		// unten rechts in wei
		UB_Font_DrawString(236,186,B2,&Arial_14x22,RGB_COL_WHITE,RGB_COL_BLACK);
	}
}
