//--------------------------------------------------------------
// File     : ub_Font_Arial_16x25.c
// Datum    : 18.02.2013
// Version  : 1.0
// Autor    : UB
// EMail    : mc-4u(@)t-online.de
// Web      : www.mikrocontroller-4u.de
//
// Font-Settings : Monospace, Max-Width=16Pixel
// Ascii-Table   : First-Char = 32, Last-Char = 126
// Data-Layout   :
//        e.G. Ascii-'R'
//       "0x78,0x44,0x44,0x44,0x78,0x48,0x48,0x44,0x00,0x00"
//
//   0x78 = ".####..."
//   0x44 = ".#...#.."
//   0x44 = ".#...#.."
//   0x44 = ".#...#.."
//   0x78 = ".####..."
//   0x48 = ".#  #..."
//   0x48 = ".#  #..."
//   0x44 = ".#...#.."
//   0x00 = "........"
//   0x00 = "........"
//
//--------------------------------------------------------------

//--------------------------------------------------------------
// Includes
//--------------------------------------------------------------
#include "..\stm32_ub_font.h"

//--------------------------------------------------------------
// Font-Daten
// erstellt von UB mit PixelFontGenerator 1.0
//--------------------------------------------------------------
const uint16_t Arial_16x25_Table [] = {
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [ ]
0x0000,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0000,0x0000,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [!]
0x0CC0,0x0CC0,0x0CC0,0x0CC0,0x0CC0,0x0CC0,0x0CC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = ["]
0x0318,0x0318,0x0318,0x0318,0x0630,0x0630,0x3FFC,0x3FFC,0x0630,0x0630,0x0C60,0x0C60,0x3FFC,0x3FFC,0x0C60,0x0C60,0x18C0,0x18C0,0x18C0,0x18C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [#]
0x07C0,0x1FF0,0x1D38,0x391C,0x310C,0x3100,0x3100,0x3900,0x1D00,0x0FC0,0x07F0,0x0138,0x011C,0x010C,0x310C,0x310C,0x391C,0x1D38,0x0FF0,0x07C0,0x0100,0x0100,0x0000,0x0000,0x0000, // Ascii = [$]
0x1E00,0x3F00,0x7380,0x6182,0x6186,0x618C,0x7398,0x3F30,0x1E60,0x00C0,0x0180,0x0378,0x06FC,0x0DCE,0x1986,0x3186,0x2186,0x01CE,0x00FC,0x0078,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [%]
0x0380,0x07C0,0x0C60,0x0C60,0x0C60,0x0C60,0x06C0,0x07C0,0x0780,0x0F00,0x1D80,0x19CC,0x30DC,0x3078,0x3078,0x3030,0x3078,0x18FC,0x1FCE,0x0784,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [&]
0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [']
0x0030,0x0060,0x0060,0x00C0,0x00C0,0x0180,0x0180,0x0180,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0180,0x0180,0x0180,0x00C0,0x00C0,0x0060,0x0060, // Ascii = [(]
0x0C00,0x0600,0x0600,0x0300,0x0300,0x0180,0x0180,0x0180,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x0180,0x0180,0x0180,0x0300,0x0300,0x0600,0x0600, // Ascii = [)]
0x0180,0x0180,0x0DB0,0x0FF0,0x0180,0x03C0,0x0660,0x0240,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [*]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0180,0x0180,0x0180,0x0180,0x0180,0x3FFC,0x3FFC,0x0180,0x0180,0x0180,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [+]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0180,0x0180,0x0080,0x0080,0x0080,0x0100,0x0000, // Ascii = [,]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07E0,0x07E0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [-]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [.]
0x0030,0x0030,0x0060,0x0060,0x0060,0x00C0,0x00C0,0x00C0,0x01C0,0x0180,0x0180,0x0380,0x0300,0x0300,0x0300,0x0600,0x0600,0x0600,0x0C00,0x0C00,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [/]
0x03C0,0x0FF0,0x0C30,0x1818,0x1818,0x300C,0x300C,0x300C,0x300C,0x318C,0x318C,0x300C,0x300C,0x300C,0x300C,0x1818,0x1818,0x1C30,0x0FF0,0x03C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [0]
0x00C0,0x00C0,0x01C0,0x03C0,0x0EC0,0x1CC0,0x10C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [1]
0x07E0,0x0FF0,0x1C38,0x301C,0x300C,0x300C,0x000C,0x000C,0x0018,0x0018,0x0030,0x0060,0x00C0,0x0380,0x0300,0x0600,0x0800,0x1000,0x3FFC,0x3FFC,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [2]
0x07C0,0x0FE0,0x1830,0x3018,0x3018,0x0018,0x0018,0x0070,0x03E0,0x03F0,0x0038,0x0018,0x000C,0x000C,0x300C,0x300C,0x1818,0x1C38,0x0FF0,0x07C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [3]
0x0030,0x0070,0x00F0,0x00F0,0x01B0,0x01B0,0x0330,0x0630,0x0630,0x0C30,0x0C30,0x1830,0x3030,0x3FFC,0x3FFC,0x0030,0x0030,0x0030,0x0030,0x0030,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [4]
0x3FF8,0x3FF8,0x3000,0x3000,0x3000,0x3000,0x3000,0x37C0,0x3FF0,0x3C38,0x3018,0x000C,0x000C,0x000C,0x300C,0x300C,0x1818,0x1C38,0x0FF0,0x07C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [5]
0x03E0,0x07F8,0x0E38,0x1C1C,0x180C,0x1800,0x3000,0x33E0,0x37F0,0x3C38,0x3818,0x300C,0x300C,0x300C,0x300C,0x100C,0x1818,0x0C38,0x0FF0,0x03E0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [6]
0x3FFC,0x3FFC,0x000C,0x0018,0x0030,0x0030,0x0060,0x00C0,0x00C0,0x00C0,0x0180,0x0180,0x0100,0x0300,0x0300,0x0300,0x0200,0x0600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [7]
0x03C0,0x0FF0,0x0C30,0x1818,0x1818,0x1818,0x1818,0x0C30,0x03C0,0x0FF0,0x1C38,0x381C,0x300C,0x300C,0x300C,0x300C,0x1818,0x1C38,0x0FF0,0x07E0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [8]
0x07C0,0x0FF0,0x1C30,0x1818,0x3008,0x300C,0x300C,0x300C,0x300C,0x181C,0x1C3C,0x0FEC,0x07CC,0x000C,0x0018,0x3018,0x3838,0x1870,0x1FE0,0x07C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [9]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [:]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0180,0x0180,0x0080,0x0080,0x0080,0x0100,0x0000, // Ascii = [;]
0x0000,0x0000,0x0000,0x0000,0x000C,0x003C,0x00F0,0x07C0,0x1F00,0x3C00,0x3000,0x3C00,0x1F00,0x07C0,0x00F0,0x003C,0x000C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [<]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FFC,0x3FFC,0x0000,0x0000,0x0000,0x0000,0x3FFC,0x3FFC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [=]
0x0000,0x0000,0x0000,0x0000,0x3000,0x3C00,0x0F00,0x03E0,0x00F8,0x003C,0x000C,0x003C,0x00F8,0x03E0,0x0F00,0x3C00,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [>]
0x07C0,0x1FF0,0x3838,0x301C,0x600C,0x600C,0x000C,0x001C,0x0038,0x0078,0x0070,0x00E0,0x01C0,0x0180,0x0180,0x0180,0x0000,0x0000,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [?]
0x03C0,0x0FF0,0x0C30,0x1818,0x1818,0x3018,0x3078,0x31F8,0x3398,0x3318,0x3338,0x33F8,0x31D8,0x3000,0x3800,0x1800,0x1800,0x0C20,0x0FE0,0x03C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [@]
0x0380,0x0380,0x06C0,0x06C0,0x06C0,0x0EE0,0x0C60,0x0C60,0x1C70,0x1830,0x1830,0x3838,0x3FF8,0x3FF8,0x3018,0x600C,0x600C,0x600C,0xC006,0xC006,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [A]
0x3FC0,0x3FF0,0x3030,0x3018,0x3018,0x3018,0x3018,0x3030,0x3FE0,0x3FE0,0x3038,0x3018,0x300C,0x300C,0x300C,0x300C,0x301C,0x3038,0x3FF0,0x3FE0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [B]
0x03E0,0x07F0,0x0C18,0x180C,0x180C,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x300C,0x180C,0x1818,0x0C38,0x0FF0,0x03C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [C]
0x3F80,0x3FE0,0x30F0,0x3038,0x3018,0x3018,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x3018,0x3018,0x3038,0x3070,0x3FE0,0x3F80,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [D]
0x3FFC,0x3FFC,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3FF8,0x3FF8,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3FFC,0x3FFC,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [E]
0x3FFC,0x3FFC,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3FF8,0x3FF8,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [F]
0x03E0,0x0FF0,0x0C38,0x1818,0x180C,0x300C,0x3000,0x3000,0x3000,0x3000,0x30FC,0x30FC,0x300C,0x300C,0x300C,0x180C,0x180C,0x0C3C,0x0FF8,0x03E0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [G]
0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x3FFC,0x3FFC,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [H]
0x0FF0,0x0FF0,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0FF0,0x0FF0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [I]
0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x3018,0x3018,0x3030,0x1C70,0x1FE0,0x07C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [J]
0x300E,0x301C,0x3018,0x3030,0x3060,0x30C0,0x31C0,0x3380,0x3700,0x3F00,0x3D80,0x3980,0x30C0,0x3060,0x3070,0x3030,0x3018,0x301C,0x300C,0x3006,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [K]
0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3FFC,0x3FFC,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [L]
0x600C,0x701C,0x703C,0x783C,0x7C7C,0x6C6C,0x6ECC,0x66CC,0x638C,0x638C,0x610C,0x610C,0x600C,0x600C,0x600C,0x600C,0x600C,0x600C,0x600C,0x600C,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [M]
0x380C,0x380C,0x3C0C,0x3C0C,0x3E0C,0x3E0C,0x370C,0x370C,0x338C,0x338C,0x31CC,0x31CC,0x30EC,0x30EC,0x307C,0x307C,0x303C,0x301C,0x301C,0x300C,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [N]
0x03C0,0x0FF0,0x0C38,0x1818,0x1818,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x1818,0x1818,0x1C30,0x0FF0,0x03C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [O]
0x3FE0,0x3FF8,0x3018,0x301C,0x300C,0x300C,0x300C,0x301C,0x3038,0x3FF0,0x3FE0,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [P]
0x03C0,0x0FF0,0x0C38,0x1818,0x1818,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x309C,0x18D8,0x1878,0x1C30,0x0FEC,0x03C6,0x0002,0x0000,0x0000,0x0000,0x0000, // Ascii = [Q]
0x3FE0,0x3FF8,0x3038,0x301C,0x300C,0x300C,0x300C,0x301C,0x3038,0x3FF0,0x3FE0,0x31C0,0x3060,0x3070,0x3030,0x3018,0x3018,0x300C,0x300C,0x3006,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [R]
0x07C0,0x0FF0,0x0C30,0x1818,0x1818,0x1800,0x1800,0x0E00,0x0F80,0x03E0,0x00F8,0x0038,0x001C,0x000C,0x300C,0x300C,0x180C,0x1C18,0x0FF0,0x03E0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [S]
0x7FFE,0x7FFE,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [T]
0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x300C,0x1818,0x1C38,0x0FF0,0x07E0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [U]
0xC006,0xC006,0x600C,0x600C,0x600C,0x3018,0x3018,0x3018,0x3838,0x1830,0x1830,0x1C70,0x0C60,0x0C60,0x0EE0,0x06C0,0x06C0,0x06C0,0x0380,0x0380,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [V]
0xC006,0xC006,0xC006,0xC006,0xC006,0xC006,0xC006,0x610C,0x638C,0x638C,0x63CC,0x66CC,0x66CC,0x6EEC,0x6C6C,0x6C6C,0x3838,0x3838,0x3838,0x3018,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [W]
0x7006,0x300C,0x380C,0x1818,0x0C30,0x0C30,0x0660,0x07C0,0x03C0,0x0180,0x0380,0x03C0,0x06E0,0x0C60,0x0C30,0x1830,0x3018,0x700C,0x600C,0xC006,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [X]
0x6006,0x300C,0x300C,0x1818,0x1818,0x0C30,0x0C30,0x0660,0x0660,0x03C0,0x03C0,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [Y]
0x1FF8,0x1FF8,0x0018,0x0030,0x0070,0x0060,0x00E0,0x00C0,0x0180,0x0180,0x0300,0x0300,0x0600,0x0E00,0x0C00,0x1C00,0x1800,0x3000,0x3FFC,0x3FFC,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [Z]
0x03E0,0x03E0,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x03E0,0x03E0, // Ascii = [[]
0x0C00,0x0C00,0x0600,0x0600,0x0600,0x0300,0x0300,0x0300,0x0380,0x0180,0x0180,0x01C0,0x00C0,0x00C0,0x00C0,0x0060,0x0060,0x0060,0x0030,0x0030,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [\]
0x07C0,0x07C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x07C0,0x07C0, // Ascii = []]
0x0380,0x0380,0x0780,0x06C0,0x06C0,0x0C60,0x0C60,0x1830,0x1830,0x3018,0x3018,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [^]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFF,0x0000,0x0000, // Ascii = [_]
0x0700,0x0380,0x0180,0x00C0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [`]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0FE0,0x1FF0,0x3838,0x7018,0x6018,0x0018,0x03F8,0x1FF8,0x3C18,0x7018,0x6018,0x6038,0x7078,0x3FD8,0x1F0C,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [a]
0x3000,0x3000,0x3000,0x3000,0x3000,0x33C0,0x37F0,0x3C38,0x3818,0x381C,0x300C,0x300C,0x300C,0x300C,0x300C,0x301C,0x3818,0x3C38,0x37F0,0x33C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [b]
0x0000,0x0000,0x0000,0x0000,0x0000,0x07E0,0x1FF0,0x3C38,0x301C,0x700C,0x6000,0x6000,0x6000,0x6000,0x600C,0x700C,0x3018,0x3C38,0x1FF0,0x07C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [c]
0x0018,0x0018,0x0018,0x0018,0x0018,0x0798,0x1FD8,0x3878,0x3038,0x6038,0x6018,0x6018,0x6018,0x6018,0x6018,0x7018,0x3038,0x3878,0x1FD8,0x0798,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [d]
0x0000,0x0000,0x0000,0x0000,0x0000,0x07C0,0x1FF0,0x3838,0x3018,0x600C,0x600C,0x7FFC,0x7FFC,0x6000,0x6000,0x700C,0x301C,0x3C38,0x1FF0,0x07E0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [e]
0x00F8,0x01FC,0x0384,0x0300,0x0300,0x3FF8,0x3FF8,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [f]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0798,0x1FD8,0x3878,0x3038,0x7038,0x6018,0x6018,0x6018,0x6018,0x6018,0x6018,0x3038,0x3878,0x1FD8,0x0798,0x0018,0x6038,0x7070,0x3FE0,0x0FC0, // Ascii = [g]
0x3000,0x3000,0x3000,0x3000,0x3000,0x33E0,0x37F0,0x3C38,0x3818,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [h]
0x0180,0x0180,0x0000,0x0000,0x0000,0x3F80,0x3F80,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [i]
0x00C0,0x00C0,0x0000,0x0000,0x0000,0x1FC0,0x1FC0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x21C0,0x3F80,0x1F00, // Ascii = [j]
0x3000,0x3000,0x3000,0x3000,0x3000,0x3018,0x3070,0x30E0,0x31C0,0x3300,0x3700,0x3F00,0x3980,0x30C0,0x3060,0x3030,0x3030,0x3018,0x300C,0x3006,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [k]
0x3F80,0x3F80,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [l]
0x0000,0x0000,0x0000,0x0000,0x0000,0x6E70,0x7FF8,0x7398,0x6318,0x6318,0x6318,0x6318,0x6318,0x6318,0x6318,0x6318,0x6318,0x6318,0x6318,0x6318,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [m]
0x0000,0x0000,0x0000,0x0000,0x0000,0x33E0,0x37F0,0x3C38,0x3818,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [n]
0x0000,0x0000,0x0000,0x0000,0x0000,0x07C0,0x1FF0,0x3838,0x3018,0x701C,0x600C,0x600C,0x600C,0x600C,0x600C,0x701C,0x3018,0x3838,0x1FF0,0x07C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [o]
0x0000,0x0000,0x0000,0x0000,0x0000,0x33C0,0x37F0,0x3C38,0x3818,0x380C,0x300C,0x300C,0x300C,0x300C,0x300C,0x301C,0x3818,0x3C38,0x37F0,0x33C0,0x3000,0x3000,0x3000,0x3000,0x3000, // Ascii = [p]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0798,0x1FD8,0x3878,0x3038,0x6038,0x6018,0x6018,0x6018,0x6018,0x6018,0x7018,0x3038,0x3878,0x1FD8,0x0798,0x0018,0x0018,0x0018,0x0018,0x0018, // Ascii = [q]
0x0000,0x0000,0x0000,0x0000,0x0000,0x31F0,0x1BF8,0x1E1C,0x1C08,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [r]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0FC0,0x1FE0,0x3870,0x3030,0x3000,0x1C00,0x0F00,0x07E0,0x00F0,0x0038,0x3018,0x3018,0x1838,0x1FF0,0x07C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [s]
0x0200,0x0600,0x0600,0x0600,0x0600,0x3FF0,0x3FF0,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0708,0x03F8,0x01F0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [t]
0x0000,0x0000,0x0000,0x0000,0x0000,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3018,0x3038,0x3878,0x1FD8,0x0F98,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [u]
0x0000,0x0000,0x0000,0x0000,0x0000,0x3006,0x180C,0x180C,0x180C,0x0C18,0x0C18,0x0E38,0x0630,0x0630,0x0770,0x0360,0x0360,0x03E0,0x01C0,0x01C0,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [v]
0x0000,0x0000,0x0000,0x0000,0x0000,0xC386,0xC386,0xC386,0xC6C6,0xC6C6,0x66CC,0x66CC,0x6EEC,0x6C6C,0x6C6C,0x6C6C,0x6C6C,0x3C78,0x3838,0x3838,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [w]
0x0000,0x0000,0x0000,0x0000,0x0000,0x600C,0x3018,0x1830,0x1C70,0x0C60,0x06C0,0x0380,0x0100,0x0380,0x06C0,0x0C60,0x1C70,0x1830,0x3018,0x600C,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [x]
0x0000,0x0000,0x0000,0x0000,0x0000,0x300C,0x300C,0x1818,0x1818,0x0C18,0x0C38,0x0C30,0x0630,0x0670,0x0760,0x0360,0x0360,0x01C0,0x01C0,0x01C0,0x0180,0x0380,0x0700,0x1F00,0x1C00, // Ascii = [y]
0x0000,0x0000,0x0000,0x0000,0x0000,0x3FFC,0x3FFC,0x001C,0x0038,0x0070,0x00E0,0x01C0,0x0380,0x0700,0x0E00,0x1C00,0x3800,0x7000,0x7FFC,0x7FFC,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [z]
0x0070,0x00F0,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0300,0x0E00,0x0E00,0x0300,0x0100,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x00F0,0x0070, // Ascii = [{]
0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180, // Ascii = [|]
0x0E00,0x0F00,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x00C0,0x0070,0x0070,0x00C0,0x0080,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0F00,0x0E00, // Ascii = [}]
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0E04,0x1F8C,0x31F8,0x2070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // Ascii = [~]
};


//--------------------------------------------------------------
// Font-Struktur
//--------------------------------------------------------------
UB_Font Arial_16x25 = {
  Arial_16x25_Table, // Font-Daten
  16,                // Breite eines Zeichens (in Pixel)
  25,                // Hoehe eines Zeichens  (in Pixel)
};



