//--------------------------------------------------------------
// File     : stm32_ub_lcd_ssd2119.h
//--------------------------------------------------------------

//--------------------------------------------------------------
#ifndef __STM32F4_UB_LCD_SSD2119_H
#define __STM32F4_UB_LCD_SSD2119_H

//--------------------------------------------------------------
// Includes
//--------------------------------------------------------------
#include "stm32f4xx.h"
#include "stm32f4xx_gpio.h"
#include "stm32f4xx_rcc.h"
#include "stm32f4xx_fsmc.h"


//--------------------------------------------------------------
// Standard Farbwerte
// 16bit Farbwert (R5G6B5)
// Red   (5bit) -> Bit15-Bit11
// Green (6bit) -> Bit10-Bit5
// Blue  (5bit) -> Bit4-Bit0
//--------------------------------------------------------------
#define  RGB_COL_BLACK          0x0000
#define  RGB_COL_BLUE           0x001F
#define  RGB_COL_GREEN          0x07E0
#define  RGB_COL_RED            0xF800
#define  RGB_COL_WHITE          0xFFFF

#define  RGB_COL_CYAN           0x07FF
#define  RGB_COL_MAGENTA        0xF81F
#define  RGB_COL_YELLOW         0xFFE0

#define  RGB_COL_GREY           0x7BEF

//--------------------------------------------------------------
// Display Mode
//--------------------------------------------------------------
typedef enum {
  PORTRAIT =0,
  LANDSCAPE
}LCD_MODE_t;
LCD_MODE_t  LCD_DISPLAY_MODE;


//--------------------------------------------------------------
// Display Fenster Settings
//--------------------------------------------------------------
typedef struct {
  uint16_t xstart;
  uint16_t ystart;
  uint16_t xend;
  uint16_t yend;
  uint32_t pixel;
}LCD_WINDOW_t;
LCD_WINDOW_t LCD_WINDOW;


//--------------------------------------------------------------
// Adressen vom FSMC um auf das Display zuzugreifen
// Bank   = Bank-1 / PSRAM-1        => BaseAdr 0x60000000
// RS-Pin = PE3=FSMC_A19 = BitNr 19 => Offset  0x00100000
// (siehe Seite 1316+1317 vom Referenz Manual)
//--------------------------------------------------------------
#define LCD_REG  (*((volatile unsigned short *) 0x60000000)) // RS = 0
#define LCD_RAM  (*((volatile unsigned short *) 0x60100000)) // RS = 1
#define LCD_RAM_ADR   0x60100000  // Adresse vom RAM

//--------------------------------------------------------------
// Defines vom Display
//--------------------------------------------------------------
#define  LCD_SSD2119_ID  0x9919  // ID vom SSD2119
#define  LCD_MAXX  320          // Pixel in X-Richtung
#define  LCD_MAXY  240          // Pixel in Y-Richtung
#define  LCD_PIXEL  LCD_MAXX*LCD_MAXY
#define  LCD_SSD2119_PAUSE   5000
#define  LCD_SSD2119_PAUSE2  5000
// stm32f4xx_fsmc.h Zeile 49: This parameter can be a value between 0 and 0xF. (25 also zu viel)
#define  LCD_SSD2119_FSMC_AST  0x0f // AdressSetupTime  (AST >= 9)
#define  LCD_SSD2119_FSMC_DST  0x0f // DataSetupTime    (DST >= 7)
#define  LCD_SSD2119_PORTRAIT  0x6830  // Mode = Portrait
#define  LCD_SSD2119_LANDSCAPE 0x6838  // Mode = Landscape

//--------------------------------------------------------------
// Register Adressen vom Display-Controller
//--------------------------------------------------------------
#define  LCD_SSD2119_REG_00  0x00   // Display-ID
#define  LCD_SSD2119_REG_11  0x11   // Display-Mode
#define  LCD_SSD2119_REG_4E  0x4E   // Cursor-Pos (X)
#define  LCD_SSD2119_REG_4F  0x4F   // Cursor-Pos (Y)
#define  LCD_SSD2119_REG_22  0x22   // RAM Start

#define  LCD_SSD2119_REG_44  0x44   // X-Start+End
#define  LCD_SSD2119_REG_45  0x45   // Y-Start
#define  LCD_SSD2119_REG_46  0x46   // Y-End


#define SSD2119_DEVICE_CODE_READ_REG			0x00
#define SSD2119_OSC_START_REG   				0x00
#define SSD2119_OUTPUT_CTRL_REG 				0x01
#define SSD2119_LCD_DRIVE_AC_CTRL_REG			0x02
#define SSD2119_PWR_CTRL_1_REG					0x03
#define SSD2119_DISPLAY_CTRL_REG				0x07
#define SSD2119_FRAME_CYCLE_CTRL_REG			0x0B
#define SSD2119_PWR_CTRL_2_REG					0x0C
#define SSD2119_PWR_CTRL_3_REG					0x0D
#define SSD2119_PWR_CTRL_4_REG					0x0E
#define SSD2119_GATE_SCAN_START_REG				0x0F
#define SSD2119_SLEEP_MODE_1_REG				0x10
#define SSD2119_ENTRY_MODE_REG					0x11
#define SSD2119_GEN_IF_CTRL_REG					0x15
#define SSD2119_PWR_CTRL_5_REG					0x1E
#define SSD2119_RAM_DATA_REG					0x22
#define SSD2119_FRAME_FREQ_REG					0x25
#define SSD2119_VCOM_OTP_1_REG					0x28
#define SSD2119_VCOM_OTP_2_REG					0x29
#define SSD2119_GAMMA_CTRL_1_REG				0x30
#define SSD2119_GAMMA_CTRL_2_REG				0x31
#define SSD2119_GAMMA_CTRL_3_REG				0x32
#define SSD2119_GAMMA_CTRL_4_REG				0x33
#define SSD2119_GAMMA_CTRL_5_REG				0x34
#define SSD2119_GAMMA_CTRL_6_REG				0x35
#define SSD2119_GAMMA_CTRL_7_REG				0x36
#define SSD2119_GAMMA_CTRL_8_REG				0x37
#define SSD2119_GAMMA_CTRL_9_REG				0x3A
#define SSD2119_GAMMA_CTRL_10_REG				0x3B
#define SSD2119_V_SCROLL_CTRL_1_REG				0x41
#define SSD2119_V_SCROLL_CTRL_2_REG				0x42
#define SSD2119_V_RAM_POS_REG					0x44
#define SSD2119_H_RAM_START_REG					0x45
#define SSD2119_H_RAM_END_REG					0x46
#define SSD2119_SCREEN_1_START_POS_REG			0x48
#define SSD2119_SCREEN_1_END_POS_REG			0x49
#define SSD2119_SCREEN_2_START_POS_REG			0x4A
#define SSD2119_SCREEN_2_END_POS_REG			0x4B
#define SSD2119_X_RAM_ADDR_REG					0x4E
#define SSD2119_Y_RAM_ADDR_REG					0x4F


//--------------------------------------------------------------
// Globale Funktionen
//--------------------------------------------------------------
ErrorStatus UB_LCD_Init(void);
void UB_LCD_SetCursor2Draw(uint16_t xpos, uint16_t ypos);
void UB_LCD_FillScreen(uint16_t color);
void UB_LCD_Backlight_On(void);
void UB_LCD_Backlight_Off(void);
void UB_LCD_SetMode(LCD_MODE_t mode);
void UB_LCD_SetWindow(uint16_t xstart, uint16_t ystart, uint16_t xend, uint16_t yend);


//--------------------------------------------------------------
#endif // __STM32F4_UB_LCD_SSD2119_H
