
//Fuse CKDIV8 off und JTAGEN off, ATMEGA169P!!
//Fuses: C2, DC, FD for bootloader
//external crytal 32768 Hz 

#include "main.h"

/*****************************************************************
Tripmaster based on Atmega169P working as follows:
LCD segments (4 digit standard LCD connected to ports A-G according
to included XLS). Two buttons connected to PE0 (+) and PE1 (-) against GND.
Two interrupts work as follows:

External PinChangeInt2:
Configured as input with pullup resistor and capacitor (0.1F) for debouncing
of reed contact that samples the number of wheel spins. Calculates the 
travelled trip every time it fires. Supported by another pullup from PF6
that supplies additional current to contact while device is turned on (4K7 and diode).

Timer2 interrupt:
Fires every 15 ms (64Hz)and switches the ports A-G according to the required
data to be displayed on the LCD (32Hz LCD frequency). Reads the two 
buttons every cycle and controls the operation of the system according 
to the buttons pressed and required time delays (debouncing included).
All based on a crystal 32768Hz for Timer2 (asynch.) and internal RC oscillator (actual frequ. is 8MHz/16=500KHz).

Five display modes:
1. Trip1: Displays the currently calculated trip on the LCD. Allows with 
+ or - button to increase or decrease the displayed trip with convenient
button delays.
When trip is on 0km and - button is pressed long enough the device turns off.
Press both buttons to change to mode Trip2.
Resetting trip to zero: Count down with - button until it counts fast.
Press the + button on top of the first button and wait until trip goes to
0,0.

2. Trip2: See Trip1, domma blinking to differenciate between Trip1 and Trip2.
Press both buttons to change to mode speed. On 0.0 press - button to toggle between 
10m and 100m resolution. Comma moves forth and back.

3. Speed mode:
In Trip2 mode press both keys long enough. Speed mode will be selected, the 
comma will vanish and the speed symbol will show up. Press the plus key long 
enough to change to max_speed mode. It will show the max speed symbol and the 
maximal speed reached. Reset the max speed with the minus button, go back to
speed mode with both keys.
Left bottom segment will light up when reed contact is closed and speed is slower than 
10km/hr for conveniant checking of proper reed contact function.
Press both keys in order to change to clock mode. Press plus key to go to circum mode.

4. Circum: In speed mode press - key long enough.Displays the currently configured 
wheel circumferance.
Operation: The first digit blinks on mode entry.
Then use + button to increase (8-9-0-1-2...) the digit to the desired
value or use the - button to change to next digit (1-2-3-4-1..).
Press both keys to quit circum mode and to save the value.
Added June 2009: After CIR mode selection of US or EU for miles or kms.

5. Clock mode:
In speed mode press both buttons.
Displays clock with colon. Use - button to change to set mode (display blinks).
+ button changes selected digit, - button changes to next digit. Both buttons change back
to Trip1 mode.
*****************************************************************/

const char PROGMEM digits[33]= {0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F,0x40,0x20,0x08,0x01,0x58,0x10,0x50,0x58,0x3F,0x71,0x71,0x08,0x00, 0x3E, 0x79, 0x7E,0x7D,0x7B,0x77,0x6F,0x5F,0x3F,0x5C};
							//	 0	   1     2    3	   4 	5	  6    7	8	 9    -   *	    _   	  c		i	 r	  c    O	F	F	  _	 BLANK	U	  E		//LCD Tests from here

volatile char miles= 0, prev_miles, new_round=0, updated=0, HiRes2=0;	//bool variables						
volatile unsigned char oldkey, key, mode=disp_test, Display[4], delay1, delay2, delay3, blink, change, count, veloc, old_veloc, max_veloc, power, uptime=maxuptime;
volatile unsigned char hour=0, minute=0, four_second=0, port[14], oldTC, old_mode;
volatile unsigned int circum=2160, trip_100m=0, revolution, temp, trip_100m_2, tmp_rev; 
volatile unsigned long trip_mm=0, limit = 100000, temp2, limit2=100000, trip_mm2=0;		
volatile unsigned char curr_TC, x;
volatile unsigned int time;
volatile unsigned long loc_tmp;

unsigned char WaitForKey (unsigned char);
void Switch2Speed(void);

int main(void)
{
	CLKPR = (1<<CLKPCE);        			// set Clock Prescaler Change Enable
    CLKPR = (1<<CLKPS2);					// set prescaler = 16, Inter RC 8Mhz / 16 = 500Khz
		
	PCMSK0 |= (1<<PCINT2);					// PCI 2 on, this is PB2, reed contact wheel
	EIMSK |= (1<<PCIE0);					// Pin Change INT0 on
	ACSR |= (1<< ACD);						// Turn off analog comparator for power reduction
	PRR=0xFF;								// Reduce power of everything
	OCR2A=preload;
    cli();									// disabel global interrupt
    ASSR = (1<<AS2);						// select asynchronous operation of Timer2
    TCNT2 = 0;	
							// clear TCNT2A
    TCCR2A |= (1<<CS21) | (1<<WGM21);		// select precaler: 32.768 kHz / 8 = 1/64 sec between each CTC
	
	while((ASSR & 0x01) | (ASSR & 0x04));	// wait for TCN2UB and TCR2UB to be cleared
    TIFR2 = 0xFF;           				// clear interrupt-flags
    TIMSK2|= (1<<OCIE2A);     				// enable Timer2 CTC interrupt
	
	DDRA = 0xFF;
	DDRB = 0xFF; 
	DDRC = 0xFF; 
	DDRD = 0xFF;
	DDRE = 0xF8; 							//All Ports OUTPUTS except Wheel (PE2), PE0 and PE1
	DDRF = 0xEF;							//Port F4 input for external power sensing
	DDRG = 0xFF;
   
	max_veloc=0;
	power=1;
	sei();									//Enable all interrupts
	set_sleep_mode(SLEEP_MODE_PWR_SAVE);
    while(1)                    
    { 
	 sleep_mode();
	 if (new_round)
	 {
		new_round=0;
		uptime = maxuptime;
		power=1;	
		trip_mm+=circum;		//add wheel circum to mmtrip
		trip_mm2+=circum;
		if (trip_mm > limit-1)
			{
			 trip_mm -= limit;	//100m are over	
			 if (++trip_100m > 9999)
				trip_100m=0;
			}
		if (trip_mm2 > limit2-1)
			{
			 trip_mm2-=limit2;
			 if (++trip_100m_2 >= 9999)
				trip_100m_2=0;
			}
		if (tmp_rev> slowest)
			veloc=0;
		else
		{
		   time = tmp_rev*steps+curr_TC-oldTC;
		   loc_tmp= circum;
		   loc_tmp= frequ*18*loc_tmp/time;
		   if (miles)
				veloc=(loc_tmp+4)/8;	//miles per hour, rounding included
		   else
				veloc=(loc_tmp+2)/5;	//km per hour, rounding included
		   if (veloc>max_veloc)
				max_veloc=veloc;		//store maximum speed
		}
		oldTC=curr_TC;
	 }
    }
	return (1);
}
//****************************************************************
//*************external wheel Interrupt***************************
//****************************************************************
ISR (SIG_PIN_CHANGE0)	
{
 if (!Reed_open)						//if contact closed
  {
	new_round=1;
	OCR2A=preload;
	while (ASSR&0x02) ;					//wait until OCR2UB reads 0, this ensures that TCNT2 reads correctly
	curr_TC = TCNT2;					//take snapshot of timer 2 status NOW!
	tmp_rev = revolution;
	if ((!curr_TC)&&(!updated))		//in case Timer is at 0 and revolution was not updated yet -> add a revolution
	 {
		tmp_rev++;
		revolution=1;
	 }
	else
		revolution=0;
  }//End of wheel interrupt....
}
//******************************************
//Timer 2 Interrupt CTC here: **************
//******************************************
ISR (TIMER2_COMP_vect)					//fires about every 15.6ms, 64Hz, takes maximum 4ms to complete @500KHz CPU clock	
{	
	unsigned char i, blink_mask;
	int j=0;
	static char test;
	revolution++;
	updated=1;							//signal that revolution has been added
	i= 7*(++blink & 0x01);				//can be 0 or 7 toggling every 15ms
	key = PINE&0x03;					//Read keys
	blink_mask = blink & 0x03;			//masks out every 16th IRQ 
	if (revolution> slowest)
	  {
		veloc=0;
		revolution= slowest+1;			//prevent speed calculation, sets speed to 0, fixed bug!!
	  }	
	sei();								//allow for nested interrupt
	PORTA=port[i];					
	PORTB=port[i+1];
	PORTC=port[i+2];
	PORTD=port[i+3];
	PORTE=port[i+4];				
	PORTF=port[i+5];
	PORTG=port[i+6];					// Display update over at this point

	if ((!blink) && (++four_second ==15))
	{ 
	  four_second=0;
	  if (PINF&0x10)					//if external power on then never shut down 
	   {
		uptime=maxuptime;
	    power=1;
	   }
		
	  if ((power)&&(!--uptime))
	   {
		power=0;	
		Display[1]=empty;				//empty LCD after wakeup
		Display[2]=empty;
		Display[3]=empty;
	   }	
				
	  if (++minute > 59)
	   { 
	    minute=0;
		if (++hour > 23)
			hour=0;
	   }
	}
	
	if (!power)
	{
	 for (i=0; i<14; i++)
		port[i]=0xFF;					//All segments OFF
	 port[5]=191;
	 port[12]=191;						//separate pullup off
	 mode=old_mode;
	 veloc=0;
	 if (WaitForKey(key))				//Check if wakeup key was presssed
		{
		 delay1 = wait1;
		 delay2 = wait2;
		 delay3 = wait4;
		}
	}
	else								//power is on...
	{
	if (!blink_mask)					//power saving 16 times a second
	 {
	  // ---PORT A--
		port[0]=												//PA0 		
																//PA1
																//PA2
																//PA3 (Backplane)
				(pgm_read_byte(&digits[Display[0]])&16) |		//PA4 1E
				(pgm_read_byte(&digits[Display[0]])&8)*4 |		//PA5 1D
				(pgm_read_byte(&digits[Display[0]])&4)*16;		//PA6 1C
																//PA7
		// ---PORT B---
		port[1]=(pgm_read_byte(&digits[Display[2]])&64)/64 |	//PB0 3G
																//PB1
																//PB2
																//PB3
				(pgm_read_byte(&digits[Display[2]])&32)/2 |	//PB4 3F
				(pgm_read_byte(&digits[Display[2]])&1)*32 |	//PB5 3A
				(pgm_read_byte(&digits[Display[2]])&2)*32 |	//PB6 3B
				(pgm_read_byte(&digits[Display[3]])&64)*2;		//PB7 4G
		// ---PORT C---	
		port[2]=												//PC0 (komma right)
				(pgm_read_byte(&digits[Display[2]])&4)/2 |		//PC1 3C
				(pgm_read_byte(&digits[Display[2]])&8)/2 |		//PC2 3D
				(pgm_read_byte(&digits[Display[2]])&16)/2 |	//PC3 3E
																//PC4 (komma centre)
				(pgm_read_byte(&digits[Display[1]])&4)*8 |		//PC5 2C
				(pgm_read_byte(&digits[Display[1]])&8)*8 |		//PC6 2D
				(pgm_read_byte(&digits[Display[1]])&16)*8;		//PC7 2E
		// ---PORT D---	
		port[3]=
				(pgm_read_byte(&digits[Display[3]])&2)*32 |	//PD6 4B
				(pgm_read_byte(&digits[Display[3]])&4)*32;		//PD7 4C
					
		// ---PORT E---	
		port[4]=												//PE0 		
																//PE1
																//PE2
				(pgm_read_byte(&digits[Display[1]])&64)/8 |	//PE3 2G
				(pgm_read_byte(&digits[Display[1]])&32)/2 |	//PE4 2F
				(pgm_read_byte(&digits[Display[1]])&1)*32 |	//PE5 2A
				(pgm_read_byte(&digits[Display[1]])&2)*32;		//PE6 2B
																//PE7 (colon)
				
		// ---PORT F---
		port[5]=(pgm_read_byte(&digits[Display[0]])&2)/2 |	//PF0 1B
				(pgm_read_byte(&digits[Display[0]])&1)*2 |		//PF1 1A
				(pgm_read_byte(&digits[Display[0]])&32)/8 |	//PF2 1F
				(pgm_read_byte(&digits[Display[0]])&64)/8;		//PF3 1G
																//PF4
																//PF5
																//PF6 (Diode switch, separate pullup)
																//PF7
		// ---PORT G---
		port[6]=(pgm_read_byte(&digits[Display[3]])&8)/8 |	//PG0 4D
				(pgm_read_byte(&digits[Display[3]])&16)/8 |	//PG1 4E
																//PG2 (komma left)
				(pgm_read_byte(&digits[Display[3]])&32)/4 |	//PG3 4F
				(pgm_read_byte(&digits[Display[3]])&1)*16;		//PG4 4A		
	 }
	switch (mode)
	{
	 case shutdown:						//turn display off
		delay1 = wait1;
		delay2 = wait2;
		delay3 = wait4;
		if (--power)
		 {
		  Display[0]=empty;
		  Display[1]=empty;
		  Display[2]=empty;
		  Display[3]=empty;
		 }
	 break;
	// *************Trip2 processing ***********************
	case trip2:
	   old_mode=trip2;
	   if ((change)&&(!blink_mask))	//16 times a second only, recuduces power consumption
	   {
	     if (trip_100m_2>999)
			Display[0]=(trip_100m_2/1000);
		 else
			Display[0]=empty;
		 if ((trip_100m_2>99)|(limit2<50000))	
			Display[1]=(trip_100m_2/100)%10;
		 else
			Display[1]=empty;
		 Display[2]=(trip_100m_2/10)%10;
		 Display[3]=trip_100m_2%10;
	   }
	   if (WaitForKey(key))				//same key pressed long enough...
		 {
		  if (key_min==key)
			{
				if (trip_100m_2)		//decrease only if trip_100m_2 >0
				   {
					trip_100m_2--;
					trip_mm2=0;
					change = 1;
				   }
				else
				{
				  if (change!=1)		//switch between Hi and Lo resolution on trip2
				  {
				   delay1 = 3*wait1;
				   change = 0;
				   HiRes2 = 1-HiRes2;
				   if (miles)
				    {
					 if (HiRes2)
						limit2=16100;
					 else
						limit2=161000;
					}
				   else
				    {
					 if (HiRes2)
						limit2=10000;
					 else
						limit2=100000;
					}
				   Display[1]=((1-HiRes2)*empty);
				  }
				}
			}
			if (key_plus==key)
			  {
			 	trip_mm2=0;
				trip_100m_2++;
				if (trip_100m_2 > 9999)
					trip_100m_2=0;
			  }
			if (key_all==key)
			 {
				mode=clock;				//use both buttons to go to next mode.
				delay1 = 2*wait1;
			 }
		 }
	if ((blink&8)&&(!HiRes2))
		port[2]|=Komma;					//Komma 100m blinks for trip2
	if ((blink&8)&&(HiRes2))
		port[2]|=Komma10;				//Komma 10m blinks for trip2
		
	break;
	// *************Trip processing ***********************
	case trip:
	   old_mode=trip;
	   if ((change)&&(!blink_mask))	//16 times a second only, recuduces power consumption
	   {
		 if (trip_100m>999)
			Display[0]=(trip_100m/1000);
		 else
			Display[0]=empty;
		 if (trip_100m>99)	
			Display[1]=(trip_100m/100)%10;
		 else
			Display[1]=empty;
		 Display[2]=(trip_100m/10)%10;
		 Display[3]=trip_100m%10;
	   }
	   if (WaitForKey(key))		//same key pressed long enough...
		 {
		  if (key_min==key)
			{
				if (trip_100m)		//decrease only if trip_100m >0
				   {
					trip_100m--;
					trip_mm=0;
					change = 1;
				   }
				else
				{
				  if (change!=1)	//0: Display Trip off, 2: Display Trip on, no key pressed in between
				  {
				   delay1 = 3*wait1;
				   change = 0;
				   for (i=0; i<4; i++)
				    {
				     if (delay3 < wait4-i)
					    {
						 Display[i]=turnoff1+i;
						 if (!i)
						   {
						    Display[1]=empty;
							Display[2]=empty;
							Display[3]=empty;
						   }
						}
				    }
					 if (delay3==wait4-5)	//wait until - key pressed again on Trip = 0
					 {
					  power=50;			//Turn off here....
					  mode=shutdown;
					 }	
				  }
				}
			}
			if (key_plus==key)
			  {
			 	trip_mm=0;
				trip_100m++;
				if (trip_100m > 9999)
					trip_100m=0;
			  }
			if (key_all==key)
			 {
				mode=trip2;			//use both buttons to go to next mode.
				delay1 = 2*wait1;
			 }
		 }
	port[2]|=Komma;				//Komma on
	break;
	//************** change between miles and kms here ******************
	case km_mil:
		old_mode=trip;
		if (WaitForKey(key))			//same key pressed long enough...
		{
		 if (key_all==key)
		 { 
		  if (miles && !prev_miles)
		  {
		   temp2 = 5*trip_100m;
		   trip_100m = (temp2) / 8;
		   temp2 = 5*trip_100m_2;
		   trip_100m_2 = (temp2) / 8;
		   temp2 = 5*max_veloc;
		   max_veloc = (temp2) / 8;
		   limit = 161000;
		   if (HiRes2)
				limit2=16100;
		   else
				limit2 = 161000;
		  }
		  if (!miles && prev_miles)
		  {
		   temp2 = 8*trip_100m;
		   trip_100m = (temp2 / 5)%10000;
		   temp2 = 8*trip_100m_2;
		   trip_100m_2 = (temp2 / 5)%10000;
		   temp2 = 8*max_veloc;
		   max_veloc = (temp2) / 5;
		   limit = 100000;
		   if (HiRes2)
				limit2=10000;
		   else
				limit2 = 100000;
		  }
		  Switch2Speed();			//use both buttons to go to next mode.
		 }
		 else
			miles = 1-miles;
		 delay1 = 3*wait1;
		}
		Display[0]= empty;
		Display[3]= empty;
		if (miles)
			{
			 Display[1]= 23;		//display "US"
			 Display[2]= 5;
			}
		 else
			{
			 Display[1]= 24;		//display "EU"
			 Display[2]= 23;
			}
	break;
	//************** Trip over, clock mode ******************************  
    case clock:
		old_mode=clock;
	    Display[0]= empty;
		if (hour/10)
			Display[0]=hour/10;
		Display[1]=hour%10;
		Display[2]=minute/10;
		Display[3]=minute%10;
		if (blink&0x20)
			port[4]|=Colon;				//Colon on when required  
	    if (WaitForKey(key))			//same key pressed long enough...
		{
		  if (key_min==key)
			{
			 mode=setclk;
			 delay1=2*wait1;
			 count=3;					//start with minutes	
			}
		  if (key_all==key)
		   {
			Switch2Speed ();			//use both buttons to go to next mode.
			delay1 = 2*wait1;
		   }
		}
	break;
	case setclk: 
		old_mode=clock;
	    Display[0]= empty;
		if (hour/10)
			Display[0]=hour/10;
		Display[1]=hour%10;
		Display[2]=minute/10;
		Display[3]=minute%10;
		if (blink&0x20)
			port[4]|=Colon;				//Colon on when required  
		 if (blink & 0x10)
		   {
			Display[count] = empty;		//blink  appropriate digits
			Display[count-1] = empty;	
		   }
		 if (WaitForKey(key))
		 { 
		  if (key_all==key)
		   {
			mode=clock;					//use both buttons to go end set  mode.
			delay1 = 2*wait1;
		   }
		  if (key_min==key)
		   {
			 delay1=3*wait1;
			 count=4-count;				//toggle	
		   }
		  if (key_plus==key)
		   {
		    delay1=wait1;
			four_second=0;
			if (count==3)
			   {
				if (++minute>59)
					minute=0;
				four_second=0;
			   }
			else
               {
				if (++hour>23)
					hour=0;
			   }	
		   }
		 }
		break;
    // *************** clock over *********************************  
	case speed:
	  old_mode=speed;
	  if (change)
	  {
	   Display[0]= speedmark;
	   if (!(blink&0x3F))
	   {
	    if (veloc>99)
			Display[1]=veloc/100;
	    else
			Display[1]=empty;
		if (veloc>9)
			Display[2]=(veloc/10)%10;
	    else
			Display[2]=empty;
	    Display[3]=veloc%10;
	   }
	  }
	  if (WaitForKey(key))		//same key pressed long enough...
	  {
	   if (key_all==key)
		{
		 mode=trip;				//use both buttons to go to next mode.
		 count=3;
		 delay1 = 3*wait1;
		 }
	   if (key_plus==key)
		{
		 mode=maxspeed;			//use plus button to go to next mode.
		 count=3;
		 delay1 = 3*wait1;
		 } 
	   if (key_min==key)
		{
		 change=0;
		 delay1 = 3*wait1;
		 for (i=0; i<4; i++)
		 {
		  if (delay3 < wait4-i)
		   {
			Display[i]=cir+i;
			if (!i)
			   {
				Display[1]=empty;
				Display[2]=empty;
				Display[3]=empty;
			   }
		   }	
		 }
		 if (delay3==wait4-5)	//wait until - key preesed again on Trip = 0
			mode = wheel;
			count=1;			//start with second left digit (Display[1])
			temp = circum;
		}
	   }
	if ((veloc < 10)&&(!Reed_open))		//slower than 10kph and reed contact closed: Turn segment 1D on
			port[0]|=32;
	break;
	case maxspeed:
	  old_mode=speed;
	  if (WaitForKey(key))		//same key pressed long enough...
	  {
	   if (key_all==key)
		{
		 Switch2Speed();		//use both buttons to go to next mode.
		 count=3;
		 delay1 = 3*wait1;
		}
	   if (key_min==key)
		{
		 max_veloc=0;
		}
	  }
	   Display[0]= maxspeedmark;
	   if (max_veloc>99)
			Display[1]=max_veloc/100;
	   else
			Display[1]=empty;
	   if (max_veloc>9)
			Display[2]=(max_veloc/10)%10;
	   else
			Display[2]=empty;
	   Display[3]=max_veloc%10;
	break;
	 // **************** speed over ******************************
	case wheel:
	    old_mode=trip;
		Display[0]= temp/1000;
		Display[1]= (temp-(Display[0]*1000))/100;
		Display[2]= (temp-Display[0]*1000-Display[1]*100)/10;
		Display[3]= temp-Display[0]*1000-Display[1]*100-Display[2]*10;
		if (blink & 0x10)
			Display[count] = empty;
		if (WaitForKey(key) && (change == 2))		//same key pressed long enough...
		{
		  if (key_min == key)
		   {
		    count++;
			if (count >3)
				count = 1;
			delay1 = wait1;
		   }
		  if (key_plus == key)
		   {
		    delay1 = wait1;
		    switch (count)
			{
			 case 1: temp += 100;
			 if (temp > 3000)
				temp -= 1000;
			 break;
			 case 2: 
			 j=temp/100;
			 temp += 10;
			 if (temp > 100*j+99)
				temp -= 100;
			 break;
			 case 3: 
			 j=temp/10;
			 temp ++;
			 if (temp > 10*j+9)
				temp -= 10;
			}
		   }
		  if (key_all==key)
		   {
			mode = km_mil;
			prev_miles = miles;			//remember old value
		    circum = temp;
		    delay1 = 2*wait1;
		   }
		}
	break;
	case restrip:						//Reset trip to zero
		port[2]|=Komma;					//Komma on
		if (WaitForKey(key))			//same key pressed long enough...
		{
		 if (key_all==key)
		 {
		  change=0;
		  delay1 = 3*wait1;
		  for (i=0; i<4; i++)
		  {
		   if (delay3 < wait4-i)
				Display[i]=32;			//show small 0
		  }
		  if (delay3 < wait4-4)
		  {
		   mode=trip;
		   trip_100m=0;
		   WaitForKey(key_none);
		   delay1 = 3*wait1;
		  }
		 }
		}
		if (key_all!=key)
			mode=trip;
		break;
	//*******************************************************
	case restrip2:					//Reset trip2 to zero
		if (blink&8)
			port[2]|=Komma;			//blink komma
		if (WaitForKey(key))		//same key pressed long enough...
		{
		 if (key_all==key)
		 {
		  change=0;
		  delay1 = 3*wait1;
		  for (i=0; i<4; i++)
		  {
		   if (delay3 < wait4-i)
			Display[i]=32;			//show small 0
		  }
		  if (delay3 < wait4-4)
		  {
		   mode=trip2;
		   trip_100m_2=0;
		   WaitForKey(key_none);
		   delay1 = 3*wait1;
		  }
		 }
		}
		if (key_all!=key)
			mode=trip2;
		break;
	//********************************************************
	case disp_test:
		if (!(blink&0x07))
			test++;				//loop variable here, starts at 0
			
		for (i=0; i<4; i++)	//fill all digits with 8
			Display[i]=8;
			
		if (test != 32)
			port[4]|=128;		//colon
			
		if (test != 31)
			port[2]|=1;			//right decimal dot
			
		if (test != 30)
			port[2]|=16;		//centre decimal dot
			
		if (test != 29)
			port[6]|=4;			//left decimal dot
		
		if (test>32)
			{
			 mode=trip;			//Display test over...
			 key=key_none;
			 break;
			}
			
		if (test>28)
			break;
			
		if (test>21)
			{
			 Display[3]=25+test-22;
			 break;
			}
		if (test>14)
			{
			 Display[2]=25+test-15;
			 break;
			}
		if (test>7)
			{
			 Display[1]=25+test-8;
			 break;
			}
		if (test)
			Display[0]=25+test-1;
		break;
	default:
		mode=trip;
	break;
	}									//switch end
	 
	if (!blink_mask)
	  {
		for (i=0; i<7; i++)
			port[i+7] = port[i] ^ 0xFF;
		port[5] |=64;					//(Separate pullup on)
		port[4] |=7;					//set first 2 bits pullup on (keys) and pullup PE2 on (wheel IRQ)
		port[0] |=1;					//debugging, measure timer duration on PA0
		port[12] &=239;					//pullup off for PF4
	  }		
	}									//else means power >0
   oldkey = key;
   updated=0;							//reset for next time
   PORTA &=254;							//debugging, measure timer duration on PA0
}

// **********************************************************
// checks if keys were pressed long enough and controls delays
// Return: 1, take key action or 0, take no action
// **********************************************************
unsigned char WaitForKey (unsigned char KeyPressed)
{

 //******************** Gerd Mode ****************************
   if ((mode == trip) || (mode == trip2))
  {
	if (KeyPressed == key_none)		//keys released now
	{
	 if ((oldkey == key_plus) || (oldkey == key_min))		//was PLUS or MINUS presses before?
		if (((delay1 + quick) >= wait1) &&  (delay1< wait1-1))
			{
			key=oldkey;
			delay1 = wait1;
			return (1);	
			}
	}
  }
 //**********************************************************
  if ((KeyPressed != key_none)&&(oldkey == KeyPressed))
	{
	 uptime = maxuptime;
	 if (!--delay1)			//wait for key to be pressed long enough before action
	 {
	  delay1++;				//same key pressed long enough
	  if (!--delay2)		//loop slowly here
	  {
	    delay2=wait2;		//loop slowly
		power=1;
		if (!--delay3)
		{
		 delay3++;
		 delay2=wait3;		//now loop faster
		}
		return (1);
	  } 
	 }
	}
	else
	{
	 if ((oldkey==key_min)&&(KeyPressed==key_all)&&(delay3==1))	//trip counting down fast and then both keys pressed
	 {		
	  if (mode==trip)	
			mode = restrip;
	  if (mode==trip2)	
			mode = restrip2;
	 }		
	 delay1 = wait1;
	 delay2 = wait2;
	 delay3 = wait4;
	 if((!change)&&(mode==speed))
		Switch2Speed();
	 change = 2;			//Trip display enabled, flag that keys were released last
	}
  return (0);
}
// **********************************************************
// switch to speed mode with no display delay
// **********************************************************
void Switch2Speed(void)	
{
 mode=speed;
 Display[0]= speedmark;
 if (veloc >99)
	Display[1]=veloc/100;
 else
    Display[1]=empty;
 if (veloc >9)
	Display[2]=(veloc/10)%10;
 else
    Display[2]=empty;
 Display[3]=veloc%10;
}
