#ifndef _MAIN_H
 #define _MAIN_H

#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include <string.h>
#include <avr/wdt.h>

#define Komma	1		//PC1
#define Komma10 16		//PC4
#define Colon	128		//PE7

// *************** LCD patterns **************
#define minus	10		//LCD dash
#define speedmark 11	//mark speed mode
#define turnoff	12		//mark to go to off (old...)
#define maxspeedmark 13	//mark max speed mode
#define cir		14		//mark to go to wheel mode c
#define cir1	15		//mark to go to wheel mode i
#define cir2	16		//mark to go to wheel mode r
#define cir3	17		//mark to go to wheel mode c
#define turnoff1	18	//shows "OFF" on shutdown...
#define turnoff2	19
#define turnoff3	20	
#define turnoff4	21
#define empty		22	//LCD off
// *******************************************
#define key_min	1		//Key minus
#define key_plus 2		//Key plus
#define key_all	0		//both keys
#define key_none 3		//no key pressed
#define wait1	20		//wait for key long enough pressed
#define wait2	14		//slow counting
#define wait3	2		//fast counting	
#define wait4	15		//loop so often before fast count
#define trip	0		//trip mode
#define wheel	1		//wheel circum mode
#define clock	2		//clock mode
#define speed	3		//speed mode
#define maxspeed 4		//max speed mode
#define shutdown 5		//shutdown mode
#define trip2	6		//Second trip mode, comma blinks
#define km_mil	7		//selection mode miles/km
#define restrip	16		//Reset trip1 to 0 mode
#define restrip2	17	//Reset trip2 to 0 mode
#define disp_test	20	//mode to display display test

#define setclk	18		//set clock mode
#define quick	15		//for quickly change trip
#define slowest	125		//longest time before speed is considered 0

// ***** for speed calculation
#define timerfrequ 64	//frequency of timer ticks
#define frequ	4		//Timer frequ. in KHz, here 4096 Hz
#define preload	63		//determine frequency of timer2 (64Hz)
#define steps 64		//frequ*1000/64, steps @ frequ KHz per timer tick
#define Reed_open	(PINE & 0x04)

#define maxuptime 45	//minutes before auto shutdown
#define maxwheelcount 5

#endif //_MAIN_H
