#include <avr/io.h>
#include "simpleprog.h"

void pinMode(uint8_t ddr, uint8_t pin, uint8_t data){
    if(data==1){
        ddr |= (1<<pin);
    }else if(data == 0){
        ddr &= ~(1<<pin);
    }
}

void digWrite(uint8_t port, uint8_t pin, uint8_t data){
    if(data==1){
        port |= (1<<pin);
    }else if(data == 0){
        port &= ~(1<<pin);
    }
}

uint8_t digRead(uint8_t reg, uint8_t pin){
    uint8_t data;
    data = reg&(1<<pin);
    return data>>pin;
}

void anSet(uint8_t pin) {
    ADMUX = 0x00;
    ADCSRA = (1<<ADEN)|(1<<ADPS2);
    ADMUX = (1<<REFS0);
    ADMUX |= pin;
}

uint16_t anRead(uint8_t pin){
    ADCSRA |= (1<<ADSC);
    while(ADCSRA&(1<<ADSC));
    return ADC;
}
