#ifndef UART_H
#define UART_H

#define F_CPU 8000000UL
#define USART_BAUD_RATE 9600UL
#define USART_BAUD_CALC (F_CPU/(USART_BAUD_RATE*16L)-1)

#define LOW(x) ((x) & 0xFF) //Lowbyte
#define HIGH(x) (((x) >> 8) & 0xFF) //Highbyte

void uart_init(void);
void uart_send_char(unsigned char c);
void uart_send_string(char* s);
uint8_t uart_get_char(void);
void uart_get_string(char *buffer, uint8_t MaxLen);

#endif
