#include <avr/io.h>
#include <stdlib.h>
#include "uart.h"

void uart_init(void){
    UBRRH = HIGH(USART_BAUD_CALC);
    UBRRL = LOW(USART_BAUD_CALC);
    
    UCSRB = (1 << RXEN) | (1 << TXEN) | (1 << RXCIE);
    UCSRC = (1 << UCSZ0) | (1 << UCSZ1);
}

void uart_send_char(unsigned char c){
    while(!(UCSRA & (1 << UDRE)));
        UDR = c;
}

void uart_send_string(char* s){
    while(*s){
        uart_send_char(*s);
        s++;
    }
}

uint8_t uart_get_char(void){
    while(!(UCSRA & (1 << RXC)));
        return UDR;
}

void uart_get_string(char *buffer, uint8_t MaxLen){
    uint8_t NextChar;
    uint8_t StringLen = 0;
    
    NextChar = uart_get_char();
    
    while(NextChar != '\n' && StringLen < MaxLen - 1) {
        *buffer++=NextChar;
        StringLen++;
        NextChar = uart_get_char();
    }
    *buffer = '\0';
}
