#include "BMXSensor.hpp"

#define PREAMBLE_ONE 0
#define PREAMBLE_TWO 1
#define LENGTH 2
#define ADDRESS 3
#define COMMAND 4
#define PARAMETER 5
#define CRCL 6
#define CRCH 7

BMXSensor::BMXSensor():
    m_found_devices(0),m_crc_int(0),serialPort(ioService)
{};

uint16_t BMXSensor::found_devices()
{
    return m_found_devices;
}

uint8_t* BMXSensor::found_addresses()
{
    return m_found_addresses;
}

void BMXSensor::OpenPort(int COMPORT, int baud)
{
    serial.OpenPort(COMPORT,baud);
}

void BMXSensor::flash_device()
{   uint32_t  end_of_file = 0;
    uint32_t oversize = 0;
    uint32_t  current_position = 0;
    uint16_t nr_of_packages = 0;
    char *file_buffer;
    ifstream file;
    file.open("SIRKA_EFM32TG110.bin",ios::in | ios::binary | ios::ate);
    if(file.is_open())
    {	/* Größe der Datei holen */
        end_of_file = file.tellg();
        file.seekg(0,ios::beg);
        file_buffer = new char [end_of_file];
        file.read(file_buffer,end_of_file);
		/* Bringt Mikrocontroller in den Flash-Modus */
        m_command[0]=0xAA;	// PRÄAMBLE
        m_command[1]=0xAA;	// PRÄAMBLE
        m_command[2]=0x05;	// Anzahl der Bytes im Paket
        m_command[3]=0x7F;	// Adresse des Controllers
        m_command[4]=0x00;	// Befehl '00'
        serial.SendByteArray(2,m_command,sizeof(m_command));
		/* Anzahl an Paketen bestimmen, Größe in Byte / 8, bei Rest ein Paket dranhängen */
        nr_of_packages = end_of_file / 8;
        if ( end_of_file % 8 != 0)
            nr_of_packages++;
		/* Sende Anzahl der Pakete an den Controller */
        m_command[0]=0xAA;
        m_command[1]=0xAA;
        m_command[2]=0x06;
        m_command[3]=0x7F;
        m_command[4]=(uint8_t)nr_of_packages;		// Lower-Byte der Anzahl der Pakete
        m_command[5]=(uint8_t)(nr_of_packages>>8);	// High-Byte der Anzahl der Pakete
        serial.SendByteArray(2,m_command,sizeof(m_command));

//        serial.ReadByteArray(2,m_buffer,sizeof(m_buffer));
		/* Warte auf Antwort */
         while(!serial.ReadByteArray(2,m_buffer,sizeof(m_buffer)))

		/* Wieder so oft, bis alle Bytes verschickt wurden */
        for ( int k = 0; k < nr_of_packages ; k++)
        {
            for( int i = 0; i < 8; i++)
            {   m_command[0]=0xAA;
                m_command[1]=0xAA;
                m_command[2]=0x0E;
                m_command[3]=0x7F;
                m_command[i+4]=file_buffer[current_position++];
				/* Wenn Ende der datei erreicht, prüfe ob noch freier Platz im Paket ist und fülle ihn mit '00' */
                if ( current_position == end_of_file )
                {
                    for ( oversize = end_of_file % 8; oversize != 0 ; oversize--)
                    {
                        m_command[11-oversize]=0x00;
                    }
                    break;
                }
            }
			/* Berechne CRC */
            m_crc_int = 0;
            for(int crc_count = 0; crc_count < 12 ; crc_count++)
            {
                m_crc_int = m_check.CreateCRC(m_crc_int,m_command[crc_count]);
            }
			/* Packe CRC ins Paket */
            m_command[12] = (uint8_t)m_crc_int;
            m_command[13] = (uint8_t)(m_crc_int >> 8 );
			/* Versende Paket */
            serial.SendByteArray(2,m_command,sizeof(m_command));

//            serial.ReadByteArray(2,m_buffer,sizeof(m_buffer));
			/* Warte auf Antwort */
             while(!serial.ReadByteArray(2,m_buffer,sizeof(m_buffer)))
			/* Falls CRC fehl schlug, sende das Paket erneut */
            if(m_buffer[4]==0x01)
                cout<<"SUCCESS"<<endl;
            else
            {
                cout<<"CRC FAIL"<<endl;
                current_position-=8;
                k--;
            }
            }
    }
    else
    {
        cout<<"No Firmware found!"<<endl;
    }
    file.close();
}

void BMXSensor::change_address()
{
    uint8_t Change[8] = {0xAA,0xAA,0x08,0x01,0x13,0x01,0x00,0x00};
    int old,new_address;
    cout<<"Old Address:";
    cin>>old;
    cout<<"New Address:";
    cin>>new_address;
    Change[3] = (uint8_t)old;
    Change[5] = (uint8_t)new_address;
    m_crc_int = 0;
    for(int crc_count = 0; crc_count < 6 ; crc_count++)
    {
        m_crc_int = m_check.CreateCRC(m_crc_int,Change[crc_count]);
    }
    Change[CRCL] = (uint8_t)m_crc_int;
    Change[CRCH] = (uint8_t)(m_crc_int >> 8 );
    serial.SendByteArray(2,Change,sizeof(Change));
}

void BMXSensor::lookup_addresses()
{
    m_command[PREAMBLE_ONE] = 0xAA;             // PREAMBLE
    m_command[PREAMBLE_TWO] = 0xAA;             // PREAMBLE
    m_command[ADDRESS] = 0x00;                  // set Address to 00
    m_command[LENGTH] = 8;                      // set FRAME LENGTH
    m_command[COMMAND] = 0x14;                  // Choose "send_hello" command
    m_command[PARAMETER] = 0x00;                // No Parameter needed
    int nr = 0;
    m_found_devices = 0;

         for ( int i = 0; i < 127; i++)          // m_check for 20 Sensors
        {
            m_crc_int = 0;
            for(int crc_count = 0; crc_count < 6 ; crc_count++)
            {
                m_crc_int = m_check.CreateCRC(m_crc_int,m_command[crc_count]);
            }
            m_command[CRCL] = (uint8_t)m_crc_int;
            m_command[CRCH] = (uint8_t)(m_crc_int >> 8 );

             serial.SendByteArray(2,m_command,sizeof(m_command));    // Send Hello Byte
             if(serial.ReadByteArray(2,m_buffer,sizeof(m_buffer)))   // Read if answer available
                {   /* If Device responds, increase number of devices and note address */
                    m_found_devices++;                            // If answer, increase nr of devices
                    m_found_addresses[nr++] = (int)m_command[ADDRESS];           // save address to devicenumber
                }
                m_command[ADDRESS]++;                                       // increase address
        }

}
