#include "em_device.h"
#include "em_chip.h"
#include "em_msc.h"
#include "init_device.h"
#include "uart.h"
#include "crc.h"
#include "ramfunc.h"
#include "flash.h"
#include "irq.h"

#define PREAMBLE_ONE 0
#define PREAMBLE_TWO 1
#define LENGTH 2
#define ADDRESS 3
#define COMMAND 4
#define PARAMETER 5
#define CRCL 6
#define CRCH 7

uint8_t received_frame[14];
short frame_position;


void sendWelcomeMessage(void)
{ GPIO_PinOutSet(gpioPortC, 14);
  USART0_sendString("EFM32 AES Bootloader\r\n");

  USART0_sendString("Please enter a command: \r\n"
                    " 0x02 - display this message\r\n"
                    " 0x01 - upload encryped firmware\r\n"
                    " v - verify current firmware\r\n"
                    " l - lock debug access\r\n"
                    " r - reset\r\n");
  GPIO_PinOutClear(gpioPortC, 14);
}

/**************************************************************************//**
 * @brief  Main function
 *****************************************************************************/
int main(void)
{
  /* Chip errata */
  CHIP_Init();
  MSC_Init();
  init_device();
  enable_interrupts();
  Timer_Init();
  /* Infinite loop */
  while (1)
  {
	  sendWelcomeMessage();
	  wait_for_package();
	  //  		  crc = 0x0000;
	  //  		  for(int i = 0; i < (received_frame[LENGTH]-2) ; i++)
	  //  		  {
	  //  			  crc = CRC16(crc,received_frame[i]);
	  //  		  }
	  //  		  crc_ex = (uint16_t)received_frame[CRCH];               // Store CRC-m_checksum
	  //  		  crc_ex <<= 8;
	  //  		  crc_ex |= received_frame[CRCL];
	  //  		  /*
	  //  		   * Check if Preamble OK and frame fully received
	  //  		   */
	  //  		  if(crc == crc_ex)
	  //  		  {

	  		  if((received_frame[PREAMBLE_ONE] == 0xAA) && (received_frame[PREAMBLE_TWO] == 0xAA))
	  			{
	  			  /*
	  			   * Check for address
	  			   */
	  			  if(received_frame[ADDRESS] == 0x7F)
	  			  {	/*
	  				 * select received_frame
	  				 */
	  				switch(received_frame[COMMAND])
	  				  {		/*
	  						 *	Flash Device
	  						 */
	  						case 0x00:	flash_device();
	  									break;

	  						default:
	  									break;
	  					  } // End SWITCH

	  				  } // End Address-Check
	  			  } // End Preamble-Check
	    		  //} // End CRC
	  	  } // End While(1)

	    } // End Main

