/*
 * flash.c
 *
 *  Created on: 20.05.2014
 *      Author: Labor
 */
#include "flash.h"

#define PREAMBLE_ONE 0
#define PREAMBLE_TWO 1
#define LENGTH 2
#define ADDRESS 3
#define COMMAND 4
#define PARAMETER 5
#define CRCL 6
#define CRCH 7

uint32_t address = 0x4000;
uint16_t nr_of_packages = 0;
uint8_t finished[5]={0xAA,0xAA,0x05,0x00,0x01};
uint8_t failed[5]={0xAA,0xAA,0x05,0x00,0x00};
extern uint8_t received_frame[14];
extern short frame_position;

void flash_device()
{	address = 0x4000;
	get_nr_of_packages();
	send_ok();
	for ( int i = 0; i < nr_of_packages ; i++)
	{
		wait_for_package();
		delayfunc(32000);
		if(check_crc())
		{
	//		write_to_flash();
			send_ok();
		}
		else
		{
			send_crc_fail();
		}
	}


}

void get_nr_of_packages()
{
	wait_for_package();
	nr_of_packages = received_frame[5];
	nr_of_packages<<=8;
	nr_of_packages |= received_frame[4];

}
void send_ok()
{
	GPIO_PinOutSet(gpioPortC, 14);
	for ( int i = 0; i < 5 ; i++)
		USART0_send(finished[i]);
	GPIO_PinOutClear(gpioPortC, 14);
}

void send_crc_fail()
{
	GPIO_PinOutSet(gpioPortC, 14);
	for ( int i = 0; i < 5 ; i++)
		USART0_send(failed[i]);
	GPIO_PinOutClear(gpioPortC, 14);
}

void write_to_flash()
{	for ( int j = 0; j < 8; j++)
	received_frame[j] = received_frame[j+4];
	if ( address == 0x4000 || address % 0x200 == 0 )
		MSC_ErasePage(address);
	MSC_WriteWord(address,&received_frame,8);
	address+=0x08;
}

void wait_for_package()
{
	frame_position = 0;
	received_frame[LENGTH] = 10;
	while( frame_position !=  received_frame[LENGTH] )			// stay in sleep mode while not received frame length and address
		  {
			  EMU_EnterEM1();
		  }

}

int check_crc()
{
  volatile uint16_t crc = 0x0000;
  volatile uint16_t crc_ex = 0x0000;
  for(int i = 0; i < (received_frame[LENGTH]-2) ; i++)
  {
	  crc = CRC16(crc,received_frame[i]);
  }
  crc_ex = (uint16_t)received_frame[13];               // Store CRC-m_checksum
  crc_ex <<= 8;
  crc_ex |= received_frame[12];
  if(crc == crc_ex)
	  return 1;
  else
	  return 0;
}
