#include "init_device.h"

#define COM_USART USART0

void USART_Init(void)
{
	USART_InitAsync_TypeDef init = USART_INITASYNC_DEFAULT;

	  init.baudrate     = 1000000;
	  init.oversampling = usartOVS16;
	  init.databits     = usartDatabits8;
	  init.parity       = usartNoParity;
	  init.stopbits     = usartStopbits1;
	  init.mvdis        = 0;
	  init.prsRxEnable  = 0;

	  USART_InitAsync(COM_USART, &init);

	  /* Module USART0 is configured to location 3 */
	   USART0->ROUTE = (USART0->ROUTE & ~_USART_ROUTE_LOCATION_MASK) | USART_ROUTE_LOCATION_LOC3;
	   /* Enable signals TX, RX, CS */
	   USART0->ROUTE |= USART_ROUTE_TXPEN | USART_ROUTE_RXPEN;

}


void GPIO_Init(void)
{
	GPIO_PinModeSet(gpioPortE, 13, gpioModePushPull, 1);	// USART_TX as Output, IDLE High
	GPIO_PinModeSet(gpioPortE, 12, gpioModeInput, 0);		// USART_RX as Input, IDLE Low
	GPIO_PinModeSet(gpioPortC, 14, gpioModePushPull, 0);	// RS485 Read/Write select, IDLE Low for READ

	GPIO->ROUTE |= GPIO_ROUTE_SWOPEN;						// Enable signal SWO
}


void Clocks_Init(void)
{
	  CMU_ClockSelectSet(cmuClock_HF, cmuSelect_HFXO);
	  CMU_ClockEnable(cmuClock_TIMER0, true);   // Enable TIMER0 peripheral clock
	  CMU_ClockEnable(cmuClock_DBG, true);   	// Enable DEBUG Interface peripheral clock
	  CMU_ClockEnable(cmuClock_GPIO, true);   	// Enable GPIO peripheral clock
	  CMU_ClockEnable(cmuClock_USART0, true);   // Enable RS485 peripheral clock
	  CoreDebug->DEMCR |= CoreDebug_DEMCR_TRCENA_Msk;		// Set CoreDebug n CMSIS
	  DWT->CTRL |= 1;										// Activate DWT								// Activate DWT

}

void Timer_Init(void)
{
	TIMER_TopSet(TIMER0,6400);               // Set timer TOP value 100s
	    TIMER_Init_TypeDef timerInit =            // Setup Timer initialization
	    {
	      .enable     = false,                     // Start timer upon configuration
	      .debugRun   = true,                     // Keep timer running even on debug halt
	      .prescale   = timerPrescale1,           // Use /1 prescaler...timer clock = HF clock = 1 MHz
	      .clkSel     = timerClkSelHFPerClk,      // Set HF peripheral clock as clock source
	      .fallAction = timerInputActionNone,     // No action on falling edge
	      .riseAction = timerInputActionNone,     // No action on rising edge
	      .mode       = timerModeUp,              // Use up-count mode
	      .dmaClrAct  = false,                    // Not using DMA
	      .quadModeX4 = false,                    // Not using quad decoder
	      .oneShot    = false,                    // Using continuous, not one-shot
	      .sync       = false,                    // Not synchronizing timer operation off of other timers
	    };
	    TIMER_IntEnable(TIMER0, TIMER_IF_OF);     // Enable Timer0 overflow interrupt
	    NVIC_EnableIRQ(TIMER0_IRQn);              // Enable TIMER0 interrupt vector in NVIC
	    TIMER_Init(TIMER0, &timerInit);           // Configure and start Timer0
}

void init_device(void)
{
	Clocks_Init();
	GPIO_Init();
	USART_Init();
	Timer_Init();

}

