/*
 * irq.c
 *
 *  Created on: 17.03.2014
 *      Author: Labor
 */


#include "irq.h"


extern uint8_t received_frame[14];
extern short frame_position;
void enable_interrupts(void)
{
	/* Enable interrupts */
	NVIC_ClearPendingIRQ(USART0_RX_IRQn);
	NVIC_EnableIRQ(USART0_RX_IRQn);
	USART0->IEN |= USART_IEN_RXDATAV;
}

void USART0_RX_IRQHandler(void)
{
	if(frame_position == 0)			// Start Timer when receiving first IRQ
			TIMER_Enable(TIMER0, true);
	received_frame[frame_position++] = USART0->RXDATA;
	if(frame_position == received_frame[2])				// if full frame received deactivate timer
			{
				TIMER_Enable(TIMER0, false);
			}
}

void TIMER0_IRQHandler(void)
{
	TIMER_IntClear(TIMER0, TIMER_IF_OF);      // Clear overflow flag

	frame_position = 0;				// if connection gets lost while receiving frame, reset to 0
	TIMER_Enable(TIMER0, false);	// disable timer
}
