/*
 * Copyright (c) 2013 - 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "board.h"
#include "fsl_device_registers.h"
#include "fsl_ftm_driver.h"
#include "fsl_ftm_hal.h"
#include "fsl_ftm_features.h"
#include "fsl_uart_driver.h"
#include "fsl_clock_manager.h"
#include "fsl_port_hal.h"
#include "fsl_gpio_hal.h"
#include <string.h>

void init_hardware(void);

void delay(unsigned int delay_value)
{
    unsigned int i, j, k;

    for (i=0; i<delay_value; i++)
    {
        for (j=0; j<0xF; j++)
        {
            for (k=0; k<0xFFFF; k++)
            {
                __ASM volatile("nop");
            }
        }
    }

}

void main(void)
{
    //uPulseLowWidth ranges from 0 to 20
    uint32_t uPulseLowWidth = 0;

    ftm_pwm_param_t param = {
        .uFrequencyHZ = 240000,
        .uPulseHighPercentage = 0,
        .uPulseLowPercentage = 0,
        .uCnV = 0,
    };

    hardware_init();

    configure_ftm_pin_mux(BOARD_FTM_INSTANCE);

    clock_manager_set_gate(kClockModuleFTM, BOARD_FTM_INSTANCE, true);

    ftm_user_config_t driver_info;
    memset(&driver_info, 0, sizeof(driver_info));
    driver_info.instance    = BOARD_FTM_INSTANCE;
    driver_info.clockSrc    = kClock_source_FTM_SystemClk;
    driver_info.clockPS     = kFtmDividedBy2;
    driver_info.counterInitVal = 20;

    driver_info.channleInfo[BOARD_FTM_CHANNEL].mode = kFtmEdgeAlignedPWM;
    driver_info.channleInfo[BOARD_FTM_CHANNEL].edge_mode.ftm_pwm_edge_mode = kFtmHighTrue;
    driver_info.channleInfo[BOARD_FTM_CHANNEL].isChannelEnabled = true;
    
    ftm_init(BOARD_FTM_INSTANCE, &driver_info);

    while(1)
    {
        //LED changes light to show PWM width
        param.uPulseHighPercentage = 20 - uPulseLowWidth;
        param.uPulseLowPercentage = uPulseLowWidth;

        ftm_pwm_configure(&driver_info, BOARD_FTM_CHANNEL, &param);
        ftm_pwm_start(&driver_info, BOARD_FTM_CHANNEL);
        
        delay(1);
        
        ftm_pwm_stop(&driver_info, BOARD_FTM_CHANNEL);

        if (uPulseLowWidth++ > 20)
        { 
            uPulseLowWidth = 0;
        }
    }
}


