/*
 * Copyright (c) 2013 - 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _GPIO_UART_H_
#define _GPIO_UART_H_

/*******************************************************************************
 * Definitions
 ******************************************************************************/

#if (defined(CPU_MK70FN1M0VMJ12)) 

#define UART_RX_INSTANCE        HW_PORTE
#define UART_RX_PIN_NUM         17
#define UART_TX_INSTANCE        HW_PORTE
#define UART_TX_PIN_NUM         16

#elif ((defined(twrk22f120m)) || (defined(frdmk22f120m)))

#define UART_RX_INSTANCE        HW_PORTE
#define UART_RX_PIN_NUM         1
#define UART_TX_INSTANCE        HW_PORTE
#define UART_TX_PIN_NUM         0

#elif (defined(twrk64f120m))

#define UART_RX_INSTANCE        HW_PORTC
#define UART_RX_PIN_NUM         3
#define UART_TX_INSTANCE        HW_PORTC
#define UART_TX_PIN_NUM         4

#elif (defined(frdmk64f120m))

#define UART_RX_INSTANCE        HW_PORTB
#define UART_RX_PIN_NUM         16
#define UART_TX_INSTANCE        HW_PORTB
#define UART_TX_PIN_NUM         17

#else
#error No valid platform defined.  
#endif

#endif  /* END _GPIO_UART_H_  */
