/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>

#include "app_cfg.h"
#include "fsl_smc_manager.h"
#include "i2c_rtos.h"

/*******************************************************************************
 * Defination
 ******************************************************************************/

/* task prio */
#define TASK_START_PRIO          2
#define TASK_MASTER_PRIO         4
#define TASK_SLAVE_PRIO          6
#define TASK_SAMPLE_PRIO         5

/* task size */
#define TASK_START_STACK_SIZE    512
#define TASK_MASTER_STACK_SIZE   1024
#define TASK_SLAVE_STACK_SIZE    512
#define TASK_SAMPLE_STACK_SIZE   512

extern uint32_t gSlaveId;

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
extern void systick_init(void);
/* task declare */
static void task_start(void *param);
extern void task_master(void *param);
extern void task_slave(void *param);
extern void task_sample(void *param);
/********************************************************************************
 * Variables
 ******************************************************************************/
/* task define */
FSL_RTOS_TASK_DEFINE(task_start, TASK_START_STACK_SIZE, "start", false);
FSL_RTOS_TASK_DEFINE(task_master, TASK_MASTER_STACK_SIZE, "master", false);
FSL_RTOS_TASK_DEFINE(task_slave, TASK_SLAVE_STACK_SIZE, "slave", false);
FSL_RTOS_TASK_DEFINE(task_sample, TASK_SAMPLE_STACK_SIZE, "sample", false);
/* global handler var */
task_handler_t hTaskStart;
task_handler_t hTaskMaster;
task_handler_t hTaskSlave;
task_handler_t hTaskSample;

 /*******************************************************************************
 * Code
 ******************************************************************************/

void main(void)
{
    hardware_init();
    gpio_init(NULL, ledPins);

    /* SMC Power mode protection configurations */
    smc_power_mode_protection_config_t smc_power_prot_cfg = 
    {
        .vlpProt = true,
        .llsProt = false,
        .vllsProt = false
    };
    /* Configure the power mode protection */
    smc_hal_config_power_mode_protection(&smc_power_prot_cfg);

    /* get cpu uid low value for slave */
    gSlaveId = HW_SIM_UIDL_RD();

    systick_init();
    OSInit();

    /* create start task */
    task_create(task_start, TASK_START_PRIO, (void *)0, &hTaskStart);

    OSStart();
}

static void task_start(void *param)
{
    param = param;

    /* create app tasks */
    if (task_create(task_master, TASK_MASTER_PRIO, (void *)0, &hTaskMaster))
    {
        return;
    }
    if (task_create(task_slave, TASK_SLAVE_PRIO, (void *)0, &hTaskSlave))
    {
        return;
    }
    if (task_create(task_sample, TASK_SAMPLE_PRIO, (void *)0, &hTaskSample))
    {
        return;
    }
    /* destroy start task */
    task_destroy(hTaskStart);
}
