/*
 * Copyright (c) 2013 - 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __LOW_POWER_DEMO_H__
#define __LOW_POWER_DEMO_H__

#include <stdint.h>
#include "uart/fsl_uart_driver.h"
#include "smc/fsl_smc_manager.h"
#include "fsl_mcg_hal.h"

/*******************************************************************************
 * Defination
 ******************************************************************************/
#define LOW_POWER 0                     /*!< Low power indication during PLL initialization */
#define HIGH_GAIN 1                     /*!< High power indication during PLL initialization */

#define CLK0_TYPE           CRYSTAL     /*!< Clock type indication */

#define MCGOUT 1                        /*!< MCG out indication during PLL initialization */         
   
#define SWD_CLK_DISABLE port_hal_mux_control(HW_PORTA, 0, kPortPinDisabled)        /*!< Disable SWD port clock */
#define SWD_DIO_DISABLE	port_hal_mux_control(HW_PORTA, 3, kPortPinDisabled)        /*!< Disable SWD port DIO */
   
#define SWD_CLK_ENABLE port_hal_mux_control(HW_PORTA, 0, kPortMuxAlt7)         /*!< Enable SWD port clock */
#define SWD_DIO_ENABLE port_hal_mux_control(HW_PORTA, 3, kPortMuxAlt7)         /*!< Enable SWD port DIO */

   
#if defined(FRDM_KL25Z48M)
/* LED defines */
//#define LED0_EN (port_hal_mux_control(HW_PORTB, 18, kPortMuxAsGpio))                     /*!< Enable target LED0 */
//#define LED1_EN (port_hal_mux_control(HW_PORTB, 18, kPortMuxAsGpio))                     /*!< Enable target LED1 */
//#define LED2_EN (port_hal_mux_control(HW_PORTD, 1, kPortMuxAsGpio))                      /*!< Enable target LED2 */

//#define LED0_OFF (gpio_write_pin_output(rgb_led_pins[0].pinName, 1))    /*!< Turn off target LED0 */
//#define LED1_OFF (gpio_write_pin_output(rgb_led_pins[1].pinName, 1))    /*!< Turn off target LED1 */
//#define LED2_OFF (gpio_write_pin_output(rgb_led_pins[2].pinName, 1))    /*!< Turn off target LED2 */

//#define LED0_ON (gpio_write_pin_output(rgb_led_pins[0].pinName, 0))     /*!< Turn on target LED0 */
//#define LED1_ON (gpio_write_pin_output(rgb_led_pins[1].pinName, 0))     /*!< Turn on target LED1 */
//#define LED2_ON (gpio_write_pin_output(rgb_led_pins[2].pinName, 0))     /*!< Turn on target LED2 */

//#elif defined(TWR_K22F120M)
#else
/* LED defines */
#define LED0_EN (port_hal_mux_control(HW_GPIOD, 4, kPortMuxAsGpio))                      /*!< Enable target LED0 */
#define LED1_EN (port_hal_mux_control(HW_GPIOD, 5, kPortMuxAsGpio))                      /*!< Enable target LED1 */
#define LED2_EN (port_hal_mux_control(HW_GPIOD, 6, kPortMuxAsGpio))                      /*!< Enable target LED2 */
#define LED3_EN (port_hal_mux_control(HW_GPIOD, 7, kPortMuxAsGpio))                      /*!< Enable target LED3 */

#define LED0_OFF (gpio_write_pin_output(ledPins[0].pinName, 1))         /*!< Turn off target LED0 */
#define LED1_OFF (gpio_write_pin_output(ledPins[1].pinName, 1))         /*!< Turn off target LED1 */
#define LED2_OFF (gpio_write_pin_output(ledPins[2].pinName, 1))         /*!< Turn off target LED2 */
#define LED3_OFF (gpio_write_pin_output(ledPins[3].pinName, 1))         /*!< Turn off target LED3 */

#define LED0_ON (gpio_write_pin_output(ledPins[0].pinName, 0))          /*!< Turn on target LED0 */
#define LED1_ON (gpio_write_pin_output(ledPins[1].pinName, 0))          /*!< Turn on target LED1 */
#define LED2_ON (gpio_write_pin_output(ledPins[2].pinName, 0))          /*!< Turn on target LED2 */
#define LED3_ON (gpio_write_pin_output(ledPins[3].pinName, 0))          /*!< Turn on target LED3 */
#endif

/* MCG Mode defines */
#define BLPI 1  /*!< BLPI MCG mode */
#define FBI  2  /*!< FBI MCG mode */
#define FEI  3  /*!< FEI MCG mode */
#define FEE  4  /*!< FEE MCG mode */
#define FBE  5  /*!< FBE MCG mode */
#define BLPE 6  /*!< BLPE MCG mode */
#define PBE  7  /*!< PBE MCG mode */
#define PEE  8  /*!< PEE MCG mode */


#define UNDEF_VALUE  0xFF

#ifdef  ON
#undef  ON
#endif
#define ON      (1)

#ifdef  OFF
#undef  OFF
#endif
#define OFF     (0)

/* LLWU specific macros */   
#define LLWU_PIN_DIS 0          /*!< LLWU wake up through external pin is disabled */
#define LLWU_PIN_RISING 1       /*!< LLWU wake up through external pin rising edge */
#define LLWU_PIN_FALLING 2      /*!< LLWU wake up through external pin falling edge */
#define LLWU_PIN_ANY 3          /*!< LLWU wake up through external pin at both rising and falling edges */

/* LP Tiemr specific macros */   
#define LPTMR_USE_IRCLK 0       /*!< LP Timer modules uses Internal Reference Clock */
#define LPTMR_USE_LPOCLK 1      /*!< LP Timer modules uses 1KHz clock */
#define LPTMR_USE_ERCLK32 2     /*!< LP Timer modules uses 32KHz External Reference Clock */
#define LPTMR_USE_OSCERCLK 3    /*!< LP Timer modules uses External Reference Clock */

/* Clock specific macros */   
#if (defined(TWR_K22F120M) || defined(FRDM_K22F120M))
#define CLK0_FREQ_HZ        8000000     /*!< 8MHz External Reference Clock */
#elif (defined(FRDM_K64F120M) || defined(TWR_K64F120M))
#define CLK0_FREQ_HZ		50000000 	/*!< 50MHz External Reference Clock */
#endif

#define CRYSTAL 1                       /*!< Crystal */
#define CANNED_OSC 0                    /*!< CANNED_OSC */

/* IRC defines */
#define SLOW_IRC 0                      /*!< Slow Internal Reference Clock */
#define FAST_IRC 1                      /*!< Fast Internal Reference Clock */

#define MCG_OUT_FREQ 48000000           /*!< Given MCG OUT Clock frequency*/

#if defined(CPU_MK22FN512VDC12)
#define OSC0_CR                         OSC_CR
#define SMC_STOPCTRL_VLLSM_MASK         SMC_STOPCTRL_LLSM_MASK
#endif

#if defined(CPU_MKL25Z128VLK4)       
#define sysinit                         SystemInit                                       
#endif

/* 
 * The expected PLL output frequency is:
 * PLL out = ((CLKIN/PRDIV) x VDIV)
 * where the CLKIN is CLK0_FREQ_HZ.
 *
 */

#define PLL0_PRDIV      4       /*!<divide reference by 4 = 2 MHz */
#define PLL0_VDIV       24      /*!<multiply reference by 24 = 48 MHz */

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
void clock_monitor(uint8_t enable);
void init_hardware(void);   
void low_power_modes_test(void);
void llwu_init(void);
void led_init(void);

int printf_demo(const char *format,...);
void demo_lptmr_isr(void);
void port_isr(void);
void port_init(void);
void set_for_lp(uint8_t outOfLp);
int32_t pee_to_blpe(void);
int32_t blpe_to_pee(void);
void jtag_tdo_pullup_enable(void);
void vlp_clock_config(int8_t nextMode);
int32_t fll_freq(int32_t fllRef);
uint8_t what_mcg_mode(void);
void llwu_configure(uint32_t pinEn, uint8_t riseFall, uint8_t moduleEn );
void demo_lptmr_isr(void);
void lptmr_init(uint32_t count, uint32_t clockSource);

void exit_vlpr(void);
void enter_stop(smc_stop_submode_t partialStopOpt);
int32_t enter_vlpr(void);
void enter_wait(power_modes_t pMode);
void enter_vlls0(uint8_t PORPOValue);
void enter_vlls1(void);
void enter_vlls2(void);
void enter_vlls3(void);
void enter_vlps(void);
void enter_lls(void);
void vlp_clock_config(int8_t nextMode);
uint8_t atc(uint8_t ircSelect, int32_t ircFreq, int32_t mcgOutFreq);

int32_t fee_fei(int32_t slowIrcFreqInner);
int32_t fei_fbe(int32_t crystalVal, mcg_hgo_select_t hgoVal, mcg_eref_clock_select_t erefsVal);
int32_t fbe_fei(int32_t slowIrcFreq);
int32_t fei_fbi(int32_t ircFreq, uint8_t ircSelect);
int32_t fbi_fei(int32_t slowIrcFreqInner);
int32_t fbe_pbe(int32_t crystalVal, int8_t prDivVal, int8_t vDivVal);
int32_t pbe_pee(int32_t crystalVal);
int32_t pee_pbe(int32_t crystalVal);
int32_t pbe_fbe(int32_t crystalVal);
int32_t fbe_fbi(int32_t ircFreq, uint8_t ircSelect);
int32_t fbi_fbe(int32_t crystalVal, mcg_hgo_select_t hgoVal, mcg_eref_clock_select_t erefsVal);
int32_t fbi_fee(int32_t crystalVal, mcg_hgo_select_t hgoVal, mcg_eref_clock_select_t erefsVal);
int32_t fbe_fee(int32_t crystalVal);
int32_t fee_fbe(int32_t crystalVal);
int32_t pbe_blpe(int32_t crystalVal);
int32_t blpe_pbe(int32_t crystalVal, int8_t prDivVal, int8_t vDivVal);
int32_t blpe_fbe(int32_t crystalVal);
int32_t fbi_blpi(int32_t ircFreq, uint8_t ircSelect);
int32_t blpi_fbi(int32_t ircFreq, uint8_t ircSelect);
int32_t fei_fee(int32_t crystalVal, mcg_hgo_select_t hgoVal, mcg_eref_clock_select_t erefsVal);
int32_t fee_fbi(int32_t ircFreq, uint8_t ircSelect);
int32_t fbe_blpe(int32_t crystalVal);
int32_t pll_init(int32_t crystalVal, mcg_hgo_select_t hgoVal, mcg_eref_clock_select_t erefsVal, int8_t prDivVal, int8_t vDivVal, uint8_t mcgOutSelect);
void out_srs(void);
void get_uart_data(uart_state_t * uartState, uint8_t * rxBuffer, uint32_t requestedByteCount);

#endif /* __LOW_POWER_DEMO_H__*/

/*******************************************************************************
 * EOF
 ******************************************************************************/
