/*
 * Copyright (c) 2013 - 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*******************************************************************************
 * Standard C Included Files
 ******************************************************************************/
#include <stdio.h>
/*******************************************************************************
 * Application Included Files
 ******************************************************************************/
#include "terminal_menu.h"
/*******************************************************************************
 * Function Definitions
 ******************************************************************************/
void menu_start(void)
{
    volatile char msg;
    
    printf("\r\nAudio Modulator Demo!\r\n");    
    
    printf("\r\nPress spacebar to start demo.\r\n");

    msg = 'A';
	
    while(msg != ' ')
    {
	#if defined(__ICCARM__)
	    msg = getchar();
	#elif defined(__GNUC__)
        while(!uart_hal_is_receive_data_register_full(BOARD_DEBUG_UART_INSTANCE)) {}
        uart_hal_getchar(BOARD_DEBUG_UART_INSTANCE, (uint8_t *)&msg);	
	#endif	
    }

    printf("\r\nDemo begin...\r\n" );
}

char menu_note_select(void)
{
    char msg;
  
    printf("\r\n\r\nSelect note to play:\r\n\t1. C4\r\n\t2. D4\r\n\t3. E4\r\n\t4. F4\r\n\t5. G4\r\n\t6. A4\r\n\t7. B4\r\n\t8. C5\r\n->");
    
    msg = ' ';

    while((msg < '1') || (msg > '8'))
    {
	#if defined(__ICCARM__)
	    msg = getchar();
	#elif defined(__GNUC__)
        while(!uart_hal_is_receive_data_register_full(BOARD_DEBUG_UART_INSTANCE)) {}
        uart_hal_getchar(BOARD_DEBUG_UART_INSTANCE, (uint8_t *)&msg);	
	#endif	
    }
    
    printf("%c", msg);
    
    return msg;
}

char menu_duration_select(void)
{
    char msg;
  
    printf("\r\n\r\nSelect note duration:\r\n\t1. 200ms\r\n\t2. 100ms\r\n\t3. 50ms\r\n->"); 
    
    msg = ' ';
	
    while((msg < '1') || (msg > '3'))
    {
	#if defined(__ICCARM__)
	    msg = getchar();
	#elif defined(__GNUC__)
        while(!uart_hal_is_receive_data_register_full(BOARD_DEBUG_UART_INSTANCE)) {}
        uart_hal_getchar(BOARD_DEBUG_UART_INSTANCE, (uint8_t *)&msg);	
	#endif	
    }
    
    printf("%c", msg);   
    
    return msg;
}

char menu_modulation_select(void)
{
    char msg;
  
    printf("\r\n\r\nSelect note modulation:\r\n\t1. none\r\n\t2. Square\r\n\t3. Saw\r\n\t4. Triangle\r\n->");  
    
    msg = ' ';
    
    while((msg < '1') || (msg > '4'))
    {
	#if defined(__ICCARM__)
	    msg = getchar();
	#elif defined(__GNUC__)
        while(!uart_hal_is_receive_data_register_full(BOARD_DEBUG_UART_INSTANCE)) {}
        uart_hal_getchar(BOARD_DEBUG_UART_INSTANCE, (uint8_t *)&msg);	
	#endif	
    }
    
    printf("%c", msg);     
    
    return msg;
}

/******************************************************************************
 * EOF
 ******************************************************************************/