/*
 * Copyright (c) 2013, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __PLAYSOUND_H__
#define __PLAYSOUND_H__

#include <stdint.h>
#include "fsl_soundcard.h"
#include "fsl_sgtl5000_driver.h"


/*******************************************************************************
 * Defination
 ******************************************************************************/
//!< brief standards Winodws PCM wave file header length
#define WAVE_FILE_HEADER_SIZE  (0x2C)
//!< Standard Windows PCM wave file header struct.
typedef struct wave_header  
{  
    uint8_t riff[4];
    uint32_t size;
    uint8_t wave_flag[4];
    uint8_t fmt[4];
    uint32_t fmt_len;
    uint16_t tag;
    uint16_t channels;
    uint32_t samp_freq;
    uint32_t byte_rate;
    uint16_t block_align;
    uint16_t bit_samp;
    uint8_t data_flag[4];
    uint32_t length;
} wave_header_t;  

//!< @brief wave file struct.
//!< uint32_t* pData is not used in current design.
typedef struct wave_file  
{  
    wave_header_t header;  //!< windows PCM wavfile header
    uint32_t *pData;       //!< data pointer
} wave_file_t;  

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
//!< @brief Get data callback functions Prototypes
typedef uint32_t (*APP_GET_DATA_FUNC)(uint32_t NumBytesReq,  uint8_t **ppDada, uint32_t offset);
//!< API funcions
int PLAYSOUND_GetWaveFileInfo(uint8_t* pBuffer, wave_file_t *pWave);
int PLAYSOUND_Play(APP_GET_DATA_FUNC fpAppGetData);
void PLAYSOUND_Init(void);

#endif

/*******************************************************************************
 * EOF
 ******************************************************************************/
