/*
 * Copyright (c) 2013 - 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __CHAR_HANDLE_H__
#define __CHAR_HANDLE_H__

#include "board.h"
#include "fsl_uart_hal.h"

/*!
 * @brief getc redefine to uart getchar function.
 */
#undef getc
#define getc(x) \
    {   \
        if (uart_hal_is_receive_data_register_full(BOARD_DEBUG_UART_INSTANCE))  \
            uart_hal_getchar(BOARD_DEBUG_UART_INSTANCE, x); \
    }

/*!
 * @brief putc redefine to uart putchar function.
 */
#undef putc
#define putc(x) \
   {   \
       while (!uart_hal_is_transmit_data_register_empty(BOARD_DEBUG_UART_INSTANCE)) \
       {   \
       }   \
       uart_hal_putchar(BOARD_DEBUG_UART_INSTANCE, x);  \
   }

/*!
 * @brief     Output a string via uart. No /n appended.
 *
 * @param[in] s       Pointer of output string.
 */

static inline void cmd_puts(const char *s)
{
    while (*s)
    {
        while (!uart_hal_is_transmit_data_register_empty(BOARD_DEBUG_UART_INSTANCE))
	{
        }

        putc(*s++);
    }
}

#endif
