#----------------------------------------------------------
# Include the drivers according to the chip.
# If a driver will be build in to platform_lib, add the
# folder's name to SUB_DIR, then the file "subdir.mk" in
# the folder will be included.
# e.g, if adc driver will be added to the K70F12's platform_lib,
# just add "adc" to K70F12's SUB_DIR. Here, "adc" is the
# foler's name where adc source code is.
#----------------------------------------------------------

ifeq "$(CHIP)" "K22F51212"
SUB_DIR := adc clock edma dspi flextimer gpio i2c interrupt \
           pit rtc sai smc uart wdog
endif

ifeq "$(CHIP)" "K64F12"
SUB_DIR := adc can clock edma dspi enet flextimer gpio i2c interrupt \
           pit rtc sai sdhc smc uart wdog
endif

ifeq "$(CHIP)" "K70F12"
SUB_DIR := adc can clock edma dspi enet flextimer gpio i2c interrupt \
           pit rtc sai sdhc smc uart wdog
endif

ifeq "$(CHIP)" "KL25Z4"
SUB_DIR := adc clock dma gpio i2c interrupt microseconds \
           pit rtc smc spi uart
endif

subdir = $(foreach dir, $(SUB_DIR), $(SDK_ROOT)/platform/drivers/$(dir)/subdir.mk)

include $(subdir)

