/**HEADER********************************************************************
* 
* Copyright (c) 2008, 2013 Freescale Semiconductor;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: usb_host_hub_prv.h$
* $Version : 3.8.8.0$
* $Date    : Jun-7-2012$
*
* Comments:
*
*   This file defines a structure(s) for hub class driver.
*
*END************************************************************************/
#ifndef __usb_host_hub_prv_h__
#define __usb_host_hub_prv_h__

//#include <mqx.h>

//#include "usb.h"
//#include "usb_prv.h"

#define  C_HUB_LOCAL_POWER          (0)
#define  C_HUB_OVER_CURRENT         (1)
#define  PORT_CONNECTION            (0)
#define  PORT_ENABLE                (1)
#define  PORT_SUSPEND               (2)
#define  PORT_OVER_CURRENT          (3)
#define  PORT_RESET                 (4)
#define  PORT_POWER                 (8)
#define  PORT_LOW_SPEED             (9)
#define  PORT_HIGH_SPEED            (10)
#define  C_PORT_CONNECTION          (16)
#define  C_PORT_ENABLE              (17)
#define  C_PORT_SUSPEND             (18)
#define  C_PORT_OVER_CURRENT        (19)
#define  C_PORT_RESET               (20)
#define  C_PORT_POWER               (24)
#define  PORT_TEST                  (21)
#define  PORT_INDICATOR             (22)

/* structure for HUB class descriptor */
typedef struct {
    uint8_t     BLENGTH;
    uint8_t     BDESCRIPTORTYPE;
    uint8_t     BNRPORTS;
    uint8_t     WHUBCHARACTERISTICS[2];
    uint8_t     BPWRON2PWRGOOD;
    uint8_t     BHUBCONTRCURRENT;
    uint8_t     DEVICEREMOVABLE[];
/* not used: */
/*    uint8_t     PORTPOWERCTRLMASK; */
} HUB_DESCRIPTOR_STRUCT, * HUB_DESCRIPTOR_STRUCT_PTR;

typedef struct {
    uint16_t    WHUBSTATUS;
    uint16_t    WHUBCHANGE;
} HUB_STATUS_STRUCT, * HUB_STATUS_STRUCT_PTR;

/* Class specific functions exported by hub class driver */
#ifdef __cplusplus
extern "C" {
#endif

//usb_status usb_class_hub_get_app(usb_device_instance_handle, usb_interface_descriptor_handle, CLASS_CALL_STRUCT_PTR *);
usb_status usb_class_hub_cntrl_common(HUB_COMMAND_PTR, uint8_t, uint8_t, uint16_t, uint16_t, uint16_t, uint8_t *);
void usb_class_hub_cntrl_callback(void*, void *, uint8_t *, uint32_t, usb_status);
usb_status usb_class_hub_get_descriptor(HUB_COMMAND_PTR, uint8_t*, uint8_t);
usb_status usb_class_hub_set_port_feature(HUB_COMMAND_PTR, uint8_t, uint8_t);
usb_status usb_class_hub_clear_feature(HUB_COMMAND_PTR, uint8_t);
usb_status usb_class_hub_clear_port_feature(HUB_COMMAND_PTR, uint8_t, uint8_t);
usb_status usb_class_hub_get_status(HUB_COMMAND_PTR, uint8_t*, uint8_t);
usb_status usb_class_hub_get_port_status(HUB_COMMAND_PTR, uint8_t, uint8_t*, uint8_t);

usb_status usb_class_hub_recv_bitmap(HUB_COMMAND_PTR, uint8_t*, uint8_t);
void usb_class_hub_int_callback(void*, void *, uint8_t *, uint32_t, usb_status);

#ifdef __cplusplus
}
#endif

#endif
