; ******************************************************************************
; * Thermometer.asm - Abschlussprojekt HBFI05a von Steffen Schalhorst          *
; ******************************************************************************                                                                               
; Mit Hilfe des PIC-Mikrocontroller 16F84A soll mit Hilfe des 1-Wire           *
; Sensors DS18S20 ein Thermometer aufgebaut werden.                            *
; Der PIC bekommt die Daten ber den Port RA,0.                                *
; Die gemessenen Werte werden BCD codiert und an einen BCD/7-Segement          *
; Decoder gesendet der diesen Wert an die Entsprechenden Anzeigen sendet       *
; die nacheinander Eingeschaltet werden.                                       *
; ******************************************************************************         
; EINGNGE:                                                                    *
;                                                                              *           
; RA,0 --> 1-Wire Sensor DS18S20                                                *
; RA,1 --> Taster 1 Hchste Temp.                                              *
; RA,2 --> Taster 2 Niedrigste Temp.                                           *
; ******************************************************************************                                    
; AUSGNGE:                                                                    *
;                                                                              *                                      
; RB,0 --> BCD/7 Segement Decoder Eingang IA                                   *
; RB,1 --> BCD/7 Segement Decoder Eingang IB                                   *
; RB,2 --> BCD/7 Segement Decoder Eingang IC                                   *
; RB,3 --> BCD/7 Segement Decoder Eingang ID                                   *
; RB,4 --> BCD/7 Segement Decoder Eingang LT                                                                            *
; RB,5 -->Transistor 1 fr Anzeige 1 zu schalten                               *
; RB,6 -->Transistor 2 fr Anzeige 2 zu schalten                               *
; RB,7 -->Transistor 3 fr Anzeige 3 zu schalten                               *
;*******************************************************************************

;*******************************************************************************
;* Bestimmung des Prozessortyps fr den Assembler und das Programmiergert     *
;*******************************************************************************
		LIST p=16F84A
;*******************************************************************************
;* Includedatei fr den 16F84A einbinden (vordef. Reg. und Konst.)             *
;*******************************************************************************

		#include <p16f84A.INC>

; Diese Datei enthlt Vordefinitionen fr wichtige Register und Konstanten.
; (Z.B. gibt es die Konstante PORTB mit der sich ohne Angabe der
; absoluten Adresse H'0006' der Port B des Prozessors ansprechen lsst)


;*******************************************************************************
;* Konfigurationseinstellungen fr IC-Prog vordefinieren                       *
;*******************************************************************************

		__CONFIG _PWRTE_ON & _CP_OFF & _HS_OSC & _WDT_OFF

; Hier werden verschiedene Prozessoreigenschaften festgelegt:
; PWRTE_ON schaltet den Power Up Timer ein, d.h. der Prozessor wartet nach
; dem Einschalten ca. 70ms mit dem Programmstart, um sicher zu sein,
; dass alle angeschlossene Peripherie bereit ist.
; CP_OFF schaltet die Code-Protection des Prozesors aus. Damit ist das im Prozessor
; befindliche Programm jederzeit auslesbar und berschreibbar.
; HS_OSC spezifiziert einen Quarzoszillator (Highspeed) als Zeitbasis fr den Prozessor.
; WDT_OFF schaltet den Watchdog-Timer des Prozesors aus.


;*******************************************************************************
;*                         Register / Variablen  festlegen                     *
;*******************************************************************************
; hier werden Adressen von Registern / Variablen festgelegt. Diese werden beginnend
; mit der Adresse H'20' aufsteigend vergeben.
	CBLOCK	H'20'
	         sensor   ; Variable wird benutzt um den ausgelesenen ByteCode vom Sensor geschrieben
		bcd_wert ; Variable in den der Umgewandelte Wert von Sensor geschrieben wird
		
		wait
	         wait_1
	         wait_2
		
				
	ENDC
;*******************************************************************************
;*                         Konstanten festlegen                                * 
;*******************************************************************************

; Hier sollten alle im Verlauf des Programms verwendeten Konstanten deklariert werden.
; Die Deklaration sieht z.B. folgendermaen aus:

;*******************************************************************************
;*  Definition von einzelnen Bits in einem Register / in einer Variable        *
;*******************************************************************************
; hier kann mit Hilfe der #DEFINE Direktive einzelnen Bits in einem Register ein
; Name zugewiesen werden.
; Eine Definition sieht z.B. folgendermaen aus:
;
;*******************************************************************************
;*       Name       *       Port       * Bedeutung / Funktion                  *
;*******************************************************************************
#DEFINE  Sensor            PORTA,0        ;Anschluss fr 1-Wire Sensor
#DEFINE  TH                PORTA,1        ;Taster fr hchste Temperatur -->TH =Temp High 
#DEFINE  TL                PORTA,2        ;Taster fr niedrigste Temperatur -->TL =Temp Low 
;*******************************************************************************
#DEFINE  IA                PORTB,0        ;BCD Decoder Eingang IA  
#DEFINE  IB                PORTB,1        ;BCD Decoder Eingang IB 
#DEFINE  IC                PORTB,2        ;BCD Decoder Eingang IC 
#DEFINE  ID                PORTB,3        ;BCD Decoder Eingang ID
;*******************************************************************************
#DEFINE  T1                PORTB,7        ;Transistor T1 --> Fr Anzeige 1
#DEFINE  T2                PORTB,6        ;Transistor T2 --> Fr Anzeige 2
#DEFINE  T3                PORTB,5        ;Transistor T3 --> Fr Anzeige 3  
#DEFINE	bank1		STATUS, RP0 ;Spezielle Register Bank
;*******************************************************************************
;*******************************************************************************
;*                                  Programmstart                              *
;*******************************************************************************
	ORG	H'00'		; Das Programm wird ab Speicherstelle 0 in den Speicher geschrieben
	GOTO	init		; Springe zur Grundinitialisierung der Ports A und B
;*******************************************************************************
;*                                  Initialisierung                            *
;*******************************************************************************
init	BSF	bank1		; wechsle zu Registerbank 1 (spezielle Register)
	MOVLW	B'00011111'
	MOVWF	TRISA		; RA0 .. RA4 Eingnge
	MOVLW	B'00000000'
	MOVWF	TRISB		; RB0-RB7 Ausgnge
	BCF	bank1		; wechsle zu Registerbank 0 (normaler Speicherbereich)
        
	CLRF	PORTA		; Port A lschen
	CLRF	PORTB		; Port B lschen
        
; Die Register TRISA und TRISB legen fest, welche Bits in den jeweiligen Ports Ein- bzw.
; Ausgnge sind. Eine '1' an der entsprechenden Stelle setzt das Bit des Ports als Ein-
; gang eine '0' setzt das Bit als Ausgang.
;*******************************************************************************
;*                                  Hauptprogramm                              *
;*******************************************************************************
main
         BSF T3
         BSF T2
         BSF T1
         
         BSF IA
         
         
         GOTO main
         
         
         
         
         
         
         

        
;*******************************************************************************
;*                                 Unterprogramme                              *
;*******************************************************************************



UP_wait1s
			;4999993 cycles
	movlw	0x2C
	movwf	wait
	movlw	0xE7
	movwf	wait_1
	movlw	0x0B
	movwf	wait_2
UP_wait1s_0
	decfsz	wait, f
	goto	$+2
	decfsz	wait_1, f
	goto	$+2
	decfsz	wait_2, f
	goto	UP_wait1s_0

			;3 cycles
	goto	$+1
	nop

			;4 cycles (including call)
	return
         
END
