/*
 * ShiftRegister_74HC595.cpp
 *
 * Created: 27.04.2014 10:55:07
 * Author: Stefan
 */ 

#include <stdio.h>
#include "ShiftRegister_74HC595.h"

uint8_t text[7][129];  //2D Array welches den Text enthlt

void sendClk(int anzahl, char select){
	if(select == 'z'){
		for(int i = 0; i < anzahl; i++){
			zeilenPORT = zeilenPORT |  (1<<zeilenClock);    //Ausgang auf 1
			zeilenPORT = zeilenPORT & ~(1<<zeilenClock);    //Ausgang auf 0
		}
	}else if (select == 's'){
		for(int i = 0; i < anzahl; i++){
			spaltenPORT = spaltenPORT |  (1<<spaltenClock);  //Ausgang auf 1
			spaltenPORT = spaltenPORT & ~(1<<spaltenClock);  //Ausgang auf 0
		}
	}else{
		//weder zeile noch spalte ausgewhlt -> funktion mit falschen Parametern aufgerufen
	}	
}//sendCLK


void sendRCK(char select){
	if(select == 'z'){
		zeilenPORT = zeilenPORT | (1<<zeilenRCK);	//Ausgang auf 1
		zeilenPORT = zeilenPORT & ~(1<<zeilenRCK);	//Ausgang auf 0
	}else if(select == 's'){
		spaltenPORT = spaltenPORT |  (1<<spaltenRCK);  //Ausgang auf 1
		spaltenPORT = spaltenPORT & ~(1<<spaltenRCK);  //Ausgang auf 0
	}else{
		//weder zeile noch spalte ausgewhlt -> funktion mit falschen Parametern aufgerufen
	}
}//sendRCK


void setSerIn(char select, uint8_t value){
	if(select == 'z'){
		if(value == 1)
			zeilenPORT = zeilenPORT |  (1<<zeilenSerIn);	//Ausgang auf 1
		else if(value == 0){
			zeilenPORT = zeilenPORT & ~(1<<zeilenSerIn);	//Ausgang auf 0
		}
	}else if(select == 's'){
		if(value == 1){
			spaltenPORT = spaltenPORT | (1<<spaltenSerIn);	//Ausgang auf 1
		}
		else if(value == 0){
			spaltenPORT = spaltenPORT & ~(1<<spaltenSerIn); //Ausgang auf 0
		}
	}else{
		//weder zeile noch spalte ausgewhlt -> funktion mit falschen Parametern aufgerufen
	}
	
}//setSerIn


void schiebInSpalte (uint8_t spalte[], int anzahlSpalten, int startPosition){
	
	for (int i = 0; i < anzahlSpalten; i++){
		setSerIn('s', spalte[i + startPosition]);
		sendClk(1, 's');
	}
	sendRCK('s');
}//schiebInSpalte



void setAktiveZeile(int zeile){
	
	//zunchst alle einsen Rausschieben
	setSerIn('z', 0);
	sendClk(8, 'z');
	
	//nur wenn Zeile 1 oder grer gehts weiter
	if(zeile > 0){
		setSerIn('z', 1);
		sendClk(1, 'z');
		setSerIn('z', 0);
		if (zeile > 1){
			sendClk(zeile-1, 'z');
		}
	}
	sendRCK('z');
	
}//setAktiveZeile

void TextToScroll(char textToScroll[], int length, int anzahlSchiebe){
	
	uint8_t counter = 0;  
	LedCharacter ledC;
	
	
	//das text Array mit Nullen initialisieren
	for(uint8_t z = 0; z < 7; z++){
		for (int s = 0; s < 129; s++){
			text[z][s] = 0;
		}
	}
	
	
	//FOR kopiert die Buchstaben (also 7 zeilen und 5 spalten) aus bergebenem char Array
	for(uint8_t i = 0; i < length; i++){
		ledC = getCharStruct(textToScroll[i]); //Buchstaben aus char Array holen
		
		//den eben geholten buchstaben in das groe 2d Array kopieren
		for (uint8_t z = 0; z < 7; z++){
			for(uint8_t s = 0; s < 5; s++){
				text[z][s + counter] = ledC.led[z][s];
			}
		}
		counter = counter + 6; //nchster Buchstabe soll im Array weiter hinten landen
	}
	
	
	int anzahl = 20; //anzahl multiplex Vorgnge
	int i, j;
	
	
	
	for (j = 0; j < anzahlSchiebe; j++){  //durch erhhen von j Scollt der Text, da hierdurch die Startspalte angegeben wird
		for (i = 0; i < anzahl; i++){  //mehrmals ausfhren -> Mulitplex
			ScrollText(text, j);
		}
	}
	
}//TextToScroll


void ScrollText(uint8_t text[][129], int startPosition){
	int delay = 10, i = 0;
	
	for (i = 0; i < MatrixZeilen; i++){
		//
		schiebInSpalte(text[i], 10, startPosition);
		//
		setAktiveZeile( i + 1);
		_delay_ms(delay);
		//setAktiveZeile(0);//alle spalten aus! Durch diesen Schritt Nachleuchten ausgeschalter LED deutlich weniger
	}
	
	
}