/*
 * ShiftRegister_74HC595.h
 * for 5x7 LED Matrix
 *
 * Created: 27.04.2014 10:54:31
 * Author: Stefan
 
 */ 


#ifndef SHIFTREGISTER_74HC595_H_
#define SHIFTREGISTER_74HC595_H_

#define F_CPU 2000000UL

#include <avr/io.h>
#include <util/delay.h>
#include <avr/iomx8.h>
#include "LedChar.h"

/*
* Es gibt mehrere Schieberegister fr die Spalten wobei der Ausgang Qh' des ersten Schieberegisters 
* an den Eingang zweiten Schieberegisters hngt. Vom Ausgang des zweiten gehts zum Eingang des dritten.
* Es gibt ein Schieberegister fr die Zeilen. Oberste Zeile hngt am Ausgang Qa des Schieberegisters.
* Daher die Unterscheidung fr Zeilen- und Spaltentakt usw.
*/



//define fr ZeilenSchieberegister
#define zeilenPORT			PORTB		//an diesem Port/PortPins hngt das Schieberegister fr die Zeilen
#define zeilenClock			PB1			//PortPin fr Clock des Schieberegisters fr die Zeilen (Port aus define von zeilenPort verwenden!)
#define zeilenSerIn			PB3			//an diesem Pin hngt der Serielle eingang des Zeilenschieberegisters (Port aus define von zeilenPort verwenden!)
#define zeilenRCK			PB4			//an diesem Pin hngt der RCK Eingang des Zeilenschieberegisters (Port aus define von zeilenPort verwenden!)


//define fr SpaltenSchieberegister
#define spaltenPORT			PORTC			//Port fr Clock aller Schieberegister fr die Spalten
#define spaltenClock		PC0				//PortPin fr Clock aller Schieberegister fr die Spalten (Port aus define von spaltenPort verwenden!)
#define spaltenSerIn		PC2				//an diesem Pin hngt der Serielle eingang der Spaltenschieberegister (Port aus define von spaltenPort verwenden!)
#define spaltenRCK			PC3				//an diesem Pin hngt der RCK Eingang der Spaltenschieberegister (Port aus define von spaltenPort verwenden!)


#define MatrixZeilen  7
#define MatrixSpalten 10

/*
* erzeugt die bergebene Anzahl Clock Impulse
* select zur Auswahl ob clock fr Zeilen- oder Spaltenschieberegister
*/
void sendClk(int anzahl, char select);

/*
* erzeugt einen Clock Impuls fr den RCK Eingang damit Daten an den Ausgang bernommen werden
* select gibt an ob das Signal fr die Zeilen- oder Spalten Schieberegister bestimmt ist
*/
void sendRCK(char select);


/*
* setzt den Wert fr den SerialIn des Schieberegisters auf den in Value gegebenen Wert
* select bestimmt ob Zeilen- oder Spaltenschieberegister
*/
void setSerIn(char select, uint8_t value);


/*
* schiebt die Bits in die Schieberegister rein 
* welche an den Spalten hngen
*/
void schiebInSpalte (uint8_t spalte[], int anzahlSpalten, int startPosition);


/*
* schiebt eine Eins in die Zeilenschieberegister rein
* Welche Zeile eine Eins erhlt wird bergeben. Zhlt von Zeile 1 bis Zeile 7.
* Zeile=0 deaktiviert alle Zeilen!
* So kann man geziehlt an einer Zeile der Matrix eine Eins anlegen/erzeugen
*/
void setAktiveZeile(int zeile);

/*
* holt sich ber getCharStruct die Buchstaben in Form eines 2D Arrays
* kopiert alle Buchstaben in ein groes 2D Array
* ruft dann Funktion zum Multiplexen auf
*/
void TextToScroll(char textToScroll[], int length, int anzahlSchiebe);

/*
* text enthlt den gesammten Text erster Index=Zeilen zweiter=Spalten
* zweiter index muss konstante sein bei 2D Array in C
* start gibt an ab welcher spalte der Text dargestellt wird 
* so wird scrollen mglich
* Funktion stellt das Zeichen 1mal da. Damit das Zeichen richtig dargestellt wird muss 
* diese Funktion mehrfach aufgerufen werden.
*/
void ScrollText(uint8_t text[][129], int startPosition);

#endif /* SHIFTREGISTER_74HC595_H_ */