/*
 * Decompiled with CFR 0.152.
 */
import com.jkarstedt.rfm.tool.BitSequence;
import com.jkarstedt.rfm.tool.BitSequencer;

public enum Band implements BitSequencer
{
    _433(0, 1),
    _868(1, 0),
    _915(1, 1);

    private int b1;
    private int b0;

    private Band(int b1, int b0) {
        this.b1 = b1;
        this.b0 = b0;
    }

    public boolean is433() {
        return this.b1 == 0 && this.b0 == 1;
    }

    public boolean is868() {
        return this.b1 == 1 && this.b0 == 0;
    }

    public boolean is915() {
        return this.b1 == 1 && this.b0 == 1;
    }

    @Override
    public String toBitSequence() {
        return BitSequence.toBitSequence(this.b0, this.b1);
    }

    public static Band fromInt(int band) {
        int bb1 = band >> 1;
        int bb0 = band & 1;
        if (bb1 == 1 && bb0 == 0) {
            return _868;
        }
        if (bb1 == 0 && bb0 == 1) {
            return _433;
        }
        return _915;
    }
}

