/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Rfm02Frame
extends JFrame {
    private Rfm02Model model;
    private JCheckBox ampEnabledByTransitDisableInSleep;
    private JCheckBox enabelCrystalOsc;
    private JCheckBox enableAmp;
    private JCheckBox enableLowBatDetection;
    private JCheckBox enableWakeupTimer;
    private JCheckBox disableOutputToClkPin;
    private JRadioButton radioButton868;
    private JRadioButton radioButton915;
    private JRadioButton radioButton433;
    JPanel rootPane;
    private JComboBox clkFrequencyCombo;
    private JComboBox loadCapCombo;
    private JCheckBox inversePolarity;
    private JComboBox freqDeviationCombo;
    private JCheckBox oscEnabledByTransitDisabledInSleepMode;
    private JCheckBox enableSynth;
    private JLabel operationFrequency;
    private JLabel dataRateCombo;
    private JComboBox dataRateComboBox;
    private JTextField frequency;
    private JComboBox outputPowerComboBox;
    private JCheckBox enableTXBitSync;
    private JSlider thresholdValueLowBatterySlider;
    private JTextField thresholdValueLowBatteryValue;
    private JTextField sleepCommandWithinClkStepsValue;
    private JSlider sleepCommandWithinClkStepsSlider;
    private JTextField wakeupTimeValue;
    private JSlider wakeupTimeExp;
    private JSlider wakeupTimeM;
    private JCheckBox disableWakeupTimePeriodicCalibration;
    private JPanel commandPane;
    private JPanel configurationPanel;
    private JPanel powerManagementPanel;
    private JPanel frequencySettingCommandPanel;
    private JPanel dataRateCommandPanel;
    private JPanel powerSettingCommandPanel;
    private JPanel lowBatteryCommandPanel;
    private JPanel commandPane2;
    private JPanel sleepCommandPanel;
    private JTextField configurationCommand;
    private JTextField powerManagementCommand;
    private JTextField frequencySettingCommand;
    private JTextField dataRateCommand;
    private JTextField powerSettingCommad;
    private JTextField lowBatteryCommand;
    private JTextField sleepCommand;
    private JTextField wakeupTimerCommand;
    private JCheckBox halfDataRate;
    private JTextField halfDataRateCommand;

    public Rfm02Frame() {
        this.$$$setupUI$$$();
        this.halfDataRate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        this.configurationCommand.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                if (keyEvent.getKeyChar() == '\n') {
                    Rfm02Frame.this.updateConfigurationModel();
                }
            }
        });
    }

    public void initListener() {
        this.thresholdValueLowBatterySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Rfm02Frame.this.updateThresholdValueLowBattery();
                Rfm02Frame.this.updateLowBatteryCommand();
            }
        });
        this.sleepCommandWithinClkStepsSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Rfm02Frame.this.updatesleepCommandWithinClkSteps();
                Rfm02Frame.this.updateSleepCommand();
            }
        });
        this.wakeupTimeExp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Rfm02Frame.this.updateWakeupTimer();
            }
        });
        this.wakeupTimeM.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Rfm02Frame.this.updateWakeupTimer();
            }
        });
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Rfm02Frame.this.updateConfigurationComponent();
            }
        };
        this.radioButton433.addChangeListener(listener);
        this.radioButton868.addChangeListener(listener);
        this.radioButton915.addChangeListener(listener);
        this.clkFrequencyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rfm02Frame.this.updateConfigurationComponent();
            }
        });
        this.freqDeviationCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rfm02Frame.this.updateConfigurationComponent();
            }
        });
        this.inversePolarity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Rfm02Frame.this.updateConfigurationComponent();
            }
        });
        this.loadCapCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rfm02Frame.this.updateConfigurationComponent();
            }
        });
        ChangeListener powerManagementCommandListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Rfm02Frame.this.updatePowerManagementComponent();
            }
        };
        this.oscEnabledByTransitDisabledInSleepMode.addChangeListener(powerManagementCommandListener);
        this.ampEnabledByTransitDisableInSleep.addChangeListener(powerManagementCommandListener);
        this.enabelCrystalOsc.addChangeListener(powerManagementCommandListener);
        this.enableSynth.addChangeListener(powerManagementCommandListener);
        this.enableAmp.addChangeListener(powerManagementCommandListener);
        this.enableLowBatDetection.addChangeListener(powerManagementCommandListener);
        this.enableWakeupTimer.addChangeListener(powerManagementCommandListener);
        this.disableOutputToClkPin.addChangeListener(powerManagementCommandListener);
        this.frequency.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                if (keyEvent.getKeyChar() == '\n') {
                    Rfm02Frame.this.updateFrequencySettingComponent();
                }
            }
        });
        this.frequencySettingCommand.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Rfm02Frame.this.updateFrequencyModel();
            }
        });
        this.dataRateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rfm02Frame.this.updateDataRateComponent();
            }
        });
        this.outputPowerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rfm02Frame.this.updatePowerSettingComponent();
            }
        });
        this.powerSettingCommad.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Rfm02Frame.this.updatePowerSettingModel();
            }
        });
        ChangeListener listener2 = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Rfm02Frame.this.updateLowBatteryCommand();
            }
        };
        this.disableWakeupTimePeriodicCalibration.addChangeListener(listener2);
        this.enableTXBitSync.addChangeListener(listener2);
        this.sleepCommand.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Rfm02Frame.this.updateSleepCommandModel();
            }
        });
        this.wakeupTimerCommand.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Rfm02Frame.this.updateWakeupTimerModel();
            }
        });
        this.lowBatteryCommand.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Rfm02Frame.this.updateLowBatteryModel();
            }
        });
        this.dataRateCommand.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Rfm02Frame.this.updateDataRateModel();
            }
        });
        this.powerManagementCommand.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Rfm02Frame.this.updatePowerManagementModel();
            }
        });
        this.configurationCommand.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Rfm02Frame.this.updateConfigurationModel();
            }
        });
        this.halfDataRateCommand.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Rfm02Frame.this.updateHalfDataRateModel();
            }
        });
        this.halfDataRate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Rfm02Frame.this.updateHalfDataRateCommand();
            }
        });
    }

    private void updateHalfDataRate() {
        this.model.setHalfDataRate(this.halfDataRate.isSelected());
    }

    private void updateConfigurationModel() {
        int value = Integer.parseInt(this.configurationCommand.getText(), 16) & 0x1FFF;
        int band = (value & 0x1800) >> 11;
        this.model.setBand(Band.fromInt(band));
        this.updateBandButtons(Band.fromInt(band));
        int freqClk = (value & 0x700) >> 8;
        this.model.setClkFrequency(ClkFrequency.fromInt(freqClk));
        this.clkFrequencyCombo.setSelectedItem(ClkFrequency.fromInt(freqClk));
        int loadCap = (value & 0xF0) >> 4;
        this.model.setCrystalLoadCap(CrystalLoadCap.fromInt(loadCap));
        this.loadCapCombo.setSelectedItem(CrystalLoadCap.fromInt(loadCap));
        this.model.setInversePolarity((value & 8) > 0);
        this.inversePolarity.setSelected((value & 8) > 0);
        int freqDev = value & 7;
        this.model.setFrequencyDeviation(FrequencyDeviation.fromInt(freqDev));
        this.freqDeviationCombo.setSelectedItem((Object)FrequencyDeviation.fromInt(freqDev));
    }

    private void updatePowerManagementModel() {
        int value = Integer.parseInt(this.powerManagementCommand.getText(), 16) & 0xFF;
        this.model.setOscEnabledByTransitDisabledInSleepMode((value & 0x80) != 0);
        this.oscEnabledByTransitDisabledInSleepMode.setSelected((value & 0x80) != 0);
        this.model.setAmpEnabledByTransitDisableInSleep((value & 0x40) != 0);
        this.ampEnabledByTransitDisableInSleep.setSelected((value & 0x40) != 0);
        this.model.setEnableCrystalOsc((value & 0x20) != 0);
        this.enabelCrystalOsc.setSelected((value & 0x20) != 0);
        this.model.setEnableSynth((value & 0x10) != 0);
        this.enableSynth.setSelected((value & 0x10) != 0);
        this.model.setEnableAmp((value & 8) != 0);
        this.enableAmp.setSelected((value & 8) != 0);
        this.model.setEnableLowBatDetection((value & 4) != 0);
        this.enableLowBatDetection.setSelected((value & 4) != 0);
        this.model.setEnableWakeupTimer((value & 2) != 0);
        this.enableWakeupTimer.setSelected((value & 2) != 0);
        this.model.setDisableOutputToClkPin((value & 1) != 0);
        this.disableOutputToClkPin.setSelected((value & 1) != 0);
    }

    private void updateDataRateModel() {
        int value = Integer.parseInt(this.dataRateCommand.getText(), 16) & 0xFF;
        this.model.setDataRate(DataRate.values()[value]);
        this.dataRateComboBox.setSelectedItem(DataRate.values()[value]);
    }

    private void updateLowBatteryModel() {
        int value = Integer.parseInt(this.lowBatteryCommand.getText(), 16) & 0xFF;
        this.model.setThresholdValueLowBatteryValue(value & 0x1F);
        this.thresholdValueLowBatterySlider.setValue(value & 0x1F);
        this.model.setEnableTXBitSync((value & 0x20) > 0);
        this.enableTXBitSync.setSelected((value & 0x20) > 0);
        this.model.setDisableWakeUpTimerPeriodicCalibration((value & 0x80) > 0);
        this.disableWakeupTimePeriodicCalibration.setSelected((value & 0x80) > 0);
    }

    private void updateSleepCommandModel() {
        int value = Integer.parseInt(this.sleepCommand.getText(), 16) & 0xFF;
        this.model.setSleepCommandWithinCLKs(value);
        this.sleepCommandWithinClkStepsSlider.setValue(value);
    }

    private void updateWakeupTimerModel() {
        int value = Integer.parseInt(this.wakeupTimerCommand.getText(), 16) & 0x1FFF;
        int mantisse = value & 0xFF;
        int exp = (value & 0x1F00) >> 8;
        this.model.setWakeUpTimerPeriodeMsValue(exp, mantisse);
        this.wakeupTimeExp.setValue(exp);
        this.wakeupTimeM.setValue(mantisse);
    }

    private void updatePowerSettingModel() {
        int value = Integer.parseInt(this.powerSettingCommad.getText(), 16) & 7;
        this.model.setOutputPower(OutputPower.fromInt(value));
        this.outputPowerComboBox.setSelectedItem((Object)OutputPower.fromInt(value));
    }

    private void updateHalfDataRateModel() {
        int value = Integer.parseInt(this.powerSettingCommad.getText(), 16) & 0x40;
        this.model.setHalfDataRate(value != 0);
        this.halfDataRate.setSelected(value != 0);
    }

    private void updateFrequencyModel() {
        int value = Integer.parseInt(this.frequencySettingCommand.getText(), 16) & 0xFFF;
        this.model.setFrequency(value);
        this.frequency.setText(String.valueOf(this.model.getCalculateFrequency()));
    }

    private void updateWakeupTimer() {
        this.wakeupTimeValue.setText(new BigDecimal((double)this.wakeupTimeM.getValue() * Math.pow(2.0, this.wakeupTimeExp.getValue())).toString());
        this.updateWakeupTimerCommand();
    }

    private void updatesleepCommandWithinClkSteps() {
        this.sleepCommandWithinClkStepsValue.setText(new Integer(this.sleepCommandWithinClkStepsSlider.getValue()).toString());
    }

    private void updateThresholdValueLowBattery() {
        this.thresholdValueLowBatteryValue.setText(new Double((double)Math.round(2.2 + (double)this.thresholdValueLowBatterySlider.getValue() * 0.1 * 10.0) / 10.0).toString() + " V");
    }

    public void setData(Rfm02Model model) {
        this.model = model;
        Band band = model.getBand();
        this.updateBandButtons(band);
        this.clkFrequencyCombo.setModel(model.getClkFrequency().asComboModel());
        this.clkFrequencyCombo.setSelectedItem(model.getClkFrequency());
        this.loadCapCombo.setModel(model.getCrystalLoadCap().asComboModel());
        this.loadCapCombo.setSelectedItem(model.getCrystalLoadCap());
        this.inversePolarity.setSelected(model.getInversePolarity());
        this.freqDeviationCombo.setModel(model.getFrequencyDeviation().asComboModel());
        this.freqDeviationCombo.setSelectedItem((Object)model.getFrequencyDeviation());
        this.oscEnabledByTransitDisabledInSleepMode.setSelected(model.getOscEnabledByTransitDisabledInSleepMode());
        this.ampEnabledByTransitDisableInSleep.setSelected(model.getAmpEnabledByTransitDisableInSleep());
        this.enabelCrystalOsc.setSelected(model.getEnableCrystalOsc());
        this.enableSynth.setSelected(model.getEnableSynth());
        this.enableAmp.setSelected(model.getEnableAmp());
        this.enableLowBatDetection.setSelected(model.getEnableLowBatDetection());
        this.enableWakeupTimer.setSelected(model.getEnableWakeupTimer());
        this.disableOutputToClkPin.setSelected(model.getDisableOutputToClkPin());
        this.dataRateComboBox.setModel(model.getDataRate().asComboModel());
        this.dataRateComboBox.setSelectedItem(model.getDataRate());
        this.frequency.setText(String.valueOf(model.getCalculateFrequency()));
        this.outputPowerComboBox.setModel(model.getOutputPower().asComboModel());
        this.outputPowerComboBox.setSelectedItem((Object)model.getOutputPower());
        this.disableWakeupTimePeriodicCalibration.setSelected(model.getDisableWakeUpTimerPeriodicCalibration());
        this.enableTXBitSync.setSelected(model.getEnableTXBitSync());
        this.thresholdValueLowBatterySlider.setValue((int)model.getThresholdValueLowBattery());
        this.updateThresholdValueLowBattery();
        this.updatesleepCommandWithinClkSteps();
        this.wakeupTimeExp.setValue((int)model.getWakeUpTimerPeriodeMsExp());
        this.wakeupTimeM.setValue((int)model.getWakeUpTimerPeriodeMsMantisse());
        this.updateWakeupTimer();
        this.halfDataRate.setSelected(model.getHalfDataRate());
        this.pack();
    }

    private void updateBandButtons(Band band) {
        if (band.is433()) {
            this.radioButton433.setSelected(true);
            this.radioButton868.setSelected(false);
            this.radioButton915.setSelected(false);
        }
        if (band.is868()) {
            this.radioButton433.setSelected(false);
            this.radioButton868.setSelected(true);
            this.radioButton915.setSelected(false);
        }
        if (band.is915()) {
            this.radioButton433.setSelected(false);
            this.radioButton868.setSelected(false);
            this.radioButton915.setSelected(true);
        }
    }

    public Rfm02Model getData() {
        this.rewriteModel();
        return this.model;
    }

    public void rewriteModel() {
        if (this.radioButton433.isSelected()) {
            this.model.setBand(Band._433);
        }
        if (this.radioButton868.isSelected()) {
            this.model.setBand(Band._868);
        }
        if (this.radioButton915.isSelected()) {
            this.model.setBand(Band._915);
        }
        this.model.setClkFrequency((ClkFrequency)this.clkFrequencyCombo.getSelectedItem());
        this.model.setCrystalLoadCap((CrystalLoadCap)this.loadCapCombo.getSelectedItem());
        this.model.setInversePolarity(this.inversePolarity.isSelected());
        this.model.setFrequencyDeviation((FrequencyDeviation)((Object)this.freqDeviationCombo.getSelectedItem()));
        this.model.setOscEnabledByTransitDisabledInSleepMode(this.oscEnabledByTransitDisabledInSleepMode.isSelected());
        this.model.setAmpEnabledByTransitDisableInSleep(this.ampEnabledByTransitDisableInSleep.isSelected());
        this.model.setEnableCrystalOsc(this.enabelCrystalOsc.isSelected());
        this.model.setEnableSynth(this.enableSynth.isSelected());
        this.model.setEnableAmp(this.enableAmp.isSelected());
        this.model.setEnableLowBatDetection(this.enableLowBatDetection.isSelected());
        this.model.setEnableWakeupTimer(this.enableWakeupTimer.isSelected());
        this.model.setDisableOutputToClkPin(this.disableOutputToClkPin.isSelected());
        try {
            this.model.setCalculatedFrequency(Double.parseDouble(this.frequency.getText()));
            this.frequency.setBackground(Color.WHITE);
        }
        catch (Exception e) {
            this.frequency.setBackground(Color.RED);
        }
        this.frequency.setText(new Double(this.model.getCalculateFrequency()).toString());
        this.model.setDataRate((DataRate)this.dataRateComboBox.getSelectedItem());
        this.model.setOutputPower((OutputPower)((Object)this.outputPowerComboBox.getSelectedItem()));
        this.model.setDisableWakeUpTimerPeriodicCalibration(this.disableWakeupTimePeriodicCalibration.isSelected());
        this.model.setEnableTXBitSync(this.enableTXBitSync.isSelected());
        this.model.setThresholdValueLowBatteryValue(this.thresholdValueLowBatterySlider.getValue());
        this.model.setSleepCommandWithinCLKs(this.sleepCommandWithinClkStepsSlider.getValue());
        this.model.setWakeUpTimerPeriodeMsValue(this.wakeupTimeExp.getValue(), this.wakeupTimeM.getValue());
        this.model.setHalfDataRate(this.halfDataRate.isSelected());
    }

    private void updateConfigurationComponent() {
        this.rewriteModel();
        this.configurationCommand.setText(this.model.calculateConfigurationSettingCommand());
    }

    private void updatePowerManagementComponent() {
        this.rewriteModel();
        this.powerManagementCommand.setText(this.model.calculatePowerManagementCommand());
    }

    private void updateFrequencySettingComponent() {
        this.rewriteModel();
        this.frequencySettingCommand.setText(this.model.calculateFrequencySettingCommand());
    }

    private void updateDataRateComponent() {
        this.rewriteModel();
        this.dataRateCommand.setText(this.model.calculateUpdateDataRateCommand());
    }

    private void updatePowerSettingComponent() {
        this.rewriteModel();
        this.powerSettingCommad.setText(this.model.calculatePowerSettingCommand());
    }

    private void updateLowBatteryCommand() {
        this.rewriteModel();
        this.lowBatteryCommand.setText(this.model.calculateLowBatteryCommand());
    }

    private void updateSleepCommand() {
        this.rewriteModel();
        this.sleepCommand.setText(this.model.calculateSleepCommand());
    }

    private void updateWakeupTimerCommand() {
        this.rewriteModel();
        this.wakeupTimerCommand.setText(this.model.calculateWakeupTimerComand());
    }

    public void syncCommandValues() {
        this.updateConfigurationComponent();
        this.updatePowerManagementComponent();
        this.updateFrequencySettingComponent();
        this.updateDataRateComponent();
        this.updatePowerSettingComponent();
        this.updateLowBatteryCommand();
        this.updateSleepCommand();
        this.updateWakeupTimerCommand();
        this.updateHalfDataRateCommand();
    }

    private void updateHalfDataRateCommand() {
        this.rewriteModel();
        this.halfDataRateCommand.setText(this.model.calculateHalfDataRateComand());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JTextField jTextField4;
        JTextField jTextField5;
        JPanel jPanel2;
        JTextField jTextField6;
        JPanel jPanel3;
        JTextField jTextField7;
        JPanel jPanel4;
        JPanel jPanel5;
        JTextField jTextField8;
        JPanel jPanel6;
        JTextField jTextField9;
        JPanel jPanel7;
        JTextField jTextField10;
        JPanel jPanel8;
        JPanel jPanel9;
        JSlider jSlider;
        JSlider jSlider2;
        JTextField jTextField11;
        JTextField jTextField12;
        JSlider jSlider3;
        JTextField jTextField13;
        JSlider jSlider4;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JLabel jLabel;
        JLabel jLabel2;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JCheckBox jCheckBox12;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JComboBox jComboBox5;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel10;
        this.rootPane = jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(26, 4, new Insets(0, 10, 0, 0), 0, -1, false, false));
        jPanel10.setMinimumSize(new Dimension(900, 892));
        jPanel10.setOpaque(false);
        jPanel10.setPreferredSize(new Dimension(1000, 892));
        jPanel10.setMaximumSize(new Dimension(900, Integer.MAX_VALUE));
        jPanel10.putClientProperty("html.disable", Boolean.TRUE);
        jPanel10.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(2);
        jLabel3.setText("band select [MHz]");
        jPanel10.add((Component)jLabel3, new GridConstraints(0, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(0, 3, 1, 1, 8, 2, 0, 1, null, null, null));
        this.radioButton433 = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("433");
        jPanel11.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.radioButton868 = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("868");
        jPanel11.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.radioButton915 = jRadioButton = new JRadioButton();
        jRadioButton.setText("915");
        jPanel11.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(2);
        jLabel4.setText("freq. CLK PIN [MHz]");
        jPanel10.add((Component)jLabel4, new GridConstraints(1, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.clkFrequencyCombo = jComboBox5 = new JComboBox();
        jPanel10.add(jComboBox5, new GridConstraints(1, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 27), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setHorizontalAlignment(2);
        jLabel5.setText("Crystal load cap. [pF]");
        jPanel10.add((Component)jLabel5, new GridConstraints(2, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.loadCapCombo = jComboBox4 = new JComboBox();
        jPanel10.add(jComboBox4, new GridConstraints(2, 3, 1, 1, 8, 0, 0, 1, null, new Dimension(-1, 27), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setHorizontalAlignment(2);
        jLabel6.setText("freq. deviation [kHz]");
        jPanel10.add((Component)jLabel6, new GridConstraints(4, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.freqDeviationCombo = jComboBox3 = new JComboBox();
        jPanel10.add(jComboBox3, new GridConstraints(4, 3, 1, 1, 8, 0, 0, 1, null, new Dimension(-1, 27), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setHorizontalAlignment(2);
        jLabel7.setText("modulation polarity");
        jPanel10.add((Component)jLabel7, new GridConstraints(3, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.inversePolarity = jCheckBox12 = new JCheckBox();
        jCheckBox12.setText("inverse");
        jPanel10.add((Component)jCheckBox12, new GridConstraints(3, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 23), null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setHorizontalAlignment(2);
        ((Component)jLabel8).setEnabled(true);
        jLabel8.setText("osc. and synth. enabled by transmit command disable in sleepm.");
        jLabel8.setVerticalAlignment(1);
        jPanel10.add((Component)jLabel8, new GridConstraints(5, 0, 1, 3, 8, 0, 1, 0, null, new Dimension(-1, 20), null));
        this.oscEnabledByTransitDisabledInSleepMode = jCheckBox11 = new JCheckBox();
        jCheckBox11.setText("");
        jPanel10.add((Component)jCheckBox11, new GridConstraints(5, 3, 1, 1, 8, 0, 3, 1, null, new Dimension(-1, 23), null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setHorizontalAlignment(2);
        jLabel9.setText("enable amp. by transmit command disable in sleepmode");
        jPanel10.add((Component)jLabel9, new GridConstraints(6, 0, 1, 3, 8, 0, 1, 0, null, new Dimension(-1, 20), null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setHorizontalAlignment(2);
        jLabel10.setText("enable crystal osc.");
        jPanel10.add((Component)jLabel10, new GridConstraints(7, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setHorizontalAlignment(2);
        jLabel11.setText("enable synth.");
        jPanel10.add((Component)jLabel11, new GridConstraints(8, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setHorizontalAlignment(2);
        jLabel12.setText("enable amp.");
        jPanel10.add((Component)jLabel12, new GridConstraints(9, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.ampEnabledByTransitDisableInSleep = jCheckBox10 = new JCheckBox();
        jCheckBox10.setText("");
        jPanel10.add((Component)jCheckBox10, new GridConstraints(6, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 23), null));
        this.enabelCrystalOsc = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("");
        jPanel10.add((Component)jCheckBox9, new GridConstraints(7, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 23), null));
        this.enableSynth = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("");
        jPanel10.add((Component)jCheckBox8, new GridConstraints(8, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 23), null));
        this.enableAmp = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("");
        jPanel10.add((Component)jCheckBox7, new GridConstraints(9, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 23), null));
        JLabel jLabel13 = new JLabel();
        jLabel13.setHorizontalAlignment(2);
        jLabel13.setText("enable low battery detection");
        jPanel10.add((Component)jLabel13, new GridConstraints(10, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        JLabel jLabel14 = new JLabel();
        jLabel14.setHorizontalAlignment(2);
        jLabel14.setText("enable wakeup timer");
        jPanel10.add((Component)jLabel14, new GridConstraints(11, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        JLabel jLabel15 = new JLabel();
        jLabel15.setHorizontalAlignment(2);
        jLabel15.setText("disable output to CLK pin");
        jPanel10.add((Component)jLabel15, new GridConstraints(12, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.enableLowBatDetection = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("");
        jPanel10.add((Component)jCheckBox6, new GridConstraints(10, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 23), null));
        this.enableWakeupTimer = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("");
        jPanel10.add((Component)jCheckBox5, new GridConstraints(11, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 23), null));
        this.disableOutputToClkPin = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("");
        jPanel10.add((Component)jCheckBox4, new GridConstraints(12, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 23), null));
        this.operationFrequency = jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(2);
        jLabel2.setText("operation frequency [ Mhz]");
        jPanel10.add((Component)jLabel2, new GridConstraints(13, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.dataRateCombo = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(2);
        jLabel.setText("data rate [bps]");
        jPanel10.add((Component)jLabel, new GridConstraints(14, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.dataRateComboBox = jComboBox2 = new JComboBox();
        jPanel10.add(jComboBox2, new GridConstraints(14, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 27), null));
        JLabel jLabel16 = new JLabel();
        jLabel16.setHorizontalAlignment(2);
        jLabel16.setText("output power  [dBm]");
        jPanel10.add((Component)jLabel16, new GridConstraints(16, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.outputPowerComboBox = jComboBox = new JComboBox();
        jPanel10.add(jComboBox, new GridConstraints(16, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 27), null));
        JLabel jLabel17 = new JLabel();
        jLabel17.setHorizontalAlignment(2);
        jLabel17.setText("disable wake-up timer periodical calibration");
        jPanel10.add((Component)jLabel17, new GridConstraints(17, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.disableWakeupTimePeriodicCalibration = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("");
        jPanel10.add((Component)jCheckBox3, new GridConstraints(17, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 23), null));
        JLabel jLabel18 = new JLabel();
        jLabel18.setHorizontalAlignment(2);
        jLabel18.setText("enable TX bit sync function");
        jPanel10.add((Component)jLabel18, new GridConstraints(18, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.enableTXBitSync = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("");
        jPanel10.add((Component)jCheckBox2, new GridConstraints(18, 3, 1, 1, 8, 0, 1, 0, null, new Dimension(-1, 23), null));
        JLabel jLabel19 = new JLabel();
        jLabel19.setHorizontalAlignment(2);
        jLabel19.setText("threshold voltage of Low battery detector [V]");
        jPanel10.add((Component)jLabel19, new GridConstraints(19, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridBagLayout());
        jPanel10.add((Component)jPanel12, new GridConstraints(19, 3, 1, 1, 8, 2, 2, 5, null, new Dimension(-1, 30), null));
        JPanel jPanel13 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel12.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 2;
        jPanel12.add((Component)jPanel14, gridBagConstraints2);
        this.thresholdValueLowBatterySlider = jSlider4 = new JSlider();
        jSlider4.setPaintLabels(true);
        jSlider4.setMaximum(31);
        jSlider4.setValue(0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        jPanel12.add((Component)jSlider4, gridBagConstraints3);
        this.thresholdValueLowBatteryValue = jTextField13 = new JTextField();
        jTextField13.setEditable(false);
        jTextField13.setColumns(3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.anchor = 17;
        jPanel12.add((Component)jTextField13, gridBagConstraints4);
        JLabel jLabel20 = new JLabel();
        jLabel20.setHorizontalAlignment(2);
        jLabel20.setText("sleep command within x CLK steps");
        jPanel10.add((Component)jLabel20, new GridConstraints(20, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new GridBagLayout());
        jPanel10.add((Component)jPanel15, new GridConstraints(20, 3, 1, 1, 8, 2, 6, 1, null, new Dimension(-1, 44), new Dimension(300, -1)));
        JPanel jPanel16 = new JPanel();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 3;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.fill = 2;
        jPanel15.add((Component)jPanel16, gridBagConstraints5);
        JPanel jPanel17 = new JPanel();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.anchor = 11;
        gridBagConstraints6.fill = 2;
        jPanel15.add((Component)jPanel17, gridBagConstraints6);
        this.sleepCommandWithinClkStepsSlider = jSlider3 = new JSlider();
        jSlider3.setPaintLabels(true);
        jSlider3.setMaximum(255);
        jSlider3.setValue(0);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 2;
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.fill = 2;
        jPanel15.add((Component)jSlider3, gridBagConstraints7);
        this.sleepCommandWithinClkStepsValue = jTextField12 = new JTextField();
        jTextField12.setEditable(false);
        jTextField12.setColumns(3);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 0;
        gridBagConstraints8.anchor = 17;
        jPanel15.add((Component)jTextField12, gridBagConstraints8);
        JLabel jLabel21 = new JLabel();
        jLabel21.setHorizontalAlignment(2);
        jLabel21.setText("wake-up Timer [ms]");
        jPanel10.add((Component)jLabel21, new GridConstraints(21, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel18, new GridConstraints(21, 3, 1, 1, 8, 2, 7, 1, null, new Dimension(-1, 34), null));
        this.wakeupTimeValue = jTextField11 = new JTextField();
        jTextField11.setEditable(false);
        jTextField11.setColumns(4);
        jPanel18.add((Component)jTextField11, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, new Dimension(130, 20), new Dimension(130, 20)));
        this.wakeupTimeExp = jSlider2 = new JSlider();
        jSlider2.setPaintLabels(true);
        jSlider2.setMaximum(31);
        jSlider2.setValue(0);
        jPanel18.add((Component)jSlider2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(100, -1), new Dimension(100, -1)));
        this.wakeupTimeM = jSlider = new JSlider();
        jSlider.setPaintLabels(true);
        jSlider.setMaximum(255);
        jSlider.setValue(0);
        jPanel18.add((Component)jSlider, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, new Dimension(100, -1), new Dimension(100, -1)));
        this.commandPane = jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(1, 5, 5));
        jPanel10.add((Component)jPanel9, new GridConstraints(23, 0, 1, 4, 9, 0, 1, 7, null, null, null));
        this.configurationPanel = jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        Component component = jPanel9.add(jPanel8);
        JLabel jLabel22 = new JLabel();
        jLabel22.setText("Configuration Command");
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 0;
        gridBagConstraints9.anchor = 17;
        jPanel8.add((Component)jLabel22, gridBagConstraints9);
        JPanel jPanel19 = new JPanel();
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.gridy = 0;
        gridBagConstraints10.fill = 2;
        jPanel8.add((Component)jPanel19, gridBagConstraints10);
        JPanel jPanel20 = new JPanel();
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 2;
        gridBagConstraints11.fill = 3;
        jPanel8.add((Component)jPanel20, gridBagConstraints11);
        this.configurationCommand = jTextField10 = new JTextField();
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 1;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.fill = 2;
        jPanel8.add((Component)jTextField10, gridBagConstraints12);
        this.powerManagementPanel = jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        Component component2 = jPanel9.add(jPanel7);
        JLabel jLabel23 = new JLabel();
        jLabel23.setText("Power Management Command");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 0;
        gridBagConstraints13.anchor = 17;
        jPanel7.add((Component)jLabel23, gridBagConstraints13);
        JPanel jPanel21 = new JPanel();
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 1;
        gridBagConstraints14.gridy = 0;
        gridBagConstraints14.fill = 2;
        jPanel7.add((Component)jPanel21, gridBagConstraints14);
        JPanel jPanel22 = new JPanel();
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = 0;
        gridBagConstraints15.gridy = 2;
        gridBagConstraints15.fill = 3;
        jPanel7.add((Component)jPanel22, gridBagConstraints15);
        this.powerManagementCommand = jTextField9 = new JTextField();
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.gridx = 0;
        gridBagConstraints16.gridy = 1;
        gridBagConstraints16.anchor = 17;
        gridBagConstraints16.fill = 2;
        jPanel7.add((Component)jTextField9, gridBagConstraints16);
        this.frequencySettingCommandPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        Component component3 = jPanel9.add(jPanel6);
        JLabel jLabel24 = new JLabel();
        jLabel24.setText("Frequency Setting Command");
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.gridx = 0;
        gridBagConstraints17.gridy = 0;
        gridBagConstraints17.anchor = 17;
        jPanel6.add((Component)jLabel24, gridBagConstraints17);
        JPanel jPanel23 = new JPanel();
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.gridx = 1;
        gridBagConstraints18.gridy = 0;
        gridBagConstraints18.fill = 2;
        jPanel6.add((Component)jPanel23, gridBagConstraints18);
        JPanel jPanel24 = new JPanel();
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.gridx = 0;
        gridBagConstraints19.gridy = 2;
        gridBagConstraints19.fill = 3;
        jPanel6.add((Component)jPanel24, gridBagConstraints19);
        this.frequencySettingCommand = jTextField8 = new JTextField();
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.gridx = 0;
        gridBagConstraints20.gridy = 1;
        gridBagConstraints20.anchor = 17;
        gridBagConstraints20.fill = 2;
        jPanel6.add((Component)jTextField8, gridBagConstraints20);
        this.commandPane2 = jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1, 5, 5));
        jPanel10.add((Component)jPanel5, new GridConstraints(24, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(441, 68), null));
        this.dataRateCommandPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        Component component4 = jPanel5.add(jPanel4);
        JLabel jLabel25 = new JLabel();
        jLabel25.setText("Data Rate Command");
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.gridy = 0;
        gridBagConstraints21.anchor = 17;
        jPanel4.add((Component)jLabel25, gridBagConstraints21);
        JPanel jPanel25 = new JPanel();
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.gridx = 1;
        gridBagConstraints22.gridy = 0;
        gridBagConstraints22.fill = 2;
        jPanel4.add((Component)jPanel25, gridBagConstraints22);
        JPanel jPanel26 = new JPanel();
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.gridx = 0;
        gridBagConstraints23.gridy = 2;
        gridBagConstraints23.fill = 3;
        jPanel4.add((Component)jPanel26, gridBagConstraints23);
        this.dataRateCommand = jTextField7 = new JTextField();
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.gridx = 0;
        gridBagConstraints24.gridy = 1;
        gridBagConstraints24.anchor = 17;
        gridBagConstraints24.fill = 2;
        jPanel4.add((Component)jTextField7, gridBagConstraints24);
        this.powerSettingCommandPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        Component component5 = jPanel5.add(jPanel3);
        JLabel jLabel26 = new JLabel();
        jLabel26.setText("Power Setting Command");
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.gridx = 0;
        gridBagConstraints25.gridy = 0;
        gridBagConstraints25.anchor = 17;
        jPanel3.add((Component)jLabel26, gridBagConstraints25);
        JPanel jPanel27 = new JPanel();
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.gridx = 1;
        gridBagConstraints26.gridy = 0;
        gridBagConstraints26.fill = 2;
        jPanel3.add((Component)jPanel27, gridBagConstraints26);
        JPanel jPanel28 = new JPanel();
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.gridx = 0;
        gridBagConstraints27.gridy = 2;
        gridBagConstraints27.fill = 3;
        jPanel3.add((Component)jPanel28, gridBagConstraints27);
        this.powerSettingCommad = jTextField6 = new JTextField();
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.gridx = 0;
        gridBagConstraints28.gridy = 1;
        gridBagConstraints28.anchor = 17;
        gridBagConstraints28.fill = 2;
        jPanel3.add((Component)jTextField6, gridBagConstraints28);
        Spacer spacer = new Spacer();
        Component component6 = jPanel5.add(spacer);
        Spacer spacer2 = new Spacer();
        Component component7 = jPanel5.add(spacer2);
        this.lowBatteryCommandPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        Component component8 = jPanel5.add(jPanel2);
        JLabel jLabel27 = new JLabel();
        jLabel27.setText("Low Battery Command");
        GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
        gridBagConstraints29.gridx = 0;
        gridBagConstraints29.gridy = 0;
        gridBagConstraints29.anchor = 17;
        jPanel2.add((Component)jLabel27, gridBagConstraints29);
        JPanel jPanel29 = new JPanel();
        GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
        gridBagConstraints30.gridx = 1;
        gridBagConstraints30.gridy = 0;
        gridBagConstraints30.fill = 2;
        jPanel2.add((Component)jPanel29, gridBagConstraints30);
        JPanel jPanel30 = new JPanel();
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 0;
        gridBagConstraints31.gridy = 2;
        gridBagConstraints31.fill = 3;
        jPanel2.add((Component)jPanel30, gridBagConstraints31);
        this.lowBatteryCommand = jTextField5 = new JTextField();
        GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
        gridBagConstraints32.gridx = 0;
        gridBagConstraints32.gridy = 1;
        gridBagConstraints32.anchor = 17;
        gridBagConstraints32.fill = 2;
        jPanel2.add((Component)jTextField5, gridBagConstraints32);
        this.frequency = jTextField4 = new JTextField();
        jTextField4.setText("");
        jTextField4.setColumns(1);
        jPanel10.add((Component)jTextField4, new GridConstraints(13, 3, 1, 1, 8, 2, 0, 1, null, new Dimension(150, 17), new Dimension(-1, 17)));
        JLabel jLabel28 = new JLabel();
        jLabel28.setText("half data rate");
        jPanel10.add((Component)jLabel28, new GridConstraints(15, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.halfDataRate = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel10.add((Component)jCheckBox, new GridConstraints(15, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel31 = new JPanel();
        jPanel31.setLayout(new FlowLayout(1, 5, 5));
        jPanel10.add((Component)jPanel31, new GridConstraints(25, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.sleepCommandPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Component component9 = jPanel31.add(jPanel);
        JLabel jLabel29 = new JLabel();
        jLabel29.setText("Sleep Command");
        GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
        gridBagConstraints33.gridx = 0;
        gridBagConstraints33.gridy = 0;
        gridBagConstraints33.anchor = 17;
        jPanel.add((Component)jLabel29, gridBagConstraints33);
        JPanel jPanel32 = new JPanel();
        GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
        gridBagConstraints34.gridx = 1;
        gridBagConstraints34.gridy = 0;
        gridBagConstraints34.fill = 2;
        jPanel.add((Component)jPanel32, gridBagConstraints34);
        JPanel jPanel33 = new JPanel();
        GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
        gridBagConstraints35.gridx = 0;
        gridBagConstraints35.gridy = 2;
        gridBagConstraints35.fill = 3;
        jPanel.add((Component)jPanel33, gridBagConstraints35);
        this.sleepCommand = jTextField3 = new JTextField();
        GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
        gridBagConstraints36.gridx = 0;
        gridBagConstraints36.gridy = 1;
        gridBagConstraints36.anchor = 17;
        gridBagConstraints36.fill = 2;
        jPanel.add((Component)jTextField3, gridBagConstraints36);
        JPanel jPanel34 = new JPanel();
        jPanel34.setLayout(new GridBagLayout());
        Component component10 = jPanel31.add(jPanel34);
        JPanel jPanel35 = new JPanel();
        GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
        gridBagConstraints37.gridx = 1;
        gridBagConstraints37.gridy = 0;
        gridBagConstraints37.fill = 2;
        jPanel34.add((Component)jPanel35, gridBagConstraints37);
        JPanel jPanel36 = new JPanel();
        GridBagConstraints gridBagConstraints38 = new GridBagConstraints();
        gridBagConstraints38.gridx = 0;
        gridBagConstraints38.gridy = 2;
        gridBagConstraints38.fill = 3;
        jPanel34.add((Component)jPanel36, gridBagConstraints38);
        this.wakeupTimerCommand = jTextField2 = new JTextField();
        GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
        gridBagConstraints39.gridx = 0;
        gridBagConstraints39.gridy = 1;
        gridBagConstraints39.anchor = 17;
        gridBagConstraints39.fill = 2;
        jPanel34.add((Component)jTextField2, gridBagConstraints39);
        JLabel jLabel30 = new JLabel();
        jLabel30.setText("Wakeup Timer Command");
        GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
        gridBagConstraints40.gridx = 0;
        gridBagConstraints40.gridy = 0;
        gridBagConstraints40.anchor = 17;
        jPanel34.add((Component)jLabel30, gridBagConstraints40);
        JPanel jPanel37 = new JPanel();
        jPanel37.setLayout(new GridBagLayout());
        Component component11 = jPanel31.add(jPanel37);
        JPanel jPanel38 = new JPanel();
        GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
        gridBagConstraints41.gridx = 1;
        gridBagConstraints41.gridy = 0;
        gridBagConstraints41.fill = 2;
        jPanel37.add((Component)jPanel38, gridBagConstraints41);
        JPanel jPanel39 = new JPanel();
        GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
        gridBagConstraints42.gridx = 0;
        gridBagConstraints42.gridy = 2;
        gridBagConstraints42.fill = 3;
        jPanel37.add((Component)jPanel39, gridBagConstraints42);
        this.halfDataRateCommand = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints43 = new GridBagConstraints();
        gridBagConstraints43.gridx = 0;
        gridBagConstraints43.gridy = 1;
        gridBagConstraints43.anchor = 17;
        gridBagConstraints43.fill = 2;
        jPanel37.add((Component)jTextField, gridBagConstraints43);
        JLabel jLabel31 = new JLabel();
        jLabel31.setText("Half Datarate Command");
        GridBagConstraints gridBagConstraints44 = new GridBagConstraints();
        gridBagConstraints44.gridx = 0;
        gridBagConstraints44.gridy = 0;
        gridBagConstraints44.anchor = 17;
        jPanel37.add((Component)jLabel31, gridBagConstraints44);
        jLabel4.setLabelFor(jComboBox5);
        jLabel5.setLabelFor(jComboBox4);
        jLabel6.setLabelFor(jComboBox3);
        jLabel.setLabelFor(jComboBox2);
        jLabel16.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPane;
    }
}

