/*
 * Decompiled with CFR 0.152.
 */
import com.jkarstedt.rfm.tool.BitSequence;

public class Rfm02Model {
    private Band band;
    private ClkFrequency clkFrequency;
    private CrystalLoadCap crystalLoadCap;
    private boolean inversePolarity;
    private FrequencyDeviation frequencyDeviation;
    private boolean oscEnabledByTransitDisabledInSleepMode;
    private boolean enableCrystalOsc;
    private boolean enableSynth;
    private boolean enableAmp;
    private boolean enableLowBatDetection;
    private boolean enableWakeupTimer;
    private boolean disableOutputToClkPin;
    private DataRate dataRate;
    int frequency;
    private OutputPower outputPower;
    private AdjustableBitValue thresholdValueLowBattery = new AdjustableBitValue(5, 0L);
    private AdjustableBitValue sleepCommandWithinCLKs = new AdjustableBitValue(8, 0L);
    private ExponentialBitConfig wakeUpTimerPeriodeMs = new ExponentialBitConfig(5, 0, 8, 0);
    private boolean disableWakeUpTimerPeriodicCalibration;
    private boolean enableTXBitSync;
    private boolean halfDataRate;
    private boolean ampEnabledByTransitDisableInSleep;

    public void setAmpEnabledByTransitDisableInSleep(boolean ampEnabledByTransitDisableInSleep) {
        this.ampEnabledByTransitDisableInSleep = ampEnabledByTransitDisableInSleep;
    }

    public Band getBand() {
        return this.band;
    }

    public void setBand(Band band) {
        this.band = band;
    }

    public void setClkFrequency(ClkFrequency clkFrequency) {
        this.clkFrequency = clkFrequency;
    }

    public ClkFrequency getClkFrequency() {
        return this.clkFrequency;
    }

    public CrystalLoadCap getCrystalLoadCap() {
        return this.crystalLoadCap;
    }

    public void setCrystalLoadCap(CrystalLoadCap crystalLoadCap) {
        this.crystalLoadCap = crystalLoadCap;
    }

    public void setOscEnabledByTransitDisabledInSleepMode(boolean oscEnabledByTransitDisabledInSleepMode) {
        this.oscEnabledByTransitDisabledInSleepMode = oscEnabledByTransitDisabledInSleepMode;
    }

    public boolean getInversePolarity() {
        return this.inversePolarity;
    }

    public void setInversePolarity(boolean inversePolarity) {
        this.inversePolarity = inversePolarity;
    }

    public FrequencyDeviation getFrequencyDeviation() {
        return this.frequencyDeviation;
    }

    public void setFrequencyDeviation(FrequencyDeviation frequencyDeviation) {
        this.frequencyDeviation = frequencyDeviation;
    }

    public boolean getOscEnabledByTransitDisabledInSleepMode() {
        return this.oscEnabledByTransitDisabledInSleepMode;
    }

    public boolean getAmpEnabledByTransitDisableInSleep() {
        return this.ampEnabledByTransitDisableInSleep;
    }

    public boolean getEnableCrystalOsc() {
        return this.enableCrystalOsc;
    }

    public void setEnableCrystalOsc(boolean enableCrystalOsc) {
        this.enableCrystalOsc = enableCrystalOsc;
    }

    public boolean getEnableSynth() {
        return this.enableSynth;
    }

    public void setEnableSynth(boolean enableSynth) {
        this.enableSynth = enableSynth;
    }

    public boolean getEnableAmp() {
        return this.enableAmp;
    }

    public void setEnableAmp(boolean enableAmp) {
        this.enableAmp = enableAmp;
    }

    public boolean getEnableLowBatDetection() {
        return this.enableLowBatDetection;
    }

    public void setEnableLowBatDetection(boolean enableLowBatDetection) {
        this.enableLowBatDetection = enableLowBatDetection;
    }

    public boolean getEnableWakeupTimer() {
        return this.enableWakeupTimer;
    }

    public void setEnableWakeupTimer(boolean enableWakeupTimer) {
        this.enableWakeupTimer = enableWakeupTimer;
    }

    public boolean getDisableOutputToClkPin() {
        return this.disableOutputToClkPin;
    }

    public void setDisableOutputToClkPin(boolean disableOutputToClkPin) {
        this.disableOutputToClkPin = disableOutputToClkPin;
    }

    public void setDataRate(DataRate dataRate) {
        this.dataRate = dataRate;
    }

    public DataRate getDataRate() {
        return this.dataRate;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        if (frequency > 4095) {
            frequency = 4095;
        }
        if (frequency < 0) {
            frequency = 0;
        }
        this.frequency = frequency;
    }

    public double getFrequencyCalculationFactor() {
        double factor = this.band == Band._915 ? 0.0075 : (this.band == Band._868 ? 0.005 : 0.0025);
        return factor;
    }

    public double getBaseFrequency() {
        double baseFrequency = this.band == Band._915 ? 900.0 : (this.band == Band._868 ? 860.0 : 430.0);
        return baseFrequency;
    }

    public double getCalculateFrequency() {
        double baseFrequency = this.getBaseFrequency();
        double factor = this.getFrequencyCalculationFactor();
        return baseFrequency + (double)this.frequency * factor;
    }

    public void setCalculatedFrequency(double fc) {
        double baseFrequency = this.getBaseFrequency();
        double factor = this.getFrequencyCalculationFactor();
        double min = this.getMinFrequency();
        double max = this.getMaxFrequency();
        if (fc < min) {
            fc = min;
        }
        if (fc > max) {
            fc = max;
        }
        this.setFrequency((int)Math.round((fc - baseFrequency) / factor));
    }

    private double getMaxFrequency() {
        double max = this.band == Band._915 ? 930.7125 : (this.band == Band._868 ? 880.475 : 440.2375);
        return max;
    }

    private double getMinFrequency() {
        double min = this.band == Band._915 ? 900.0 : (this.band == Band._868 ? 860.0 : 430.0);
        return min;
    }

    public OutputPower getOutputPower() {
        return this.outputPower;
    }

    public void setOutputPower(OutputPower outputPower) {
        this.outputPower = outputPower;
    }

    public long getThresholdValueLowBattery() {
        return this.thresholdValueLowBattery.getValue();
    }

    public void setThresholdValueLowBatteryValue(int thresholdValueLowBattery) {
        this.thresholdValueLowBattery.setValue(thresholdValueLowBattery);
    }

    public long getWakeUpTimerPeriodeMsExp() {
        return this.wakeUpTimerPeriodeMs.getExponent().getValue();
    }

    public long getWakeUpTimerPeriodeMsMantisse() {
        return this.wakeUpTimerPeriodeMs.getMantisse().getValue();
    }

    public void setWakeUpTimerPeriodeMsValue(int exp, int mantisse) {
        this.wakeUpTimerPeriodeMs.getExponent().setValue(exp);
        this.wakeUpTimerPeriodeMs.getMantisse().setValue(mantisse);
    }

    public AdjustableBitValue getSleepCommandWithinCLKs() {
        return this.sleepCommandWithinCLKs;
    }

    public void setSleepCommandWithinCLKs(int sleepCommandWithinCLKs) {
        this.sleepCommandWithinCLKs.setValue(sleepCommandWithinCLKs);
    }

    public ExponentialBitConfig getWakeUpTimerPeriodeMs() {
        return this.wakeUpTimerPeriodeMs;
    }

    public void setWakeUpTimerPeriodeMs(ExponentialBitConfig wakeUpTimerPeriodeMs) {
        this.wakeUpTimerPeriodeMs = wakeUpTimerPeriodeMs;
    }

    public void setDisableWakeUpTimerPeriodicCalibration(boolean disableWakeUpTimerPeriodicCalibration) {
        this.disableWakeUpTimerPeriodicCalibration = disableWakeUpTimerPeriodicCalibration;
    }

    public void setEnableTXBitSync(boolean enableTXBitSync) {
        this.enableTXBitSync = enableTXBitSync;
    }

    public boolean getDisableWakeUpTimerPeriodicCalibration() {
        return this.disableWakeUpTimerPeriodicCalibration;
    }

    public boolean getEnableTXBitSync() {
        return this.enableTXBitSync;
    }

    public String calculateConfigurationSettingCommand() {
        String result = "100";
        result = result + this.band.toBitSequence();
        result = result + this.clkFrequency.toBitSequence();
        result = result + this.crystalLoadCap.toBitSequence();
        result = this.inversePolarity ? result + "1" : result + "0";
        result = result + this.frequencyDeviation.toBitSequence();
        return Integer.toString(Integer.parseInt(result, 2), 16);
    }

    void applyConfigurationSettingCommand(int hex) {
    }

    public String calculatePowerManagementCommand() {
        String result = "11000000";
        result = this.oscEnabledByTransitDisabledInSleepMode ? result + "1" : result + "0";
        result = this.ampEnabledByTransitDisableInSleep ? result + "1" : result + "0";
        result = this.enableCrystalOsc ? result + "1" : result + "0";
        result = this.enableSynth ? result + "1" : result + "0";
        result = this.enableAmp ? result + "1" : result + "0";
        result = this.enableLowBatDetection ? result + "1" : result + "0";
        result = this.enableWakeupTimer ? result + "1" : result + "0";
        result = this.disableOutputToClkPin ? result + "1" : result + "0";
        return Integer.toString(Integer.parseInt(result, 2), 16);
    }

    public String calculateFrequencySettingCommand() {
        String result = "1010";
        result = result + BitSequence.toBitSequence(BitSequence.intToBitArray(12, this.getFrequency()));
        return Integer.toString(Integer.parseInt(result, 2), 16);
    }

    public String calculateUpdateDataRateCommand() {
        String result = "11001000";
        result = result + this.getDataRate().toBitSequence();
        return Integer.toString(Integer.parseInt(result, 2), 16);
    }

    public String calculatePowerSettingCommand() {
        String result = "10110";
        result = result + this.outputPower.toBitSequence();
        return Integer.toString(Integer.parseInt(result, 2), 16);
    }

    public String calculateLowBatteryCommand() {
        String result = "11000010";
        result = this.disableWakeUpTimerPeriodicCalibration ? result + "1" : result + "0";
        result = result + "0";
        result = this.enableTXBitSync ? result + "1" : result + "0";
        result = result + this.thresholdValueLowBattery.toBitSequence();
        return Integer.toString(Integer.parseInt(result, 2), 16);
    }

    public String calculateSleepCommand() {
        String result = "11000100";
        result = result + this.sleepCommandWithinCLKs.toBitSequence();
        return Integer.toString(Integer.parseInt(result, 2), 16);
    }

    public String calculateWakeupTimerComand() {
        String result = "111";
        result = result + this.wakeUpTimerPeriodeMs.getExponent().toBitSequence();
        result = result + this.wakeUpTimerPeriodeMs.getMantisse().toBitSequence();
        return Integer.toString(Integer.parseInt(result, 2), 16);
    }

    public String calculateHalfDataRateComand() {
        String result = "110100000";
        result = this.halfDataRate ? result + "1" : result + "0";
        result = result + "000000";
        return Integer.toString(Integer.parseInt(result, 2), 16);
    }

    public boolean getHalfDataRate() {
        return this.halfDataRate;
    }

    public void setHalfDataRate(boolean halfDataRate) {
        this.halfDataRate = halfDataRate;
    }
}

