; ##############################################################################
; ##############################################################################
; ##############################################################################
EXTERNER_INTERUPT_INITIALISIEREN:
;																			
; SLEEP+INT0+INT1 (externer Interrupt) konfigurieren						
;																			
; MCUCR => SE SM2 SM1 SM0 ISC11 ISC10 ISC01 ISC00 							
; SM2 SM1 SM0 Sleep Mode													
;*0   0   0   Idle															
; 0   0   1   ADC Noise Reduction											
; 0   1   0   Power-down													
; 0   1   1   Power-save													
; 1   0   0   Reserved														
; 1   0   1   Reserved														
; 1   1   0   Standby(1)													
;																			
;ISC11 ISC10 Description													
; 0 	0 	The low level of INT1 generates an interrupt request.			
; 0 	1 	Any logical change on INT1 generates an interrupt request.		
; 1 	0 	The falling edge of INT1 generates an interrupt request.		
; 1 	1 	The rising edge of INT1 generates an interrupt request.			
;																			
;ISC01 ISC00 Description													
; 0 	0 	The low level of INT0 generates an interrupt request.			
; 0 	1 	Any logical change on INT0 generates an interrupt request.		
;*1 	0 	The falling edge of INT0 generates an interrupt request.		
; 1 	1 	The rising  edge of INT0 generates an interrupt request.		
;																			
	ldi temp,(1<<SE)|(0<<SM2)|(0<<SM1)|(0<<SM0)|(0<<ISC11)|(0<<ISC10)|(1<<ISC01)|(0<<ISC00) 
	out MCUCR,temp

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
EXTERNER_INTERRUPT_AKTIVIEREN:
;																			
; INT0+INT1 (externer Interrupt)aktivieren									
;																			
; GICR => INT1 INT0 - - - - IVSEL IVCE 										
; General Interrupt Control													
;																			
	ldi temp, (0<<INT1)|(1<<INT0)|(0<<IVSEL)|(0<<IVCE)   
    out GICR, temp 
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Dieser Interrupt bei fallender Flanke											
EXT_INT0:
	in	 KOPIE_SREG,SREG; SICHERN SREG 	
	mov  KOPIE_TEMP,temp; SICHERN TEMP	
;===============================================================================
	; Timerwert einlesen
	in temp, TCNT2
	; ERROR (ignorieren)
	cpi temp,(0+20)
	brlo EXT_INT0_ERROR
	cpi temp,(140-20)
	brsh EXT_INT0_ERROR
	; kleine Korrektur	
	cpi temp,(70-1)
	brlo EXT_INT0_A
	cpi temp,(70+1)
	brsh EXT_INT0_B
	; OK				
	rjmp EXT_INT0_OK
;===============================================================================
EXT_INT0_A:
	cbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB an	
	in temp,OCR2
	dec temp
	out OCR2,temp
	rjmp EXT_INT0_FERTIG
;===============================================================================
EXT_INT0_B:
	cbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB an	
	in temp,OCR2
	inc temp
	out OCR2,temp
	rjmp EXT_INT0_FERTIG
;===============================================================================
EXT_INT0_ERROR:
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  an	
	rjmp EXT_INT0_FERTIG
;===============================================================================
EXT_INT0_OK:
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
;===============================================================================
EXT_INT0_FERTIG:
	mov temp,KOPIE_TEMP	; Wiederherstellen von "TEMP" 			
	out	SREG,KOPIE_SREG	; Wiederherstellen von SREG				
	cbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN an	
reti
; ##############################################################################
; ##############################################################################
; ##############################################################################
