; ##############################################################################
; ##############################################################################
; ##############################################################################
TIMER_AKTIVIEREN:
;																			
; Timer-0 berlauf-Int aktivieren (Timer/Counter Interrupt Mask)			
;																			
; TIMSK ==> OCIE2 TOIE2 TICIE1 OCIE1A OCIE1B TOIE1 R TOIE0  				
;																			
	ldi temp,(0<<OCIE2)|(1<<TOIE2)|(0<<TICIE1)|(0<<OCIE1A)|(0<<OCIE1B)|(0<<TOIE1)|(1<<TOIE0)
	out TIMSK,temp       
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; TESTGENERATOR																	
TIMER1_CTC_INITIALISIERUNG:
; Vorteiler													
; cs12 cs11 cs10											
;	0 	0 	0 	No clock source. (Timer/Counter stopped)	
; *	0 	0 	1 	clkI/O/1 (No prescaling)					
;	0 	1 	0 	clkI/O/8 (From prescaler)					
;	0 	1 	1 	clkI/O/64 (From prescaler)					
;	1 	0 	0 	clkI/O/256 (From prescaler)					
;	1 	0 	1 	clkI/O/1024 (From prescaler) 				
   	ldi     r16,(1<<wgm12|0<<cs12|0<<cs11|1<<cs10)  
   	out     tccr1B,r16 
	;  Compare Output Mode 										
   	ldi temp, (0<<COM1A1)|(1<<com1A0)
   	out TCCR1A,temp
	; Frequenz einstellen										
    ldi     temp,high(TIMER1CTC)                 
    out     ocr1AH, temp             
   	ldi     temp,low(TIMER1CTC)
   	out     ocr1AL,temp              
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; GENERATOR																		
TIMER2_CTC_INITIALISIERUNG:
; Vorteiler / Output Mode									
; cs22 cs21 cs20											
;  0    0    1 clkT2S/(No prescaling)						
;  0    1    0 clkT2S/8 (From prescaler)					
;  0    1    1 clkT2S/32 (From prescaler)					
;  1    0    0 clkT2S/64 (From prescaler)					
;  1    0    1 clkT2S/128 (From prescaler)					
;  1    1    0 clkT2S/256 (From prescaler)					
;  1    1    1 clkT2S/1024 (From prescaler)					
   	ldi     temp,(1<<com20|1<<wgm21|0<<cs22|0<<cs21|1<<cs20)  
   	out     tccr2,temp 
	; STARTWERT						
	OUT TCNT2,NULL
	; TIMER-2 Frequenz einstellen	
    ldi     temp,(TIMER2CTC57kHz)
   	out     OCR2,temp              
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
