; Frequenzverdreifacher 19/57kHz				
; Bernhard.Erfurt@gmx.de						
; 05/2014										
; VERSION 1										
;												

;												
; Anschlussbelegung PINS						
;												
; PB0 ==> 										
; PB1 ==> 										
; PB2 ==> OUT TEST-GENERATOR					
; PB3 ==> OUT 57kHz								
; PB4 ==> 										
; PB5 ==> 										
; PB6 ==> Quarz									
; PB7 ==> Quarz									
;												
; PC0 ==> 										
; PC1 ==> 										
; PC2 ==> 										
; PC3 ==> 										
; PC4 ==> 										
; PC5 ==>										
;												
; PD0 ==> 										
; PD1 ==> 										
; PD2 ==> INPUT (MPX)							
; PD3 ==> 										
; PD4 ==> 										
; PD5 ==> LED GRN								
; PD6 ==> LED GELB								
; PD7 ==> LED ROT								
;												

; ATmega8 										
.include "m8def.inc"

; KONSTANTEN									
.equ TAKT							=16000000	
; TIMER-WERTE									
.equ TIMER1CTC						= 0			;   0=halber TAKT		
.equ TIMER2CTC57kHz					= 139		;   139=57.143kHz			
; EINGANG-A										
.equ EINGANG_A_PIN_NR				= 2
.equ EINGANG_A_PORT					= PORTD
; LED-GRUEN										
.equ LED_GRUEN_PIN_NR				= 5
.equ LED_GRUEN_DDR					= DDRD
.equ LED_GRUEN_PORT					= PORTD
; LED-GELB										
.equ LED_GELB_PIN_NR				= 6
.equ LED_GELB_DDR					= DDRD
.equ LED_GELB_PORT					= PORTD
; LED-ROT										
.equ LED_ROT_PIN_NR					= 7
.equ LED_ROT_DDR					= DDRD
.equ LED_ROT_PORT					= PORTD
; AUSGANG-CTC (CTC-Timer1)						
.equ AUSGANG_CTC1_PIN_NR			= 1
.equ AUSGANG_CTC1_DDR				= DDRB
.equ AUSGANG_CTC1_PORT				= PORTB
; AUSGANG-57kHz (CTC-Timer2)					
.equ AUSGANG_CTC2_PIN_NR			= 3
.equ AUSGANG_CTC2_PIN				= PINB
.equ AUSGANG_CTC2_DDR				= DDRB
.equ AUSGANG_CTC2_PORT				= PORTB
; SRAM-BELEGUNG ATmega8							
.equ adr_DATEN						= SRAM_START		; 0x0060 START Adresse 		

.equ adr_SRAM_CHECK					= SRAM_START+943	; SRAM CHECK muss immer "S" sein	

; REGISTER										
.def KOPIE_SREG			= R0	; SREG (INTERRUPT)
.def KOPIE_TEMP			= R1	; TEMP (INTERRUPT)

.def ZAEHLER_TAKTKORREKTUR=R6

.def NULL 				= R14
.def EINS 				= R15

.def temp 	= R16
.def temp1 	= R17
.def temp2 	= R18
.def temp3 	= R19
.def temp4 	= R20
.def temp5 	= R21
.def temp6 	= R22
.def temp7 	= R23
.def temp8 	= R24
.def temp9 	= R25


.cseg					;Beginn eines Code-Segmentes							
.org 0					;Startadresse=0											

rjmp RESET      		; Reset Handler                           				
rjmp EXT_INT0	 		; IRQ0 Handler                      					
rjmp INTERRUPT_ERROR	;rjmp EXT_INT1   ; IRQ1 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp TIM2_COMP  ; Timer2 Compare Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM2_OVF   ; Timer2 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_CAPT  ; Timer1 Capture Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPA ; Timer1 CompareA Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPB ; Timer1 CompareB Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_OVF 	 ; Timer1 Overflow Handler       		
rjmp INTERRUPT_ERROR	;rjmp TIM0_OVF 	 ; Timer0 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp SPI_STC    ; SPI Transfer Complete Handler     	
rjmp INTERRUPT_ERROR	;rjmp USART_RXD  ; USART RX Complete Handler   			
rjmp INTERRUPT_ERROR	;rjmp USART_UDRE ; UDR Empty Handler                 	
rjmp INTERRUPT_ERROR	;rjmp USART_TXC  ; USART TX Complete Handler         	
rjmp INTERRUPT_ERROR	;rjmp ADC        ; ADC Conversion Complete Handler   	
rjmp INTERRUPT_ERROR	;rjmp EE_RDY     ; EEPROM Ready Handler              	
rjmp INTERRUPT_ERROR	;rjmp ANA_COMP   ; Analog Comparator Handler         	
rjmp INTERRUPT_ERROR	;rjmp TWSI       ; Two-wire Serial Interface Handler 	
rjmp INTERRUPT_ERROR	;rjmp SPM_RDY    ; Store Program Memory Ready Handler	


; Unkorrekten Interrupt Aufruf 						
INTERRUPT_ERROR:
	CLI ; Interrupt sperren	
	cbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN an	
	cbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB an	
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  an	
	rcall wait_100ms
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus  
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
	rcall wait_100ms
	rjmp INTERRUPT_ERROR

RESET:                        
; STACK initialisieren								
	ldi temp, LOW(RAMEND)
    out SPL, temp
    ldi temp, HIGH(RAMEND)
    out SPH, temp
; SRAM lschen										
	rcall SRAM_CLEAR
; STARTWERTE										
	; NULL				
	clr NULL
	; EINS				
	ldi temp,1
	mov EINS,temp
	; SRAM CHECK		
	ldi temp,'S'
	STS(adr_SRAM_CHECK),temp
; PORT B+C+C initialisieren							
	out DDRB, NULL
	out DDRC, NULL
	out DDRD, NULL
	out PORTB,NULL
	out PORTC,NULL
	out PORTD,NULL
; PULL-UPs ein										
	sbi (EINGANG_A_PORT),(EINGANG_A_PIN_NR)

; PORT LED auf AUSGANG								
	sbi (LED_GRUEN_DDR),(LED_GRUEN_PIN_NR)						; GRN		
	sbi (LED_GELB_DDR),(LED_GELB_PIN_NR)						; GELB		
	sbi (LED_ROT_DDR),(LED_ROT_PIN_NR)							; ROT		
; LEDs an											
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)						; GRN an	
	cbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)						; GELB an	
	cbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)						; ROT  an	
; auf AUSGANG										
	sbi (AUSGANG_CTC1_DDR),(AUSGANG_CTC1_PIN_NR)				; CTC1		
	sbi (AUSGANG_CTC2_DDR),(AUSGANG_CTC2_PIN_NR)				; CTC2		
; AUSGNGE auf LOW									
	cbi (AUSGANG_CTC1_PORT) ,(AUSGANG_CTC1_PIN_NR)				; CTC1		
	cbi (AUSGANG_CTC2_PORT) ,(AUSGANG_CTC2_PIN_NR)				; CTC2		
; WDR_INITIALISIERUNG								
	rcall WDR_INITIALISIERUNG
; NEUSTART_MIT_WDR									
	rcall NEUSTART_MIT_WDR
; LED-TEST											
	rcall LED_TEST
; 	PROGRAMM_CHECK									
	rcall PROGRAMM_CHECK
; EXTERNER-INTERUPT									
	rcall EXTERNER_INTERUPT_INITIALISIEREN
	rcall EXTERNER_INTERRUPT_AKTIVIEREN
; CTC												
	rcall TIMER1_CTC_INITIALISIERUNG
	rcall TIMER2_CTC_INITIALISIERUNG
	rcall TIMER_AKTIVIEREN
; Interrupts freigeben								
	sei
; LEDS												
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
; ##############################################################################
; ##############################################################################
; ##############################################################################
LOOP:
LOOP_A:
	WDR											; Watch-Dog-RESET		
	sbic (AUSGANG_CTC2_PIN),(AUSGANG_CTC2_PIN_NR)
	rjmp LOOP_A
	rcall TAKTKORREKTUR
	; Hat sich PIN-Zustand gendert? (Berechnung dauert zu lange)
	sbic (AUSGANG_CTC2_PIN),(AUSGANG_CTC2_PIN_NR)
	rjmp LOOP_ERROR
LOOP_B:
	WDR											; Watch-Dog-RESET		
	sbis (AUSGANG_CTC2_PIN),(AUSGANG_CTC2_PIN_NR)
	rjmp LOOP_B
	rcall TAKTKORREKTUR
	; Hat sich PIN-Zustand gendert? (Berechnung dauert zu lange)
	sbis (AUSGANG_CTC2_PIN),(AUSGANG_CTC2_PIN_NR)
	rjmp LOOP_ERROR
rjmp LOOP
;-------------------------------------------------------------------------------
LOOP_ERROR:
	CLI ; Interrupt sperren	
	WDR
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus  
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  an	
rjmp LOOP_ERROR
; ##############################################################################
; ##############################################################################
; ##############################################################################
; TAKTKORREKTUR, zur Generierung des 57kHz Signals								
TAKTKORREKTUR:
	; Z-Initalisieren		
	ldi ZL,LOW (TABELLE_TAKTKORREKTUR_16MHz*2)
	ldi ZH,HIGH(TABELLE_TAKTKORREKTUR_16MHz*2)
	add ZL,ZAEHLER_TAKTKORREKTUR		; addieren			
	adc ZH,NULL
	LPM temp, Z   						; aus Tabelle laden 
	inc ZAEHLER_TAKTKORREKTUR			; +1				
	; Tabellenwert NULL ?	
	tst temp
	brne TAKTKORREKTUR_w
	clr ZAEHLER_TAKTKORREKTUR
	rjmp TAKTKORREKTUR
	;-----------------------
TAKTKORREKTUR_w:
	dec temp							; -1 (CTC)			
	out OCR2,temp              			; CTC				
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
.include "PLL_TIMER.asm"
.include "PLL_EXTINTERRUPT.asm"
.include "PLL_SONSTIGES.asm"			; sonstiges						
.include "PLL_WAIT_16MHZ.asm"			; 16 MHz						
;-------------------------------------------------------------------------------
TABELLE_TAKTKORREKTUR_16MHz:	; 57kHz	
.db 140,141,140,140,141,140,140,141,140,141
.db 140,140,141,140,140,141,140,140,141,140
.db 140,141,140,140,141,140,140,141,140,141
.db 140,140,141,140,140,141,140,140,141,140
.db 140,141,140,140,141,140,140,141,140,141
.db 140,140,141,140,140,141,140,0

