/* um die erweiterten Styles von CommCtrls nutzen zu knnen*/
#define _WIN32_IE 0x0400


// #define debug 1

#include <math.h>
#include <stdio.h>
#include <time.h>
#include <sys\stat.h>
#include <windows.h>
#include <commctrl.h>
#include "main.h"
#include "resource.h"
#include "cmd_parser.c" /* zur Zerlegung der CMD-Line in argc und **argv */
#include "tmp_handling.c"

#ifndef GWL_HINSTANCE
 #define GWL_HINSTANCE -6
#endif
#define MAXLINELENGTH 32768

/* Funktionsdeklarationen */

LRESULT CALLBACK WndProc (HWND, 
			  UINT, 
			  WPARAM,
			  LPARAM);

LRESULT CALLBACK WndProcData (HWND, 
			  UINT, 
			  WPARAM,
			  LPARAM);

DLGPROC Dialog1_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam);
		    
DLGPROC Dialog2_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam);
		    
DLGPROC Dialog3_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam);
		    
DLGPROC Dialog4_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam);

DLGPROC Dialog5_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam);


HINSTANCE g_hInst;
HWND g_hWnd=0,g_hwndStatus,g_hWndData,g_hWndDataEdit,g_hWndUp,g_hWndDown,g_hWndLeft,g_hWndRight,g_hWndLv;
int left=0,top=0,right=800,bottom=600;
int paintcount,ColumnCount=0,LineCount=0,Pairmode=0,
    littlestep=3600,bigstep=3600*24,aktstift=-1,KlickX,KlickY,
    MouseXscroll=50,MouseYscroll=10,SeparatorChar=';',
    Stackpointer=0,Stackfuel=0,Testmode,Timer=0,
    Refreshtime=0,Refreshcounter=0,TempVerfall=1000000,
    mark,mark1,mark2,Xbase,Ybase,
    BorderLeft=10,BorderRight=10,BorderTop=20,BorderBottom=10,TextSize=40;
char BUILT[]   = "Version 1.02 beta, von "__DATE__ ", " __TIME__;
char FontName[300],DefUnit[30],IniFileName[300],CurrentWorkDir[300],
      WorkFileName[300],LastFileName[200];    
char Filterstring[40],InvalidValue=0;

float Scale=60,offset=0;
double Zoom=360;
double CursorValue;
FILE *datei=0;
double Startzeit,Endzeit;
double Aktzeit;
double Cursorzeit;

struct
 {
 char name[320];
 char einheit[32];
 COLORREF farbe;
 int stil;
 int aktiv;
 int standard;
 double offset;
 double letzter,akt;
 char blk;
 }
 ColRec, *Spalten=NULL;

typedef struct FILTER
 {
 char ext[20];
 char name[30];
 char konverter[300];
 char konfig[300];
 struct FILTER *next; 
 } FILTER, *PFILTER;

FILTER *Filter=NULL;
 
struct {
	 double Aktzeit;
	 float offset,Scale;
	 double Zoom;
	} ViewStack[256];


int InversRect(HDC hdc,int x1,int x2,int y1,int y2)
 {
 RECT rc;
 if(x1>x2)
  {
  rc.left=x2;
  rc.right=x1;
  rc.top=y1;
  rc.bottom=y2;
  InvertRect(hdc,&rc);
  }
 if(x2>x1)
  {
  rc.left=x1;
  rc.right=x2;
  rc.top=y1;
  rc.bottom=y2;
  InvertRect(hdc,&rc);
  }
 return 0;
 }


int FiltClear(void)
 {
 FILTER *fp,*fp1;
 if(!Filter) return 0;
 fp=Filter;
 while(fp)
  {
  fp1=fp->next;
  free(fp);
  fp=fp1;
  }
 }


double Runden(double Wert)
 {
 char st1[100];
 double w1;
 sprintf(st1,"%1.1lE",Wert);
 sscanf(st1,"%lE",&w1);
 return w1;
 }

/* liefert den nchsten Messwert */
float parse(char **cp,float alt)
 {
 float reslt=alt;
 char *cp2;
 if(!(*cp)) return 0; 
 cp2=strchr(*cp,SeparatorChar);
 if(cp2) *cp2=0;
// if(!strlen(*cp)) return alt;	/* leeres feld: altwert */
 if(strstr(*cp,"#IN"))
  {
  reslt=0;
  InvalidValue=1;
  }
 else
  {
  sscanf(*cp,"%f",&reslt);
  InvalidValue=0;
  }
 if(cp2) *cp=cp2+1; else *cp=NULL; 
 return reslt;
 }

/* Zeitstempel lesen */
double ReadTime(char *st,char **rp)
 {
 int monat,jahr;
 struct tm t;
 time_t tt;
 double zeit,sec=0;
 char *cp;
 /* Kommas in der Zeile durch Punkte ersetzen */
 cp=st;
 if(SeparatorChar!=',') while (cp=strchr(cp,',')) *cp='.';
 if(cp=strchr(st,'\n')) *cp=0;  /*Zeilenendezeichen umwandeln*/ 
 memset(&t,0,sizeof(t));
 sscanf(st,Filterstring,&t.tm_mday,&monat,&jahr,
		  &t.tm_hour,&t.tm_min,&sec);
 t.tm_sec=0; /* werden spter addiert */
 t.tm_mon=monat-1;
 t.tm_year=jahr-1900;
 t.tm_isdst=-1; 
 tt=mktime(&t);
 zeit=tt;	/* ganzzahliger Teil */
 zeit=zeit+sec;
 /* *rp soll Zeiger auf ersten Wert zurckliefern */
 cp=strchr(st,SeparatorChar);
 if(cp) cp=strchr(cp+1,SeparatorChar);
 if(cp) *rp=cp+1; else *rp=0;
 return zeit;
 }


int AutoScale(int Set)
 {
 char st1[MAXLINELENGTH],*cp;
 int a,c=0,Mantisse,Exponent,laenge;
 float minimum=1e10,minimum0,maximum=-1e10,x;
 double t1;
 RECT rcClient;
 
 if(!datei) return 0;
 LineCount=0;
 Endzeit=0;
 Startzeit=0x7fffffff;
 sprintf(Filterstring,"%%d.%%d.%%d%c%%d:%%d:%%lf",SeparatorChar);
 rewind(datei);
 fgets(st1,MAXLINELENGTH-2,datei);	/* erste Zeile brauchen wir nicht */
 SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) "Minima/Maxima werden gesucht, bitte warten!");	     
 do
  {
   memset(st1,0,MAXLINELENGTH);
   fgets(st1,MAXLINELENGTH-2,datei);
   if((!feof(datei))&&(strlen(st1)>12))
   {
   LineCount++;
   t1=ReadTime(st1,&cp);
   if (t1>Endzeit) Endzeit=t1;
   if (t1<Startzeit) Startzeit=t1;
 
   /* Maxima suchen */
    for(a=0;a<ColumnCount;a++)
     {
     x=parse(&cp,0); /*weiterzhlen*/
      if(Spalten[a].aktiv)
       {
       if(x<minimum) minimum=x;
       if(x>maximum) maximum=x;
       }
     }
    c++; 
    }
  } 
  while(!feof(datei));
  rewind(datei);
  minimum0=minimum;

#ifdef debug
 sprintf(st1," Scale=%f, Offset=%f, Startzeit=%lf, Endzeit=%lf, %d Zeilen gelesen",Scale,offset,Startzeit,Endzeit,LineCount);
 MessageBox(0,st1,"AutoScale ausgefhrt!",MB_OK);
#endif


 if(!c)
  {
  MessageBox(0,"In der Datei sind keine Daten enthalten!",
	     "Fehler",MB_OK);
  fclose(datei);
  FileClose();
  datei=0;
  return 0;
  }

 if(Set)
 {
 Scale=(maximum-minimum)*1.2;
 /* Maximum aufrunden */
 sprintf(st1,"%E",Scale);
 sscanf(st1,"%d",&Mantisse);
 if(cp=strchr(st1,'E')) sscanf(cp+1,"%d",&Exponent);
 Mantisse+=1;
 sprintf(st1,"%d.0E%+d",Mantisse,Exponent);
 sscanf(st1,"%E",&Scale);

 minimum-=Scale/10;
 /* Minimum abrunden */
 sprintf(st1,"%E",minimum);
 sscanf(st1,"%d",&Mantisse);
 if(cp=strchr(st1,'E')) sscanf(cp+1,"%d",&Exponent);
 //Mantisse-=1;
 sprintf(st1,"%d.0E%+d",Mantisse,Exponent);
 sscanf(st1,"%E",&offset);
 if((offset<=0)&&(minimum0>=0)) offset=0;
 Aktzeit=Startzeit;
 laenge=Endzeit-Startzeit;
 /*Bildschirmgre ermitteln*/
 GetClientRect(g_hWnd, &rcClient);
 Zoom=laenge;
 Zoom=Zoom/(rcClient.right-80);
 }

 if(Scale==0) Scale=1;
 if(Zoom<0.0000001) Zoom=0.0000001;
 InvalidateRect(g_hWnd,0,TRUE);
 return 0;
 }

int ViewPush(void)
 {
 Stackfuel++;
 if(Stackfuel>256) Stackfuel--; /* Stack schon voll: alte Werte berschreiben */
 ViewStack[Stackpointer].Aktzeit=Aktzeit;
 ViewStack[Stackpointer].Scale=Scale;
 ViewStack[Stackpointer].offset=offset;
 ViewStack[Stackpointer].Zoom=Zoom;
 Stackpointer++;
 if(Stackpointer>255) Stackpointer=0;
 }
 
int ViewPop(void)
 {
 /* gespeicherte Fensterposition restaurieren */
 if(!Stackfuel) return 0; /* nix zu poppen */
 Stackfuel--;
 Stackpointer--;
 if(Stackpointer<0) Stackpointer=255;
 Aktzeit=ViewStack[Stackpointer].Aktzeit;
 Scale=ViewStack[Stackpointer].Scale;
 offset=ViewStack[Stackpointer].offset;
 Zoom=ViewStack[Stackpointer].Zoom;
 InvalidateRect(g_hWnd,0,TRUE);
 }

int Center(float Faktor)
 {
	      //char st1[200];
	      double a;
	      double Mitte;
	      RECT rcClient;
	      
	      ViewPush(); /* Ansicht speichern */

	      /* Uhrzeit der Klickpos errechnen */
	      Mitte=Aktzeit+((KlickX-Xbase)*Zoom);

	      /* Ansichtsgre verdoppeln */
	      Zoom /=Faktor; 
	      if(Zoom<0.0000001) Zoom=0.0000001;

	      /* nutzbare Fensterbreite ermitteln */
	      GetClientRect(g_hWnd, &rcClient);
	      a=(rcClient.right-Xbase)/2*Zoom;
	      Aktzeit=Mitte-a;
	      InvalidateRect(g_hWnd,0,TRUE); 
	      return 0;
 }


int Vcenter(float Faktor)
 {
  RECT rcClient;
//  char st1[200];
  int a;
  double f;

  GetClientRect(g_hWnd, &rcClient);
  rcClient.top+=20;
  
  ViewPush();
  a=Ybase-KlickY;
  f=a*Scale/(Ybase-rcClient.top);
  f+=offset; /* hat jetzt den Wert, fr die Bildschirmmitte */
  Scale/=2;   /* vergrern */
  offset=Runden(f-(Scale/2));

//  sprintf(st1,"%lf",f);
//  MessageBox(0,st1,"Mitte",MB_OK);
  
  InvalidateRect(g_hWnd,0,TRUE); 
  return 0;
 }

  
int ConfigLoadFile(FILE *datei)
 {
 char st1[400],*cp;
	 if(datei)
	  {
	  //MessageBox(0,IniFileName,"Lade IniFile=",MB_OK);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&left);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&right);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&top);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&bottom);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&littlestep);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&bigstep);
	  if(fgets(st1,200,datei)) sscanf(st1,"%lf\n",&Zoom);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&Pairmode);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&Testmode);
	  if(fgets(st1,200,datei)) strcpy(FontName,st1);
	  if(fgets(st1,200,datei)) strcpy(DefUnit,st1);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&MouseXscroll);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&MouseYscroll);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&SeparatorChar);
	  if(fgets(st1,300,datei)) 
	    {
	    cp=strchr(st1,'\n');
	    if (cp) *cp=0;
	    strcpy(LastFileName,st1);
	    }
	  if(fgets(st1,200,datei)) sscanf(st1,"%f\n",&Scale);
	  if(fgets(st1,200,datei)) sscanf(st1,"%f\n",&offset);
	  if(fgets(st1,200,datei)) sscanf(st1,"%lf\n",&Aktzeit);
	  if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&TempVerfall);

	  if(cp=strchr(FontName,'\n')) *cp=0;
	  if(cp=strchr(DefUnit,'\n')) *cp=0;
	  fclose(datei);
	  if(g_hWnd) MoveWindow(g_hWnd,left,top,right-left,bottom-top,TRUE);
	  }

  return;
 }

int ConfigSaveFile(FILE *datei1)
 {
 WINDOWPLACEMENT wp;

 GetWindowPlacement(g_hWnd,&wp);
 fprintf(datei1,"%d\n",wp.rcNormalPosition.left);
 fprintf(datei1,"%d\n",wp.rcNormalPosition.right);
 fprintf(datei1,"%d\n",wp.rcNormalPosition.top);
 fprintf(datei1,"%d\n",wp.rcNormalPosition.bottom);
 fprintf(datei1,"%d\n",littlestep);
 fprintf(datei1,"%d\n",bigstep);
 fprintf(datei1,"%lf\n",Zoom);
 fprintf(datei1,"%d\n",Pairmode);
 fprintf(datei1,"%d\n",Testmode);
 fprintf(datei1,"%s\n",FontName);
 fprintf(datei1,"%s\n",DefUnit);
 fprintf(datei1,"%d\n",MouseXscroll);
 fprintf(datei1,"%d\n",MouseYscroll);
 fprintf(datei1,"%d\n",SeparatorChar);
 fprintf(datei1,"%s\n",WorkFileName);
 fprintf(datei1,"%f\n",Scale);
 fprintf(datei1,"%f\n",offset);
 fprintf(datei1,"%lf\n",Aktzeit); /* Type mismatch !!!!! */
 fprintf(datei1,"%d\n",TempVerfall);
 fclose(datei1);
 //MessageBox(0,IniFileName,"Inifile geschrieben",MB_OK);

  return;
 }


int ConfigLoad(char *name)
 {
 FILE *datei=0;
 char *cp,st1[310];

  if(!(GetKeyState(VK_SHIFT)&0x80000000))
  {
  if(argc>2)
  {
  /* als Kommandozeilenparameter mitgegeben */
  strcpy(IniFileName,argv[2]);
  datei=fopen(IniFileName,"r");
  }

 if((!datei)&&(strlen(name)))
  {
  /* Versuchen eine "dateiname.ini" einzulesen */
  strcpy(IniFileName,name);
  cp=strrchr(IniFileName,'.');
  if (cp)
   {
   strcpy(cp,".ini");
   datei=fopen(IniFileName,"r");  
   }
  }

 if(!datei)
  {
  /* Versuchen eine "csv_view.ini" im Dateiverzeichnis einzulesen */
  strcpy(IniFileName,name);
  cp=strrchr(IniFileName,'\\');
  if (cp)
   {
   strcpy(cp,"\\csv_view.ini");
   datei=fopen(IniFileName,"r");  
   }
  }

 if(!datei)
  {
  /* ansonsten die aus dem %userprofile% */
  GetEnvironmentVariable("USERPROFILE",IniFileName,290);
  strcat(IniFileName,"\\csv_view.ini");
  datei=fopen(IniFileName,"r");  
  }
  ConfigLoadFile(datei);
  }
 return 0;
 }

int Hilfe(void)
 {
 MessageBox(g_hWnd,"Pfeil links oder rechts: Verschieben horizontal um einen kleinen Schritt\n"
		   "<Strg>- Pfeil links oder rechts: um einen groen Schritt\n"
		   "Pfeil hoch oder runter: Verschieben vertikal um ein Zehntel\n"
		   "+: horizontal Vergrern, -: horizontal Verkleinern\n"
		   "h: vertikal Vergrern (hher), n: vertikal Verkleinern (hiedriger)\n" 
		   "<Umschalt>- Pfeil links: zurck zur vorherigen Ansicht"
 ,"Tastenbelegung",MB_OK);
 }




DLGPROC PrintSettings_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam)
   {
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
      char st1[200];
      sprintf(st1,"%d",BorderLeft);
      SendMessage(GetDlgItem(hWnd,IDC_LeftBorder),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",BorderRight);
      SendMessage(GetDlgItem(hWnd,IDC_RightBorder),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",BorderTop);
      SendMessage(GetDlgItem(hWnd,IDC_TopBorder),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",BorderBottom);
      SendMessage(GetDlgItem(hWnd,IDC_BottomBorder),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",TextSize);
      SendMessage(GetDlgItem(hWnd,IDC_TextSize),WM_SETTEXT,0,(LPARAM) st1);      
      }
      break;
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDOK:
 	   {
	    char st1[200];
            SendMessage(GetDlgItem(hWnd,IDC_LeftBorder),WM_GETTEXT,10,(LPARAM) st1);
            sscanf(st1,"%d",&BorderLeft);
            SendMessage(GetDlgItem(hWnd,IDC_RightBorder),WM_GETTEXT,10,(LPARAM) st1);
            sscanf(st1,"%d",&BorderRight);
            SendMessage(GetDlgItem(hWnd,IDC_TopBorder),WM_GETTEXT,10,(LPARAM) st1);
            sscanf(st1,"%d",&BorderTop);
            SendMessage(GetDlgItem(hWnd,IDC_BottomBorder),WM_GETTEXT,10,(LPARAM) st1);
            sscanf(st1,"%d",&BorderBottom);
            SendMessage(GetDlgItem(hWnd,IDC_TextSize),WM_GETTEXT,10,(LPARAM) st1);
            sscanf(st1,"%d",&TextSize);
	    InvalidateRect(g_hWnd,0,TRUE);
	    EndDialog(hWnd,1);
	    }
	   break;
	   case IDCANCEL:
	    {
    	 EndDialog(hWnd,0);
        }
       break;		
       }  
      }
     break;
     case WM_SYSCOMMAND:
      {
       switch(wParam)
	{
	 case SC_CLOSE:
	 {
	 EndDialog(hWnd,0);
	 }
	 break;
	}
      }
      break;  
     }
   return FALSE; 
   }

int FileClose()
 {
 FILE *datei1;	/* ini-Datei */
 char st1[300];
 
 /* Einstellungen speichern */
 datei1=fopen(IniFileName,"w");
 ConfigSaveFile(datei1);

 if(datei)
  {
  Stackfuel=0;
  fclose(datei);
  datei=0;
  }
  ColumnCount=0;
  if(Spalten) free(Spalten);
  SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) "keine Datei geladen!");
 return 0;
 }

int MyStrCmp(char *st1, char *st2)
 {
 /* Nicht case-sensitives strcmp */
 while ((*st1)||(*st2))
  {
  if(tolower(*st1)!=tolower(*st2)) return 1;
  st1++;
  st2++;
  }
 return 0;
 }

int Convert(char *Quell, char *Ziel)
 {
 FILTER *fp;
 struct stat stat1,stat2;
 char *ext,cmdline[1200];
 
 if(!Filter) return 0; /* Garkein Filter definiert */
 /* passenden Filter raussuchen */
 ext=strrchr(Quell,'.');
 if(!ext) return 0;   /* keine Erweiterung */
 ext++;
 
 fp=Filter;
 while((fp)&&(MyStrCmp(ext,fp->ext))) fp=fp->next;
 if (!fp) return 0;	/* ext nicht gefunden */
 if(!strlen(fp->konverter)) return 0; /* kein Konverter eingetragen */

 /* Tempfilename erzeugen */
 GetEnvironmentVariable("USERPROFILE",Ziel,290);
 strcat(Ziel,"\\csv_view.tmp");
 
 tmpnamgen(Quell,Ziel);
 
 
 /* gibt es die Datei schon? */
 if(!stat(Ziel,&stat2))
  {
  if(!stat(Quell,&stat1))
   {
   if((stat1.st_mtime==stat2.st_mtime)&&(!Testmode)) return 0; /* Zeitstempel gleich */
   }
  }
 
 if(strlen(fp->konfig))
  sprintf(cmdline,"%s \"%s\" \"%s\" \"%s\"",fp->konverter,
					       Quell,
					       fp->konfig,
					       Ziel);
 else
  sprintf(cmdline,"%s \"%s\" \"%s\"",fp->konverter,
					 Quell,
					 Ziel);

 /* Konverter aufrufen */
 if(Testmode) MessageBox(0,cmdline,"Diagnosemeldung-Konverteraufruf",MB_OK);
 system(cmdline); 
 return 0;
 }

int FileOpen(char *name)
 {
 FILE *datei1=0;
 char st1[MAXLINELENGTH],TempFileName[300],*cp,*cp2,Datum1[20],Datum2[20];
 int a,c=0,jahr,monat,tag,stunde,minute,sekunde,Mantisse,Exponent;
 float x,minimum=1E20;
 SCROLLINFO si;
 struct tm *tmBuf,t;
 time_t t1;

 if(datei) 
  {
   FileClose(); /* alte Datei schlieen */
  }

 /* versuchen, passende INI-Datei einzulesen */
 ConfigLoad(name);
 strcpy(TempFileName,name);
 Convert(name,TempFileName);    /* wenn ntig */
 datei1=fopen(TempFileName,"r");
 if(!datei1)
  {
  MessageBox(0,"Datei konnte nicht geffnet werden","Fehler",MB_OK);
  return 0;
  } 
 Endzeit=0;
 Startzeit=0x7fffffff;
 sprintf(Filterstring,"%%d.%%d.%%d%c%%d:%%d:%%lf",SeparatorChar);

 memset(st1,0,MAXLINELENGTH); 
 fgets(st1,MAXLINELENGTH-2,datei1);
 if(cp=strchr(st1,'\n')) *cp=0;  /*Zeilenendezeichen umwandeln*/ 

 /* jetzt die Kopfzeile parsen (wie viele Spalten?) */
 cp=st1;
 if(strncmp(cp,"Datum",5))
  {
  FileClose();
  MessageBox(0,"Datei hat falsches Format (Spalte 1 ungleich Datum)!",name,MB_OK);
  datei=0;
  return 0;
  }
 parse(&cp,0);
 if((!cp)||(strncmp(cp,"Zeit",4)))
  {
  FileClose();
  MessageBox(0,"Datei hat falsches Format (Spalte 2 ungleich Zeit)!",name,MB_OK);
  datei=0;
  return 0;
  }
 do
  {
  parse(&cp,0);
  ColumnCount++;
  }
 while ((cp)&&(strlen(cp)));
 ColumnCount--;
 Spalten=calloc(ColumnCount+2,sizeof(ColRec));
 
 /* Jetzt die Kpfe vorbereiten */
 cp=st1+strlen(st1)+1; /*Das war das Datum*/
 cp=cp+strlen(cp)+1; /*Das war die Uhrzeit*/
 for(a=0;a<ColumnCount;a++)
  {
  char *cp1;
  int farbe,rot,gruen,blau;
  float winkel;
  const float pi   = 3.1418;
  strcpy(Spalten[a].name,cp);
  strcpy(Spalten[a].einheit,DefUnit);
  winkel=2*pi*a/ColumnCount;
  rot=127*(1+sin(winkel));
  gruen=127*(1+sin(winkel+(pi/3*2)));
  blau=127*(1+sin(winkel+2*(pi/3*2)));
  if(rot<0) rot=0;
  if(gruen<0) gruen=0;
  if(blau<0) blau=0;
  Spalten[a].farbe=RGB(rot,gruen,blau);
  Spalten[a].aktiv=Spalten[a].standard=1;
  Spalten[a].stil=PS_SOLID;
  Spalten[a].offset=0;
  if(cp1=strchr(Spalten[a].name,'#'))
   {
   *cp1=0;
   cp1++;
   sscanf(cp1,"%x",&Spalten[a].farbe);
   if(cp1=strchr(cp1,'#'))
    {
    cp1++;
    sscanf(cp1,"%d",&Spalten[a].aktiv);
    Spalten[a].standard=Spalten[a].aktiv;
    if(cp1=strchr(cp1,'#'))
     {
     cp1++;
     cp2=strchr(cp1,'#');
     if(cp2) *cp2=0;
     strcpy(Spalten[a].einheit,cp1);
     if(cp2)
      {
       cp2++;
       cp1=strchr(cp2,'#');
       if(cp1) *cp1=0;
       sscanf(cp2,"%d",&Spalten[a].stil);
       if(cp1)
        {
        cp1++;
        sscanf(cp1,"%lf",&Spalten[a].offset);
        }
      }
     }
    }
   }  
  cp=cp+strlen(cp)+1; /*weiterzhlen*/
  }

 sprintf(st1,"%s - Ingos CSV-Viewer",name);
 SendMessage(g_hWnd,WM_SETTEXT,0,(LPARAM) st1);
 datei=datei1;
 strcpy(WorkFileName,name);

 if(!strcmp(LastFileName,name))
 {
  /* gleiche Datei, wie letztesmal */
 AutoScale(0);
 } 
 else
 {
 AutoScale(1);
 } 
 #ifdef debug
  sprintf(st1,"Scale=%f, Offset=%f\nZeit: %ld - %ld",Scale,offset,Startzeit,Endzeit);
  MessageBox(0,st1,"Debug",MB_OK);
 #endif 
 return 0;
 }



COLORREF TestColor(COLORREF bg)
 {
 int rot,gruen,blau;
 
 rot=(bg&0xff)*1.2;
 gruen=((bg&0xff00)>>8)*1.4;
 blau=((bg&0xff0000)>>16)*1;
 if((rot+gruen+blau)>256)  return 0;
 else return 0xffffff;
 }



int Paint(HANDLE hdc, RECT rcClient,int Width, int LineWidth)
 {
  HPEN *Stifte,penalt,Schwarz,Grau;
  HBRUSH *Hintergr,weiss,brushalt;
  HFONT hfnt,hOldFont;
  LOGFONT lf;
  HRGN hrgn;
  RECT fillrect;
  struct tm t,*pTime;
  double tneu,modul,delta,lasttime,Morgen;
  double t1,raster;
  time_t tt;
  char st1[MAXLINELENGTH],lastline[MAXLINELENGTH],blk,*cp,*cp1,einheit[40];
  int a,x,xneu,xscale,yalt,yneu,alttag,altmonat,
  monat,jahr,mod2,PrintFirstDate=1;
  double d,f,v,ipart,fpart,ystep;
  char horz[40],horz_alt[40],vert[40],date[40],time[40];

  /* Geometrie einstellen */
  Xbase=rcClient.left+10*Width;
  Ybase=rcClient.bottom-17*Width;

  /* Gltigkeitsprfung/Korrektur aller Variablen */
  if((rcClient.bottom-rcClient.top<200)
   ||(rcClient.right-rcClient.left<100)
   ||(!datei)) return 0;

  if(Aktzeit<Startzeit) Aktzeit=Startzeit;   
  f=Endzeit-Startzeit;
  v=rcClient.right-Xbase;
  f=f/v;
  if(Zoom>f) Zoom=f;
  d=Endzeit-(rcClient.right-Xbase)*Zoom;
  if(Aktzeit>d) Aktzeit=d;
  if(Zoom<0.0000001) Zoom=0.0000001;
  if(Scale>=100000000) Scale=100000000;
  if(Scale<0.00125) Scale=0.00125; 
  sprintf(Filterstring,"%%d.%%d.%%d%c%%d:%%d:%%lf",SeparatorChar);

  Stifte=calloc(ColumnCount,sizeof(HPEN));
  Hintergr=calloc(ColumnCount,sizeof(HBRUSH));
  for(a=0;a<ColumnCount;a++)
   {
    if(a==aktstift) Stifte[a]=CreatePen(Spalten[a].stil,3*LineWidth,Spalten[a].farbe);
    else Stifte[a]=CreatePen(Spalten[a].stil,LineWidth,Spalten[a].farbe);
    Hintergr[a]=CreateSolidBrush(Spalten[a].farbe);
   }
   Schwarz=CreatePen(PS_SOLID,LineWidth,0);
   weiss=CreateSolidBrush(RGB(0xff,0xff,0xff));
   Grau=CreatePen(PS_SOLID,LineWidth,0xe0e0e0);
   penalt=(HPEN)SelectObject(hdc,Schwarz);
   brushalt=(HBRUSH)SelectObject(hdc,weiss);
   
   /* Falls Ausdruck: Dateinamen ausgeben */
   if(rcClient.left)
    {
     SetTextColor(hdc,0);
     SetTextAlign(hdc,TA_LEFT);
     ZeroMemory(&lf,sizeof(LOGFONT));
     strcpy(lf.lfFaceName,FontName);
     lf.lfHeight=1.4*Width;
     lf.lfWidth=Width;
     lf.lfWeight=FW_BLACK;
     lf.lfEscapement=0;
     hfnt=CreateFontIndirect(&lf);
     hOldFont=SelectObject(hdc,hfnt);
     TextOut(hdc,(rcClient.left+rcClient.right)/2,rcClient.top-2*Width,WorkFileName,strlen(WorkFileName));     
     SelectObject(hdc,hOldFont);
     DeleteObject(hfnt);
    }
   
   /* Die Palette ausgeben */
   SetTextAlign(hdc,TA_LEFT); 
   xscale=(rcClient.right+10-rcClient.left)/((ColumnCount+1)/2);
   xscale/=2;

   for (a=0;a<ColumnCount;a+=2)
    {
     SetTextColor(hdc,0x0); /* immer schwarze Schrift */

     fillrect.left=rcClient.left+xscale*a;
     fillrect.right=rcClient.left+xscale*(a+2)-1;
     fillrect.top=rcClient.bottom-5.5*Width;
     fillrect.bottom=rcClient.bottom-4.1*Width;

     if(Spalten[a].aktiv) 
      {
      SetTextColor(hdc,TestColor(Spalten[a].farbe));
      SetBkColor(hdc,Spalten[a].farbe);
      FillRect(hdc,&fillrect,Hintergr[a]);
      }
     else 
      {
      SetTextColor(hdc,0x0); /* schwarze Schrift */
      SetBkColor(hdc,0xffffff);
      FillRect(hdc,&fillrect,weiss);
      }
     sprintf(st1," %s ",Spalten[a].name);
     ZeroMemory(&lf,sizeof(LOGFONT));
     strcpy(lf.lfFaceName,FontName);
     lf.lfHeight=1.4*Width;
     lf.lfWidth=Width;
     if(aktstift==a) lf.lfWeight=FW_BLACK;
     else lf.lfWeight=FW_NORMAL;
     lf.lfEscapement=0;
     hfnt=CreateFontIndirect(&lf);
     hOldFont=SelectObject(hdc,hfnt);
     TextOut(hdc,rcClient.left+xscale*a,rcClient.bottom-5.5*Width,st1,strlen(st1));
     SelectObject(hdc,hOldFont);
     DeleteObject(hfnt);

     fillrect.left=rcClient.left+xscale*a;
     fillrect.right=rcClient.left+xscale*(a+2)-1;
     fillrect.top=rcClient.bottom-4.0*Width;
     fillrect.bottom=rcClient.bottom-2.5*Width;

     if(Pairmode)
      {
      if(Spalten[a].aktiv)
       {
	SetTextColor(hdc,TestColor(Spalten[a].farbe));
	SetBkColor(hdc,Spalten[a].farbe);
	FillRect(hdc,&fillrect,Hintergr[a]);
       }
      else
       {
	SetTextColor(hdc,0x0); /* schwarze Schrift */
	SetBkColor(hdc,0xffffff);
	FillRect(hdc,&fillrect,weiss);
       }
      }
      else 
      {
      if(Spalten[a+1].aktiv)
       {
	SetTextColor(hdc,TestColor(Spalten[a+1].farbe));
	SetBkColor(hdc,Spalten[a+1].farbe);
	FillRect(hdc,&fillrect,Hintergr[a+1]);
       }
      else
       {
	SetTextColor(hdc,0x0); /* schwarze Schrift */
	SetBkColor(hdc,0xffffff);
	FillRect(hdc,&fillrect,weiss);
       }
      }

      sprintf(st1," %s ",Spalten[a+1].name);

      ZeroMemory(&lf,sizeof(LOGFONT));
      strcpy(lf.lfFaceName,FontName);
      lf.lfHeight=1.4*Width;
      lf.lfWidth=Width;
      if((aktstift==a+1)|(Pairmode&(aktstift==a))) lf.lfWeight=FW_BLACK;
      else lf.lfWeight=FW_NORMAL;
      lf.lfEscapement=0;
      hfnt=CreateFontIndirect(&lf);
      hOldFont=SelectObject(hdc,hfnt);
      TextOut(hdc,rcClient.left+xscale*a,rcClient.bottom-4*Width,st1,strlen(st1));
      SelectObject(hdc,hOldFont);
      DeleteObject(hfnt);
     }


     SetTextColor(hdc,0x0); /* immer schwarze Schrift */
    /* Haben alle aktiven Kanle die gleiche Einheit? */
    strcpy(einheit,"");
    x=1;
    for(a=0;a<ColumnCount;a++)
     {
     if(Spalten[a].aktiv)
      {
      if(x)
       {
	strcpy(einheit,Spalten[a].einheit); /* erster Eintrag */
	x=0;
       }
      else if(strcmp(einheit,Spalten[a].einheit)) strcpy(einheit,"");
      }
     }

    /* Clipregion vorbereiten */
    hrgn=CreateRectRgn(Xbase,rcClient.top,rcClient.right,Ybase+2);

    /* Die Y-Skala ausgeben */
    ZeroMemory(&lf,sizeof(LOGFONT));
    strcpy(lf.lfFaceName,FontName);
    lf.lfHeight=1.4*Width;
    lf.lfWidth=0.9*Width;
    lf.lfWeight=FW_NORMAL;
    lf.lfEscapement=0;
    hfnt=CreateFontIndirect(&lf);
    hOldFont=SelectObject(hdc,hfnt);
      		
    /* wie viele Skalenstriche wollen wir machen? */
    ystep=Scale*10000;
    a=Ybase-rcClient.top; /* Nutzbare Pixel */

    while (2*Width*ystep>a) ystep/=10;
    if (10*Width*ystep<a) ystep*=5;
    if (4*Width*ystep<a) ystep*=2;

    SelectObject(hdc,Grau); /* zum linien Zeichnen */
    SetBkColor(hdc,0xffffff);
    for(a=0;a<(ystep+1);a++)
     {
      v=Scale*a/ystep;
      if(Pairmode) v*=2;
      if(Scale>60) sprintf(st1,"%7.0lf %s",v+offset,einheit);
      else if (Scale>10) sprintf(st1,"%6.1lf %s",v+offset,einheit);
      else if (Scale>1) sprintf(st1,"%6.2lf %s",v+offset,einheit);
      else sprintf(st1,"%6.4lf %s",v+offset,einheit);
      TextOut(hdc,rcClient.left,Ybase-Width*0.6-((Ybase-rcClient.top)*a/ystep),st1,strlen(st1));
      MoveToEx(hdc,Xbase,Ybase-((Ybase-rcClient.top)*a/ystep),NULL);
      LineTo(hdc,rcClient.right,Ybase-((Ybase-rcClient.top)*a/ystep));
     }

    DeleteObject(hfnt);
    SelectObject(hdc,hOldFont);

    raster=0.00000001;

    if(Zoom*Width/10>0.0000000005) raster=0.00000002;
    if(Zoom*Width/10>0.000000001) raster=0.00000005;
    if(Zoom*Width/10>0.000000002) raster=0.0000001;
    if(Zoom*Width/10>0.000000005) raster=0.0000002;
    if(Zoom*Width/10>0.00000001) raster=0.0000005;
    if(Zoom*Width/10>0.00000002) raster=0.000001;
    if(Zoom*Width/10>0.00000005) raster=0.000002;
    if(Zoom*Width/10>0.0000001) raster=0.000005;
    if(Zoom*Width/10>0.0000002) raster=0.00001;
    if(Zoom*Width/10>0.0000005) raster=0.00002;
    if(Zoom*Width/10>0.000001) raster=0.00005;
    if(Zoom*Width/10>0.000002) raster=0.0001;
    if(Zoom*Width/10>0.000005) raster=0.0002;
    if(Zoom*Width/10>0.00001) raster=0.0005;
    if(Zoom*Width/10>0.00002) raster=0.001;
    if(Zoom*Width/10>0.00005) raster=0.002;
    if(Zoom*Width/10>0.0001) raster=0.005;
    if(Zoom*Width/10>0.0002) raster=0.01;
    if(Zoom*Width/10>0.0005) raster=0.02;
    if(Zoom*Width/10>0.001) raster=0.05;
    if(Zoom*Width/10>0.002) raster=0.1;
    if(Zoom*Width/10>0.005) raster=0.2;
    if(Zoom*Width/10>0.01) raster=0.5;
    if(Zoom*Width/10>0.02) raster=1;
    if(Zoom*Width/10>0.05) raster=2;
    if(Zoom*Width/10>0.1) raster=5;
    if(Zoom*Width/10>0.2) raster=10;
    if(Zoom*Width/10>0.5) raster=30;
    if(Zoom*Width/10>1) raster=60;
    if(Zoom*Width/10>2) raster=120;
    if(Zoom*Width/10>5) raster=300; /* 5 Minuten */
    if(Zoom*Width/10>10) raster=600; /* 10 Minuten */
    if(Zoom*Width/10>20) raster=1200; /* 20 Minuten */
    if(Zoom*Width/10>30) raster=1800; /* 30 Minuten */		
    if(Zoom*Width/10>60) raster=3600; /* 1 Stunde */
    if(Zoom*Width/10>120) raster=7200; /* jede 2. Stunde */
    if(Zoom*Width/10>360) raster=21600; /* 6 Stunden */
    if(Zoom*Width/10>720) raster=43200; /* 12 Stunden */
    if(Zoom*Width/10>1440) raster=86400; /* ein Tag */
    if(Zoom*Width/10>6000) raster=604800; /* eine Woche */
    
    horz_alt[0]=0;
    /* Zeitachse zeichnen */
    alttag=32;			/* gibt es nicht, also neu ausgeben */
    altmonat=13;
    /* Offset Startzeit zum nchsten "glatten" Rasterpunkt */
    delta=raster-raster*modf(Aktzeit/raster,&ipart);
    do
      {
       time_t tt;
       ipart=delta/Zoom+Xbase;
       x=ipart;
       tt=delta+Aktzeit+0.0001;
       fpart=modf(delta+Aktzeit,&ipart);
       pTime=localtime(&tt);
       if(raster<1)
       {
       fpart+=pTime->tm_sec;
       sprintf(horz,"%02d:%02d",pTime->tm_hour,pTime->tm_min);
       sprintf(vert,"%09.6lf",fpart);
       }
       else 
       {
        if(raster<43200)
        {
        sprintf(vert,"%02d:%02d:%02d",pTime->tm_hour,pTime->tm_min,pTime->tm_sec);
        sprintf(horz,"%02d.%02d.%04d",pTime->tm_mday,pTime->tm_mon+1,pTime->tm_year+1900);
        }
        else
        {
        sprintf(vert,"%02d.%02d.",pTime->tm_mday,pTime->tm_mon+1);
        sprintf(horz,"%04d",pTime->tm_year+1900);
        }
       }
	 /* vertikale Beschriftung zeichnen */
      	 HFONT hfnt;
      	 LOGFONT lf;
      	 ZeroMemory(&lf,sizeof(LOGFONT));
      	 strcpy(lf.lfFaceName,FontName);
      	 lf.lfHeight=1.4*Width;
      	 lf.lfWidth=Width;
      	 lf.lfWeight=FW_NORMAL;
      	 lf.lfEscapement=900;
      	 hfnt=CreateFontIndirect(&lf);
      	 hOldFont=SelectObject(hdc,hfnt);
	 SetBkColor(hdc,0xffffff);
	 SetTextColor(hdc,0);
      	 TextOut(hdc,x-Width*0.6,rcClient.bottom-7.5*Width,vert,strlen(vert));
	 SelectObject(hdc,hOldFont);
	 DeleteObject(hfnt);
       	 SelectObject(hdc,Grau);
      	 MoveToEx(hdc,x,Ybase,NULL);
      	 LineTo(hdc,x,rcClient.top);
         if(strcmp(horz,horz_alt))
         {
      	 ZeroMemory(&lf,sizeof(LOGFONT));
      	 strcpy(lf.lfFaceName,FontName);
      	 lf.lfHeight=1.4*Width;
      	 lf.lfWidth=Width;
      	 lf.lfWeight=FW_NORMAL;
      	 lf.lfEscapement=0;
      	 hfnt=CreateFontIndirect(&lf);
      	 hOldFont=SelectObject(hdc,hfnt);
	 SetBkColor(hdc,0xffffff);
	 SetTextColor(hdc,0);
    	 TextOut(hdc,x-Width/2,rcClient.bottom-7*Width,horz,strlen(horz));
	 SelectObject(hdc,hOldFont);
	 DeleteObject(hfnt);
       	 SelectObject(hdc,Schwarz);
       	 if(((pTime->tm_mday > alttag)||(pTime->tm_mon > altmonat))&&(raster<14400))
       	  {
      	   MoveToEx(hdc,x,Ybase,NULL);
      	   LineTo(hdc,x,rcClient.top);
      	  }
      	  alttag=pTime->tm_mday;
      	  strcpy(horz_alt,horz);		  
	 }	 
	alttag=pTime->tm_mday;
	altmonat=pTime->tm_mon;
      	delta=delta+raster;
       } while (x<(rcClient.right-30));


      /* Clipregion zuordnen */
      SelectClipRgn(hdc,hrgn);

      /* Die Kurven Zeichnen */
      SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) "Diagramm wird gezeichnet, bitte warten!");	     
      rewind (datei);
      fgets(st1,MAXLINELENGTH-2,datei); /* Die Kopfzeile haben wir schon */
      st1[0]=0;
      lastline[0]=0;
      t1=0;

      /* bis zur Startposition vorspulen */
      if(Aktzeit)
       do
	{
	 lasttime=t1;			/* Die wird */
	 strcpy(lastline,st1);		/* vielleicht noch gebraucht */
	 memset(st1,0,MAXLINELENGTH);
	 fgets(st1,MAXLINELENGTH-2,datei); /* eine Zeile einlesen */
	 /* Zeitstempel lesen */
	 t1=ReadTime(st1,&cp);
	}
       while ((t1<Aktzeit)&&(!feof(datei)));
       if(!strlen(lastline)) 
	{
	strcpy(lastline,st1); /*war die erste Zeile*/
	lasttime=t1;
	}

       /* vorherigen Datensatz aus der LastLine erfassen */
       ReadTime(lastline,&cp);
       for(a=0;a<ColumnCount;a++)
	{
	 v=parse(&cp,0);
	 blk=InvalidValue;
	 if(Pairmode)
	  {
	   double v2;
	   v2=parse(&cp,0);
	   v=(v+v2)/2;
	   v-=offset/2;
	  }
	 else v-=offset;
         v+=Spalten[a].offset;
	 v=v*(Ybase-rcClient.top)/Scale;
	 Spalten[a].letzter=v;
	 Spalten[a].blk=blk;
	 if(Pairmode) a++;
	}

       /* folgende Datenstze erfassen */
       x=0;
       for(a=0;a<ColumnCount;a++) Spalten[a].akt=0;
       while ((x<rcClient.right)&&(!feof(datei)))
	{
	 if(!feof(datei))
	  {
 	   /* Zeitstempel lesen */
	   tneu=ReadTime(st1,&cp);
       	   x=Xbase+((lasttime-Aktzeit)/Zoom);
      	   xneu=Xbase+((tneu-Aktzeit)/Zoom);
	   for(a=0;a<ColumnCount;a++)
	    {
	     v=parse(&cp,Spalten[a].akt);
	     Spalten[a].akt=v;
	     if(Spalten[a].aktiv)
	      {
	       blk=InvalidValue;
	       if(Pairmode)
		{
		 double v2;
		 v2=parse(&cp,Spalten[a+1].akt);
		 Spalten[a+1].akt=v2;
		 v=(v+v2)/2;
		 v-=offset/2;
		}
	       else v-=offset;
	       v+=Spalten[a].offset;
	       v=v*(Ybase-rcClient.top);
	       v=v/Scale;
       	       SelectObject(hdc,Stifte[a]);
      	       yalt=Spalten[a].letzter;
      	       yneu=v;
      	       if(((x!=xneu)
      		||(yalt!=yneu))
      		&&(!blk)&&(!Spalten[a].blk))
		{
      		 MoveToEx(hdc,x,Ybase-yalt,NULL);
      		 LineTo(hdc,xneu,Ybase-yneu);
      		}
	       Spalten[a].letzter=v;
	       Spalten[a].blk=blk;
	      }
	     else
	      {
	       if(Pairmode)
		{
		 parse(&cp,0);
		}		   
	      }
	      if(Pairmode) a++;
	     }
	    lasttime=tneu;
	   }
	  /* Testen ob inzwischen eine Taste gedrckt wurde */
	  MSG msg;
	  if(PeekMessage(&msg,g_hWnd,
			 WM_KEYFIRST,WM_KEYLAST,
			 PM_REMOVE))
	   {
	   SendMessage(g_hWnd,msg.message,msg.wParam,msg.lParam);
	   if(msg.message==WM_KEYDOWN)
	   x=rcClient.right+1; /* Setzt Abbruchbedingung */
	   }
	 memset(st1,0,MAXLINELENGTH);
	 fgets(st1,MAXLINELENGTH-2,datei); /* nchste Zeile einlesen */
	 }
   /* Prfen, ob die Datei gewachsen ist */
   do
    {
     memset(st1,0,MAXLINELENGTH);
     fgets(st1,MAXLINELENGTH-2,datei); /* eine Zeile einlesen */
     tneu=ReadTime(st1,&cp);
     a=0;
     if(tneu>Endzeit) 
      {
      Endzeit=tneu;
      a=1;
      }
    }  
   while((!feof(datei))&&(a));
 
 SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) "bereit");	     
 SelectObject(hdc,penalt);
 SelectClipRgn(hdc,NULL);
 for(a=0;a<ColumnCount;a++) 
  {
   DeleteObject(Stifte[a]);
   DeleteObject(Hintergr[a]);
  }
 DeleteObject(Schwarz);
 DeleteObject(Grau);
 DeleteObject(weiss);
 free(Stifte);
 free(Hintergr);
 DeleteObject(hrgn); 
 return 0;
 }


int SucheGraph(char *reslt)
 {
  char st1[MAXLINELENGTH],*cp,*cp2,blk,
  st2[50000];
  struct tm *pTime;
  time_t tt;
  int a,monat,jahr,BestCh=-1;
  double v,BestDiff,ActDiff,t1,fractpart,intpart;
  tt=Cursorzeit;	/* ganzzahliger Teil */
  pTime=localtime(&tt);
  fractpart=modf(Cursorzeit,&intpart);
  fractpart+=pTime->tm_sec;
  sprintf(reslt,"Suche nach: %02d.%02d.%04d, %02d:%02d:%09.6lf --> Wert = %lf ...",pTime->tm_mday,
					       pTime->tm_mon+1,
					       pTime->tm_year+1900,
					       pTime->tm_hour,
					       pTime->tm_min,
					       fractpart,
					       CursorValue);
  rewind(datei);
  /* bis zur Startposition vorspulen */
  do
   {
   memset(st1,0,MAXLINELENGTH);
   fgets(st1,MAXLINELENGTH-2,datei); /* eine Zeile einlesen */
   /* Zeitstempel lesen */
   t1=ReadTime(st1,&cp);
   }
  while ((t1<Cursorzeit)&&(!feof(datei)));
  if(feof(datei)) return 0;
	 
  tt=t1;	/* ganzzahliger Teil */
  pTime=localtime(&tt);
  fractpart=modf(t1,&intpart);
  fractpart+=pTime->tm_sec;
  sprintf(st2,"%02d.%02d.%04d %02d:%02d:%09.6lf\r\n"
              "==========================\r\n",pTime->tm_mday,pTime->tm_mon+1,pTime->tm_year+1900,
                                                pTime->tm_hour,pTime->tm_min,fractpart);
  /* Werte einlesen */
  for(a=0;a<ColumnCount;a++)
   {
    v=parse(&cp,0);
    blk=InvalidValue;
    Spalten[a].letzter=v;
    Spalten[a].blk=blk;
   }

  /* Werte auswerten */
  if(Pairmode)
   {
   for(a=0;a<ColumnCount;a+=2)
    {
     if(Spalten[a].aktiv)
      {
       sprintf(st2+strlen(st2),"%-12s %6.2lf %s\r\n",Spalten[a].name,
                                            Spalten[a].letzter,
                                            Spalten[a].einheit);
       sprintf(st2+strlen(st2),"%-12s %6.2lf %s\r\n",Spalten[a+1].name,
                                            Spalten[a+1].letzter,
                                            Spalten[a+1].einheit);
       sprintf(st2+strlen(st2),"     Summe   %6.2lf %s\r\n",
                                            Spalten[a].letzter+Spalten[a+1].letzter,
                                            Spalten[a].einheit);
       ActDiff=fabs(Spalten[a].letzter+Spalten[a+1].letzter-CursorValue);
       if(BestCh<0)
	{
	BestCh=a;
	BestDiff=ActDiff;
	}
       else
	{
	if(ActDiff<BestDiff)
	 {
	 BestCh=a;
	 BestDiff=ActDiff;
	 }
	}
      }
    }
    if(BestCh<0) return 0;	/* nichts gefunden */
    /* Auswertung */
    tt=t1;	/* ganzzahliger Teil */
    fractpart=modf(t1,&intpart);
    pTime=localtime(&tt);
    fractpart+=pTime->tm_sec;
    v=Spalten[BestCh].letzter+Spalten[BestCh+1].letzter;
    sprintf(reslt,"%s + %s %02d.%02d.%04d %02d:%02d:%09.6lf = %lf %s (%lf und %lf)",
	    Spalten[BestCh].name,Spalten[BestCh+1].name,pTime->tm_mday,pTime->tm_mon+1,pTime->tm_year,
	    pTime->tm_hour,pTime->tm_min,fractpart,v,Spalten[BestCh].einheit,Spalten[BestCh].letzter,Spalten[BestCh+1].letzter);
   }
  else
   {
   for(a=0;a<ColumnCount;a++)
    {
     if(Spalten[a].aktiv)
      {
       sprintf(st2+strlen(st2),"%-12s %6.2lf %s\r\n",Spalten[a].name,
                                            Spalten[a].letzter,
                                            Spalten[a].einheit);
       ActDiff=fabs(Spalten[a].letzter-CursorValue);
       if(BestCh<0)
	{
	BestCh=a;
	BestDiff=ActDiff;
	}
       else
	{
	if(ActDiff<BestDiff)
	 {
	 BestCh=a;
	 BestDiff=ActDiff;
	 }
	}
      }
    }
    if(BestCh<0) return 0;	/* nichts gefunden */
    /* Auswertung */
    tt=t1;	/* ganzzahliger Part */
    pTime=localtime(&tt);
    fractpart=fmod(t1,intpart);
    fractpart+=pTime->tm_sec;
    sprintf(reslt,"%s %02d.%02d.%04d %02d:%02d:%09.6lf = %lf %s",
	    Spalten[BestCh].name,pTime->tm_mday,pTime->tm_mon+1,pTime->tm_year+1900,
	    pTime->tm_hour,pTime->tm_min,fractpart,Spalten[BestCh].letzter,Spalten[BestCh].einheit);
   }
  SendMessage(g_hWndDataEdit,WM_SETTEXT,(WPARAM)0,(LPARAM)st2);
  return 0;
 }
 



int APIENTRY WinMain(HINSTANCE hInstance,
			HINSTANCE hPrevInstance,
			LPSTR	lpCmdLine,
			int	nCmdShow)
	{
	char st1[900],*cp;
	ConfigLoad("");
	FILE *datei;
	PFILTER *fpp;
	FILTER *fp;
	g_hInst=hInstance;
	InitCommonControls();
	WNDCLASS WndClass,WndClass1;
	WndClass.style =CS_OWNDC | CS_VREDRAW | CS_HREDRAW| CS_DBLCLKS;
	WndClass.cbClsExtra=0;	
	WndClass.cbWndExtra=0;
	WndClass.lpfnWndProc=WndProc;
	WndClass.hInstance=hInstance;	
	WndClass.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);	
	WndClass.hCursor=LoadCursor(NULL,IDC_ARROW);
	WndClass.hIcon=LoadIcon(hInstance,MAKEINTRESOURCE(IDI_ICON1));
	WndClass.lpszMenuName=MAKEINTRESOURCE(IDM_MENU1);
	WndClass.lpszClassName="WinProg0";
	RegisterClass(&WndClass);

	WndClass1.style =CS_OWNDC | CS_VREDRAW | CS_HREDRAW| CS_DBLCLKS;
	WndClass1.cbClsExtra=0;	
	WndClass1.cbWndExtra=0;
	WndClass1.lpfnWndProc=WndProcData;
	WndClass1.lpszMenuName=0;
	WndClass1.hInstance=hInstance;	
	WndClass1.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);	
	WndClass1.hCursor=LoadCursor(NULL,IDC_ARROW);
	WndClass1.hIcon=LoadIcon(hInstance,MAKEINTRESOURCE(IDI_ICON1));
       	WndClass1.lpszClassName="WinProg1";
	RegisterClass(&WndClass1);
	
	/* CWD puffern */
	GetCurrentDirectory(295,CurrentWorkDir);
	/* Kommandozeile in <int argc, char** argv> zerlegen */
	parseCmdLine(lpCmdLine);

	strcpy(FontName,"courier new");
	strcpy(DefUnit,"Erl");
	/* Versuchen, Filterdatei einzulesen */
	GetEnvironmentVariable("USERPROFILE",st1,290);
	strcat(st1,"\\csv_view.flt");
	datei=fopen(st1,"r");
	fpp=&Filter;
	if(datei)
	 {
	 int a;
	 char *ext,*name,*konverter,*konfig,*cp;
	 while(!feof(datei))
	  {
	  if(fgets(st1,899,datei))
	   {
	   ext=st1;
	   name=strchr(ext,SeparatorChar);
	   if(name)
	    {
	    *name=0;
	    name++;
	    konverter=strchr(name,SeparatorChar);
	    if(konverter)
	     {
	     *konverter=0;
	     konverter++;
	     konfig=strchr(konverter,SeparatorChar);
	     if(konfig)
	      {
	      *konfig=0;
	      konfig++;
	      if(cp=strchr(konfig,'\n')) *cp=0;
			 
	      *fpp=calloc(1,sizeof(FILTER));
	      fp=*fpp;
	      strcpy(fp->ext,ext);
	      strcpy(fp->name,name);
	      strcpy(fp->konverter,konverter);
	      strcpy(fp->konfig,konfig);	      
	      fp->next=NULL;
	      fpp=&(fp->next);
	      }
	     }
	    }
	   }
	  }
	  fclose(datei);
	  }

	/* Hauptfenster erzeugen */
	g_hWnd=CreateWindow("WinProg0","keine Datei - Ingos CSV-Viewer",WS_OVERLAPPEDWINDOW,
				left,top,right-left,bottom-top,NULL,NULL,hInstance,NULL);
	ShowWindow(g_hWnd,nCmdShow);
	UpdateWindow((g_hWnd));

	g_hWndData=CreateWindow("WinProg1","Daten",WS_OVERLAPPEDWINDOW,
				20,20,300,400,NULL,NULL,hInstance,NULL);
	//ShowWindow(g_hWndData,nCmdShow);
	UpdateWindow((g_hWndData));
	SetFocus(g_hWnd);
	
	MSG Message;
	while (GetMessage(&Message,NULL,0,0))
	 {
	 DispatchMessage(&Message);
	 TranslateMessage(&Message);
	 }
	 CleanupTempDir(TempVerfall);
	 return(Message.wParam);	 
      }


LRESULT CALLBACK WndProcData (HWND hWnd, UINT uiMessage,
					WPARAM wParam, LPARAM lParam)
	{
	  switch(uiMessage)
	  {
	   case WM_CREATE:
	    {
	     HINSTANCE hinstance;
	     HFONT hfont;
	     hinstance=(HINSTANCE) GetWindowLongPtr(hWnd,GWL_HINSTANCE);
	     g_hWndDataEdit=CreateWindow("Edit","Edittext",WS_VISIBLE | WS_CHILD|WS_VSCROLL|
	                                                   ES_MULTILINE,
		    0,0,250,250,hWnd,
		    (HMENU) 0,hinstance,NULL);
		    
             hfont=CreateFont(14,10,
                              0,900,FW_REGULAR,
                              FALSE,FALSE,FALSE,
                              DEFAULT_CHARSET,
                              OUT_DEFAULT_PRECIS,
                              CLIP_DEFAULT_PRECIS,
                              DEFAULT_QUALITY,
                              FIXED_PITCH,
                              "courier new");
             SendMessage(g_hWndDataEdit,WM_SETFONT,(WPARAM)hfont,0);
             SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
	    return 0;
	    }
	   case WM_SIZE:
	    {
	     RECT rcClient;
	     GetClientRect(hWnd, &rcClient);
	     MoveWindow(g_hWndDataEdit,0,0,rcClient.right,rcClient.bottom,TRUE);	    
	    return 0;
	    }


           case WM_SYSCOMMAND:
            {
             switch(wParam)
	      {
	      case SC_CLOSE:
	       {
	        ShowWindow(hWnd,0);
	        return 0;
	       }
	      }
             }

	   default:
	     return DefWindowProc (hWnd, uiMessage, wParam, lParam);  
          }
        }

LRESULT CALLBACK WndProc (HWND hWnd, UINT uiMessage,
					WPARAM wParam, LPARAM lParam)
	{
	  switch(uiMessage)
	  {
	   case WM_DESTROY:
	    {
	    char st1[300],*cp;
	    FILE *datei;
	    WINDOWPLACEMENT wp;
	    /* Refreshtimer stoppen */
	    KillTimer(hWnd,2);
	    
	    /* aktive Datei und ini schlieen */
	    FileClose();
	    
	    /* Filterliste speichern */
	    if(Filter)
	    {
	     GetEnvironmentVariable("USERPROFILE",st1,290);
	     strcat(st1,"\\csv_view.flt");
	     datei=fopen(st1,"w");
	     FILTER *fp;
	     fp=Filter;
	     while(fp)
	      {
	      fprintf(datei,"%s;%s;%s;%s\n",fp->ext,fp->name,fp->konverter,fp->konfig);
	      fp=fp->next;
	      }
	     fclose(datei);
	    }
	    PostQuitMessage(0);
	    return 0;
	    }

	   case WM_CREATE:
	    { 
	     char st1[300],*cp,*cp1;
	     HINSTANCE hinstance;
	     
	     g_hWnd=hWnd;
	     /* Refreshtimer erzeugen */
	     SetTimer(hWnd,2,1000,0);

	     /* StatusBar erzeugen */
	     g_hwndStatus = CreateWindowEx( 
			0,		       // no extended styles 
			STATUSCLASSNAME,	 // name of status window class 
			(LPCTSTR) NULL,	  // no text when first created 
			SBARS_SIZEGRIP |	 // includes a sizing grip 
			WS_VISIBLE |
			WS_CHILD,		// creates a child window 
			0, 0, 0, 0,	      // ignores size and position 
			hWnd,	      	      // handle to parent window 
			(HMENU) 0,       // child window identifier 
			g_hInst,		   // handle to application instance 
			NULL);		   // no window creation data 
	      SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) "keine Datei geladen!");

	      hinstance=(HINSTANCE) GetWindowLongPtr(hWnd,GWL_HINSTANCE);

	      g_hWndLeft=CreateWindow("BUTTON","<",WS_VISIBLE | WS_CHILD |BS_BITMAP,
		    10,440, 
		    20,20,
		    hWnd,
		    (HMENU) CM_LEFT,
		    hinstance, 
		    NULL);

	      g_hWndRight=CreateWindow("BUTTON",">",WS_VISIBLE | WS_CHILD|BS_BITMAP ,
		    30,440, 
		    20,20,
		    hWnd,
		    (HMENU) CM_RIGHT,
		    hinstance, 
		    NULL);

	      g_hWndUp=CreateWindow("BUTTON","^",WS_VISIBLE | WS_CHILD|BS_BITMAP ,
		    20,420, 
		    20,20,
		    hWnd,
		    (HMENU) CM_UP,
		    hinstance, 
		    NULL);

	      g_hWndDown=CreateWindow("BUTTON","v",WS_VISIBLE | WS_CHILD|BS_BITMAP ,
		    20,460, 
		    20,20,
		    hWnd,
		    (HMENU) CM_DOWN,
		    hinstance, 
		    NULL);

	      SendMessage(g_hWndLeft,BM_SETIMAGE,IMAGE_BITMAP,
			  (LPARAM) LoadBitmap(hinstance,
					    (LPCTSTR) IDB_LEFT));
	      SendMessage(g_hWndRight,BM_SETIMAGE,IMAGE_BITMAP,
			  (LPARAM) LoadBitmap(hinstance,
					    (LPCTSTR) IDB_RIGHT));
	      SendMessage(g_hWndUp,BM_SETIMAGE,IMAGE_BITMAP,
			  (LPARAM) LoadBitmap(hinstance,
					    (LPCTSTR) IDB_UP));
	      SendMessage(g_hWndDown,BM_SETIMAGE,IMAGE_BITMAP,
			  (LPARAM) LoadBitmap(hinstance,
					    (LPCTSTR) IDB_DOWN));

	      /* Datei in der Kommandozeile angegeben? */
	      if(argc<2) 
	       {
	       ConfigLoad("");
	       return 0;
	       }
	      strcpy(st1,argv[1]);
	      FileOpen(st1);
	      strcat(st1," - Ingos CSV-Viewer");
	      SendMessage(hWnd,WM_SETTEXT,0,(LPARAM) st1);
	     }
	     return 0;

	    case WM_SIZE:
	     {
	     int i,nw,inc,width[10];
	     char puffer[300],*cp;
	     RECT rcClient;
	     GetClientRect(hWnd, &rcClient);
	     //einfach an den StatusBar weitergeben
	     SendMessage(g_hwndStatus,WM_SIZE,wParam,lParam);
	     MoveWindow(g_hWndLeft,10,rcClient.bottom-120,20,20,TRUE);
	     MoveWindow(g_hWndRight,30,rcClient.bottom-120,20,20,TRUE);
	     MoveWindow(g_hWndUp,20,rcClient.bottom-140,20,20,TRUE);
	     MoveWindow(g_hWndDown,20,rcClient.bottom-100,20,20,TRUE);
	     
		strcpy(puffer,GetCommandLine());
		if(cp=strstr(puffer,"/TOTAL"))
		 {		
		  time_t laenge;
		  Aktzeit=Startzeit;
		  laenge=Endzeit-Startzeit;
		  /*Bildschirmgre ermitteln*/
		  Zoom=laenge/(rcClient.right-60);
		  if(Zoom<0.000001) Zoom=0.000001;
		 }

	     }
	     return 0;
	      
	    case WM_PAINT:
	     {
      		PAINTSTRUCT ps;
      		HDC hdc;
      		RECT rcClient;

      		hdc=BeginPaint(hWnd,&ps);
      		if(!datei)
      		 {
      		 EndPaint(hWnd,&ps);
      		 return 0;
      		 }
      		
		GetClientRect(hWnd, &rcClient);
      		rcClient.left+=0;
		rcClient.top+=20;
		rcClient.bottom-=0;
		rcClient.right-=10;
		
		Paint(hdc,rcClient,10,1);
		ReleaseDC(hWnd,hdc);
      		EndPaint(hWnd,&ps);
	     }	
	    return 0;

	    case WM_TIMER:
	     {
	     char st1[300];
	     switch(wParam)
	     {
	     case 1:
	      {
	      KillTimer(hWnd,1);
	      SucheGraph(st1);
	      SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) st1);
	      return 0;
	      }
	     case 2:
	      {
	      if(Refreshtime)
	       {
	       Refreshcounter++;
	       if (Refreshcounter>=Refreshtime)
	        {
	        Refreshcounter=0;
	        SendMessage(hWnd,WM_KEYDOWN,VK_END,0);
	        }
	       }
	      return 0;
	      } 
	     }
	     }
	    case WM_CHAR:
	     {
	     switch (wParam)
	      {
	      case '+':
	       {
		RECT rcClient;
		GetClientRect(hWnd, &rcClient);
		KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
		Center(2);
		return 0;  
	       }

	      case '-':
	       {
		RECT rcClient;
		GetClientRect(hWnd, &rcClient);
		KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
		Center(0.5);
		return 0;  
	       }

	      case 'b':
	       {
		RECT rcClient;
		GetClientRect(hWnd, &rcClient);
		KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
		Center(1.1);
		return 0;  
	       }

	      case 's':
	       {
		RECT rcClient;
		GetClientRect(hWnd, &rcClient);
		KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
		Center(0.9);
		return 0;  
	       }

	      case 'h':
	       {
	       char st1[16],*cp;
	       float neuScale;
	       neuScale=Scale*0.5;
	       if(neuScale<0.05) neuScale=0.05;
	       ViewPush();
	       /* Skala normalisieren */
	       sprintf(st1,"%E",neuScale);
	       if(cp=strchr(st1,'.'))
		{
		cp++;
		while(*cp !='E') 
		 {
		 *cp='0';
		 cp++;
		 }
		}
	       sscanf(st1,"%E",&neuScale);
	       offset=offset*neuScale/Scale;
	       Scale=neuScale;
	       /* Offset normalisieren */
	       sprintf(st1,"%E",offset);
	       if(cp=strchr(st1,'.'))
		{
		cp++;
		while(*cp !='E') 
		 {
		 *cp='0';
		 cp++;
		 }
		}
	      sscanf(st1,"%E",&offset);
	      InvalidateRect(hWnd,0,TRUE);
	      return 0;
	       }
	      case 'n':
	       {
	       char st1[16],*cp;
	       float neuScale;
	       neuScale=Scale*2;
	       ViewPush();
	       /* Skala normalisieren */
	       sprintf(st1,"%E",neuScale);
	       if(cp=strchr(st1,'.'))
		{
		cp++;
		while(*cp !='E') 
		 {
		 *cp='0';
		 cp++;
		 }
		}
	       sscanf(st1,"%E",&neuScale);
	       offset=offset*neuScale/Scale;
	       Scale=neuScale;
	       /* Offset normalisieren */
	       sprintf(st1,"%E",offset);
	       if(cp=strchr(st1,'.'))
		{
		cp++;
		while(*cp !='E') 
		 {
		 *cp='0';
		 cp++;
		 }
		}
	      sscanf(st1,"%E",&offset);
	      InvalidateRect(hWnd,0,TRUE);
	      return 0;
	       }
	      }
	     return 0;
	     }
	    case WM_KEYDOWN:
	     {
	      char st1[40];

	     switch(wParam)
	      {
	      case VK_LEFT:
	       {
	       if(GetKeyState(VK_SHIFT)&0x80000000)
		{
		/* Umchalt-Pfeillinks : zurck */
		ViewPop();
		}
	       else
		{
		RECT rcClient;
		ViewPush();
		GetClientRect(hWnd, &rcClient);
		if((GetKeyState(VK_LCONTROL)&0x80000000)
		  ||(GetKeyState(VK_RCONTROL)&0x80000000)) Aktzeit=Aktzeit-(rcClient.right-80)/1000*Zoom*MouseYscroll;
		else Aktzeit-=(rcClient.right-80)/100*Zoom*MouseYscroll;

		if(Aktzeit<Startzeit) Aktzeit=Startzeit;
		InvalidateRect(hWnd,0,TRUE);	       
		}
	       return 0;
	       }
	      case VK_RIGHT:
	       {
	       RECT rcClient;
	       ViewPush();
	       GetClientRect(hWnd, &rcClient);
	       if((GetKeyState(VK_LCONTROL)&0x80000000)
		  ||(GetKeyState(VK_RCONTROL)&0x80000000)) Aktzeit=Aktzeit+(rcClient.right-80)/1000*Zoom*MouseYscroll;

	       else Aktzeit+=(rcClient.right-80)/100*Zoom*MouseYscroll;
	       if(Aktzeit>Endzeit) Aktzeit=Endzeit;
	       InvalidateRect(hWnd,0,TRUE);	       
	       return 0;
	       }
	      case VK_UP:
	       {
	       ViewPush();
	       offset+=Scale/10;
	       
	       InvalidateRect(hWnd,0,TRUE);	       
	       return 0;
	       }
	      case VK_DOWN:
	       {
	       ViewPush();  
	       offset-=Scale/10;
	       InvalidateRect(hWnd,0,TRUE);	       
	       return 0;
	       }
	      case VK_HOME:
	       {
	       Aktzeit=Startzeit;
	       InvalidateRect(hWnd,0,TRUE);	       
	       return 0;
	       }
	      case VK_END:
	       {
	       int xscale;
	       RECT rcClient;
	       
	       Aktzeit=Endzeit;
	       InvalidateRect(hWnd,0,TRUE);	       
	       return 0;
	       }

	      case VK_F1:	/* Hilfe */
	       {
	       Hilfe();
	       return 0;
	       }
	      }
	     return 0;
	     }
	     
	    case WM_MOUSEWHEEL:
	     {
	     char st1[20];
	     Aktzeit-=(double)GET_WHEEL_DELTA_WPARAM(wParam)*Zoom;
	     if(Aktzeit<Startzeit) Aktzeit=Startzeit;
	     if(Aktzeit>Endzeit) Aktzeit=Endzeit;
	     InvalidateRect(hWnd,0,TRUE);	       
	     return 0;
	     }

	    case WM_MOUSEMOVE:
	     {
	     char st1[100];
	     int x,y;
	     double v,t1,fractpart,intpart;
	     RECT rcClient;
	     time_t tt;
	     struct tm *pTime;
	     
	     if(Timer) KillTimer(hWnd,1);
	     Timer=0;
	     if(!datei)
	      {
	      return 0;
	      }
	     x=LOWORD(lParam);
	     y=HIWORD(lParam);

	     /* Fenstergre ermitteln */
	     GetClientRect(hWnd, &rcClient);
	     if(mark)
	      {
	      /* Markierung erweitern */
	      HDC hdc=GetDC(hWnd);
	      InversRect(hdc,mark,LOWORD(lParam),20,rcClient.bottom-170);
	      mark=LOWORD(lParam);
	      }
	     else
	     if(y>rcClient.bottom-58)
	      {
	       /* Cursor ber der Palette */
	       int xscale;
	       y-=rcClient.bottom;
	       xscale=(rcClient.right-rcClient.left)/((ColumnCount+1)/2);
	       xscale/=2;
	       x/=xscale;
	       x/=2;
	       x*=2;
	       if(y>-42) x++;
	       /* x hat jetzt den gewhlten Kanal! */
	       if(strlen(Spalten[x].einheit))
		sprintf(st1,"%s (%s)",Spalten[x].name,Spalten[x].einheit);
	       else
		sprintf(st1,"%s",Spalten[x].name);
	      }
	     else if(x>=Xbase)
	     {
	      rcClient.bottom-=170; /* + 10 Punkte oberer Rand */
	      t1=Aktzeit+((x-Xbase)*Zoom);
	      tt=t1;		/* Ganzzahliger Anteil */
	      fractpart=modf(t1,&intpart);
	      pTime=localtime(&tt);
              fractpart+=pTime->tm_sec;
	      v=(rcClient.bottom-y)*Scale/(rcClient.bottom-20);
	      if(Pairmode) v*=2;
	      v+=offset;
	      CursorValue=v;
	      Cursorzeit=t1;
	      sprintf(st1,"%02d.%02d.%04d, %02d:%02d:%09.6lf --> Wert = %lf",pTime->tm_mday,
					       pTime->tm_mon+1,
					       pTime->tm_year+1900,
					       pTime->tm_hour,
					       pTime->tm_min,
					       fractpart,
					       v);
	      Timer=SetTimer(hWnd,1,1000,NULL);
	      }
	     SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) st1);
	     }
	     return 0;


            case WM_LBUTTONUP:
             {
             /* Markierung abgeschlossen */
             if(mark)
              {
              char st[100];
              mark2=LOWORD(lParam);
              if(mark1>mark2)
               {
               mark=mark2;
               mark2=mark1;
               mark1=mark;
               }
              mark=0;
              }            
             return 0;
             }

	    case WM_LBUTTONDOWN:
	     {
	     char st1[200];
	     int x,y,xscale;
	     RECT rcClient;
	     x=LOWORD(lParam);
	     y=HIWORD(lParam);
	     GetClientRect(hWnd,&rcClient);

	     if(!datei)
	      {
	      return 0;
	      }
	     if(y>rcClient.bottom-60)
	      {
	       /* in die Palette geklickt*/
	       y-=rcClient.bottom;
	       xscale=(rcClient.right-rcClient.left)/((ColumnCount+1)/2);
	       xscale/=2;
	       x/=xscale;
	       x/=2;
	       x*=2;
	       if((y>-42)&&(!Pairmode)) x++;
	       /* x hat jetzt den gewhlten Kanal! */
	       if(x<ColumnCount)
		{ if(aktstift==x) aktstift=-1;
		  else aktstift=x;
		}
	       InvalidateRect(hWnd,0,TRUE);
	      }
	     else
              {
              /* ins Diagramm geklickt (Markieren beginnen) */
              if(mark2>mark1)		/*gibt es alte Markierung?*/
               {
	       HDC hdc=GetDC(hWnd);
	       InversRect(hdc,mark1,mark2,20,rcClient.bottom-170);
               }
              mark=LOWORD(lParam);	/*aktuelle Marke*/
              mark1=LOWORD(lParam);	/*erste Marke */
              }
	     return 0;
	     }

	    case WM_LBUTTONDBLCLK:
	     {
	     char st1[200];
	     int x,y,xscale;
	     RECT rcClient;
	     x=LOWORD(lParam);
	     y=HIWORD(lParam);
	     GetClientRect(hWnd,&rcClient);

	     if(!datei)
	      {
	      return 0;
	      }
	     if(y>rcClient.bottom-60)
	      {
	       /* Die Palette */
	       y-=rcClient.bottom;
	       xscale=(rcClient.right-rcClient.left)/((ColumnCount+1)/2);
	       xscale/=2;
	       x/=xscale;
	       x/=2;
	       x*=2;
	       if((y>-42)&&(!Pairmode)) x++;
	       /* x hat jetzt den gewhlten Kanal! */
	       if(x<ColumnCount)
	       if(Spalten[x].aktiv) Spalten[x].aktiv=0;
	       else Spalten[x].aktiv=1;
	       InvalidateRect(hWnd,0,TRUE);
	      }
	     else
	     	/* Ins Diagramm gedoppelklickt */
	      {
	       char st1[100];
	       float faktor;
	       y-=rcClient.bottom-170;
	       KlickX=LOWORD(lParam);	/* Die Mauspos brauchen wir noch */
	       
	       faktor=10;		/* Maximale Vergrerung */
	       if(y>-40) faktor=5;
	       if(y>-20) faktor=2;
	       if(y>0) faktor=0.5;	       
	       if(y>20) faktor=0.2;
	       if(y>40) faktor=0.1;
	       Center(faktor);
	      }
	     return 0;
	     }

  	    case WM_CONTEXTMENU:
	     //wParam enthlt das hWnd des Fenster oder Controls!
	     {
	     int a;
	     HMENU hmenu,hmenuTrack;
	     RECT rcWnd,rcClient;
	     KlickX=LOWORD(lParam);	/* Die Mauspos brauchen wir noch */
	     KlickY=HIWORD(lParam);

	     /* das ist Bildschirmkoordinate */
	     GetWindowRect(hWnd,&rcWnd);
	     GetClientRect(hWnd,&rcClient);

	     /* Bildschirmkoordinaten in Fensterkoordinaten umrechnen */
	     KlickX-=rcWnd.left+GetSystemMetrics(SM_CXSIZEFRAME);       /* v Fensterrahmen */
	     KlickY-=rcWnd.top+GetSystemMetrics(SM_CYCAPTION)	   /* Titelleiste */
			      +GetSystemMetrics(SM_CYMENUSIZE)	  /* Menhhe */
			      +GetSystemMetrics(SM_CYSIZEFRAME);	/* h Fensterrahmen */
			      
			      
			      
	     if(KlickY>rcClient.bottom-56)
	      {	     
	       hmenu=LoadMenu(g_hInst,MAKEINTRESOURCE(IDM_MENU3));
	       hmenuTrack = GetSubMenu(hmenu, 0);
	       TrackPopupMenuEx(hmenuTrack,
		       TPM_LEFTBUTTON,
		       LOWORD(lParam),HIWORD(lParam),
		       hWnd,
		       NULL);
	       DestroyMenu(hmenu);	     
	      }
	     else
	      {
	       hmenu=LoadMenu(g_hInst,MAKEINTRESOURCE(IDM_MENU2));
	       hmenuTrack = GetSubMenu(hmenu, 0);
	       TrackPopupMenuEx(hmenuTrack,
		       TPM_LEFTBUTTON,
		       LOWORD(lParam),HIWORD(lParam),
		       hWnd,
		       NULL);
	       DestroyMenu(hmenu);
	      }
	     return 0;
	     }

	   case WM_COMMAND:
	     switch (LOWORD(wParam))
	     {

             case CM_SAVESETTINGS:
              {
		OPENFILENAME ofn;
		char FileName[300],*cp;
		FILE *datei;
		
		ZeroMemory(&ofn,sizeof(ofn));
		ofn.lStructSize=sizeof(ofn);
		strcpy(FileName,IniFileName);
		ofn.hwndOwner=hWnd;
		ofn.lpstrFile=FileName;
		ofn.lpstrInitialDir=CurrentWorkDir;
		ofn.nMaxFile=300;
		ofn.lpstrDefExt=".ini";
		ofn.lpstrTitle="Einstellungen speichern unter";
		ofn.lpstrFilter="Einstellungen\0*.ini\0"
				"alle Dateien\0*.*\0\0";
		     
		if(GetOpenFileName(&ofn))
		 {
                  datei=fopen(FileName,"w");
                  ConfigSaveFile(datei);
		  strcpy(IniFileName,FileName);
		 }
		
              }
             return 0;

             case CM_LOADSETTINGS:
              {
		OPENFILENAME ofn;
		char FileName[300],FilterString[1000],*cp;
		FILE *datei;
		
		ZeroMemory(&ofn,sizeof(ofn));
		ofn.lStructSize=sizeof(ofn);
		strcpy(FileName,IniFileName);
		ofn.hwndOwner=hWnd;
		ofn.lpstrFile=FileName;
		ofn.lpstrInitialDir=CurrentWorkDir;
		ofn.nMaxFile=300;
		ofn.lpstrTitle="Einstellungen laden von";
		ofn.lpstrFilter="Einstellungen\0*.ini\0"
				"alle Dateien\0*.*\0\0";
		ofn.Flags=OFN_FILEMUSTEXIST;
		     
		if(GetOpenFileName(&ofn))
		 {
                  datei=fopen(FileName,"r");
                  ConfigLoadFile(datei);
		  strcpy(IniFileName,FileName);
		  InvalidateRect(hWnd,0,TRUE);
		 }
		
              }
             return 0;

	     case CM_DATEIOEFFNEN:
	      {
		OPENFILENAME ofn;
		FILTER *fp;
		int reslt;
		char FileName[300],FilterString[1000],*cp,CwdSave[300];
		ZeroMemory(&ofn,sizeof(ofn));
		ofn.lStructSize=sizeof(ofn);
		strcpy(FileName,CurrentWorkDir);
		if(Filter)
		 {
		  cp=FilterString;
		  fp=Filter;
		  while(fp)
		  {
		   strcpy(cp,fp->name);
		   cp+=strlen(cp)+1;
		   strcpy(cp,"*.");
		   strcat(cp,fp->ext);
		   cp+=strlen(cp)+1;
		   fp=fp->next;
		  }
		  strcpy(cp,"alle Dateien");
		  cp+=strlen(cp)+1;
		  strcpy(cp,"*.*");
		  cp+=strlen(cp)+1;
		  *cp=0;
		  cp++;
		  *cp=0;		 
		 ofn.lpstrFilter=FilterString;
		 }
		else
		ofn.lpstrFilter="CSV-Dateien\0*.csv\0"
				"Textdateien\0*.txt\0"
				"alle Dateien\0*.*\0\0";
		ofn.hwndOwner=hWnd;
		ofn.lpstrFile=FileName;
		ofn.lpstrInitialDir=CurrentWorkDir;
		ofn.nMaxFile=300;
		ofn.lpstrTitle="Datei zum ffnen whlen!";
		ofn.Flags=OFN_FILEMUSTEXIST;
		strcpy(FileName,"*.*");
		//CWD sichern
		GetCurrentDirectory(290,CwdSave);
		reslt=GetOpenFileName(&ofn);
		SetCurrentDirectory(CwdSave);
		if(reslt)
		 {
		  FileOpen(FileName);
		 }
	       InvalidateRect(hWnd,0,TRUE);
	      }
	      return 0;
	      
	     case CM_KLEINER:
	      {
	      RECT rcClient;
	      GetClientRect(hWnd, &rcClient);
	      KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
	      Center(0.5);
	      return 0;
	      }
	     
	     case CM_GROESSER:
	      {
	      RECT rcClient;
	      GetClientRect(hWnd, &rcClient);
	      KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
	      Center(2);
	      return 0;  
	      }

	     case CM_VGROESSER:
	      {
	      char st1[16],*cp;
	      float neuScale;
	      neuScale=Scale*0.5;
	      if(neuScale<0.05) neuScale=0.05;
	      ViewPush();
	      /* Skala normalisieren */
	      sprintf(st1,"%E",neuScale);
	      if(cp=strchr(st1,'.'))
	       {
	       cp++;
	       while(*cp !='E') 
		{
		*cp='0';
		cp++;
		}
	       }
	      sscanf(st1,"%E",&neuScale);
	      offset=offset*neuScale/Scale;
	      Scale=neuScale;
	      /* Offset normalisieren */
	      sprintf(st1,"%E",offset);
	      if(cp=strchr(st1,'.'))
	       {
	       cp++;
	       while(*cp !='E') 
		{
		*cp='0';
		cp++;
		}
	       }
	      sscanf(st1,"%E",&offset);
	      InvalidateRect(hWnd,0,TRUE);
	      return 0;
	      }
	     
	     case CM_VKLEINER:
	      {
	      char st1[16],*cp;
	      float neuScale;
	      neuScale=Scale*2;
	      ViewPush();
	      sprintf(st1,"%E",neuScale);
	      if(cp=strchr(st1,'.'))
	       {
	       cp++;
	       while(*cp !='E') 
		{
		*cp='0';
		cp++;
		}
	       }
	      sscanf(st1,"%E",&neuScale);
	      offset=offset*neuScale/Scale;
	      Scale=neuScale;
	      /* Offset normalisieren */
	      sprintf(st1,"%E",offset);
	      if(cp=strchr(st1,'.'))
	       {
	       cp++;
	       while(*cp !='E') 
		{
		*cp='0';
		cp++;
		}
	       }
	      sscanf(st1,"%E",&offset);
	      InvalidateRect(hWnd,0,TRUE);
	      return 0;
	      }

	     case CM_LEFT:
	      {
	       RECT rcClient;
	       ViewPush(); /* Ansicht speichern */
	       /* Halben Bildschirm nach rechts scrollen */
	       GetClientRect(hWnd, &rcClient);
	       Aktzeit-=(double)(rcClient.right-80)/100*Zoom*MouseYscroll;
	       if(Aktzeit<Startzeit) Aktzeit=Startzeit;
	       InvalidateRect(hWnd,0,TRUE);
	       SetFocus(hWnd);
	      return 0;
	      }

	     case CM_RIGHT:
	      {
	       RECT rcClient;
	       ViewPush(); /* Ansicht speichern */
	       /* Halben Bildschirm nach links scrollen */
	       GetClientRect(hWnd, &rcClient);
	       Aktzeit+=(double)(rcClient.right-80)/100*Zoom*MouseYscroll;
	       if(Aktzeit>Endzeit) Aktzeit=Endzeit;
	       InvalidateRect(hWnd,0,TRUE);
	       SetFocus(hWnd);
	      return 0;
	      }

	     case CM_UP:
	      {
	       ViewPush(); /* Ansicht speichern */
	       offset+=Scale/100*MouseYscroll;
	       InvalidateRect(hWnd,0,TRUE);
	       SetFocus(hWnd);
	      return 0;
	      }

	     case CM_DOWN:
	      {
	       ViewPush(); /* Ansicht speichern */
	       offset-=Scale/100*MouseYscroll;
	       InvalidateRect(hWnd,0,TRUE);
	       SetFocus(hWnd);
	      return 0;
	      }
	      
	     case CM_TOTAL:
	      {
	       AutoScale(1);
	       return 0;
	      }

	    case CM_ALLON:
	     {
	      int a;
	      for(a=0;a<ColumnCount;a++)
	       {
	       Spalten[a].aktiv=1;
	       }
	      InvalidateRect(hWnd,0,TRUE);
	      return 0;
	     }

	    case CM_ALLOFF:
	     {
	      int a;
	      for(a=0;a<ColumnCount;a++)
	       {
	       Spalten[a].aktiv=0;
	       }
	      InvalidateRect(hWnd,0,TRUE);
	      return 0;
	     }

	    case CM_DEFAULT:
	     {
	      int a;
	      for(a=0;a<ColumnCount;a++)
	       {
	       Spalten[a].aktiv=Spalten[a].standard;
	       }
	      InvalidateRect(hWnd,0,TRUE);
	      return 0;
	     }

	    case CM_EXCLUSIV:
	     {
	     char st1[200];
	     int x,y,xscale;
	     RECT rcClient;
	     x=KlickX;
	     y=KlickY;
	     GetClientRect(hWnd,&rcClient);

	     if(!datei)
	      {
	      return 0;
	      }
	      y-=rcClient.bottom;
	       xscale=(rcClient.right-rcClient.left)/((ColumnCount+1)/2);
	       xscale/=2;
	      x/=xscale;
	      x/=2;
	      x*=2;
	      if((y>-41)&&(!Pairmode)) x++;
	      /* x hat jetzt den gewhlten Kanal! */
	      if(x<ColumnCount)
	       {
	       for(y=0;y<ColumnCount;y++)
		{
		Spalten[y].aktiv=0;
		}
	       Spalten[x].aktiv=1;
	       }
	      InvalidateRect(hWnd,0,TRUE);
	     return 0;
	     }

	    case CM_PROPERTIES:
	     {
	     /* Eigenschaften eines Kanals */
	     char st1[200];
	     int x,y,xscale;
	     RECT rcClient;
	     x=KlickX;
	     y=KlickY;
	     GetClientRect(hWnd,&rcClient);

	     if(!datei)
	      {
	      return 0;
	      }
	      y-=rcClient.bottom;
	       xscale=(rcClient.right-rcClient.left)/((ColumnCount+1)/2);
	       xscale/=2;
	      x/=xscale;
	      x/=2;
	      x*=2;
	      if((y>-42)&&(!Pairmode)) x++;
	      /* x hat jetzt den gewhlten Kanal! */
	      if(x<ColumnCount)
	      DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_DIALOG1),
			      hWnd,(DLGPROC) Dialog1_DlgProc,x);
	      InvalidateRect(hWnd,0,TRUE);
	     }
	     return 0;

	     case CM_MANUAL:
	      {
	      char *cp,st1[300];
	      GetModuleFileName(NULL,st1,290);
	      if(cp=strrchr(st1,'.'))
	       {
	       strcpy(cp,".pdf");
	       ShellExecute(
		0,
		"open",
		st1,
		NULL,
		"",
		SW_RESTORE);
	       }
	      return 0;
	      }

	     case CM_DATEIBEENDEN:
	      {
	       SendMessage(hWnd,WM_DESTROY,0,0);
	       return 0;
	      }
	     
	     case CM_SAVEPALETTE:
	      {
	       OPENFILENAME ofn;
	       char FileName[300];
	       FileName[0]=0;
	       ZeroMemory(&ofn,sizeof(ofn));   	
	       ofn.lStructSize=sizeof(ofn);
	       ofn.hwndOwner=hWnd;
	       ofn.lpstrFile=FileName;
	       ofn.lpstrFilter="CSV-Dateien\0*.csv\0Textdateien\0*.txt\0alle Dateien\0*.*\0\0\0";
	       ofn.lpstrDefExt="csv";
	       ofn.nMaxFile=300;
	       ofn.lpstrTitle="Datei zum Empfangen whlen!";
	       ofn.Flags=0;
	       if(GetSaveFileName(&ofn))
		{
		int a;
		FILE *datei;
		datei=fopen(FileName,"w");
		if(datei)
		 {
		 for(a=0;a<ColumnCount;a++)
		  {
		  fprintf(datei,"%s#%08X#%d#%s#%d#%lf\n",Spalten[a].name,
					     Spalten[a].farbe,
					     Spalten[a].aktiv,
					     Spalten[a].einheit,
					     Spalten[a].stil,
					     Spalten[a].offset);
		  }
		 fclose(datei);
		 }
		}
	      return 0;
	      }  

	     case CM_LIZENZ:
	      {
       	       DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_DIALOG2),
		      hWnd,(DLGPROC) Dialog2_DlgProc,0);
	      return 0;
	      }

             case CM_SHOWDATA:
              {
              if(GetWindowLong(g_hWndData,GWL_STYLE)&WS_VISIBLE)
               ShowWindow(g_hWndData,FALSE);
              else
               ShowWindow(g_hWndData,TRUE);
              return 0;
              }
	     case CM_HELP:
	      {
	      Hilfe();
	      return 0;
	      }
	      
	     case CM_ABOUT:
	      {
	      MessageBox(hWnd,BUILT,"ber csv-Viewer",MB_OK);
	      return 0;
	      } 
	      
	     case CM_SETUP:
	      {
       	       DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_DIALOG3),
		      hWnd,(DLGPROC) Dialog3_DlgProc,0);	      
	      return 0;
	      }
	      
	     case CM_GOTO:
	      {
	       ViewPush(); /* Ansicht speichern */
       	       DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_GOTO),
		      hWnd,(DLGPROC) Dialog4_DlgProc,0);			    
	      return 0;
	      }

	     case CM_CENTER:
	      {
	      Center(1);
	      return 0;
	      }
	      
	     case CM_VCENTER:
	      {
	      Vcenter(1);
	      return 0;
	      } 

	     case CM_BACK:
	      {
	      ViewPop();
	      return 0;
	      } 

	     case CM_FILTER:
	      {
       	       DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_FILTER),
		      hWnd,(DLGPROC) Dialog5_DlgProc,0);
	      return 0;
	      }

	     case IDC_SEITENEINSTELLUNGEN:
	      {
		   DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_PRINTSETTINGS),
		      hWnd,(DLGPROC) PrintSettings_DlgProc,0);
		  return 0;
	      }

	     case CM_DRUCKEN:
	      {
	       DOCINFO di;
	       DEVMODE *dm;
	       HANDLE hdc;
	       PRINTDLG dlg;
	       RECT rcClient,rcScreen;
	       int Rand,LineWidth;
	       char st1[500],*cp;
	       double Zoomalt,Zoomdruck;
	       cp=strrchr(WorkFileName,'\\');
	       strcpy(st1,"Diagramm - ");
	       if(cp) strcat(st1,cp+1);
	       else strcat(st1,WorkFileName);
	       
	       memset(&di,0,sizeof(di));
	       memset(&dlg,0,sizeof(dlg));

	       dlg.lStructSize=sizeof(dlg);
	       dlg.hwndOwner=hWnd;
	       dlg.Flags=PD_RETURNDC;

	       if(PrintDlg(&dlg))
		{
		/* den DC auf Querformat umprogrammieren */
		dm=GlobalLock(dlg.hDevMode);
		dm->dmOrientation=DMORIENT_LANDSCAPE;
		ResetDC(dlg.hDC,dm);
		GlobalUnlock(dlg.hDevMode);

		hdc=dlg.hDC;
		di.cbSize = sizeof(DOCINFO); 
		di.lpszDocName = st1; 
		di.lpszOutput = (LPTSTR) NULL; 
		di.fwType = 0; 
		StartDoc(hdc, &di);	       
		StartPage(hdc);

		Rand=GetDeviceCaps(hdc,HORZRES);
		Rand/=GetDeviceCaps(hdc,HORZSIZE);
		rcClient.left=Rand*BorderLeft;
		rcClient.top=Rand*BorderTop;
		rcClient.bottom=GetDeviceCaps(hdc,VERTRES)-Rand*BorderBottom;
		rcClient.right=GetDeviceCaps(hdc,HORZRES)-Rand*BorderRight;
		Zoomalt=Zoom;
		/* Auflsung des Bildschirms ermitteln */
		GetClientRect(hWnd, &rcScreen);
		/* Zoomfaktor temporr anpassen */
		Zoom=Zoom*(rcScreen.right-rcScreen.left-Xbase)
			 /(rcClient.right-rcClient.left-Xbase);
		if(Zoom<0.0000001) Zoom=0.0000001;
		LineWidth=Zoomalt/Zoom;
//		sprintf(st1,"Zoom=%lf Zoom alt=%lf LineWidth=%d",Zoom,Zoomalt,LineWidth);
//		MessageBox(hWnd,st1,"Drucken",MB_OK);
		Paint(hdc,rcClient,TextSize,LineWidth);
		/* und wieder restaurieren */
		Zoom=Zoomalt;
		EndPage(hdc);
		EndDoc(hdc);
		DeleteDC(hdc);
	        InvalidateRect(hWnd,0,TRUE);
		}
	      return 0;
	      }
	     case CM_MESSEN:
	      {
	      char st1[MAXLINELENGTH],tempfilename[350],*cp;
	      struct tm t,*pTime;
	      time_t tt;
	      int a,jahr,monat,ZeileNr=0;
	      FILE *tempfile;
	      double v,t1,t2,intpart,fractpart;

	      GetModuleFileName(0,tempfilename,340);
	      if (cp=strrchr(tempfilename,'.')) strcpy(cp,"_tmp.txt");
	      tempfile=fopen(tempfilename,"w");

	      /* Uhrzeit der Klickpos errechnen */
	      a=KlickX-Xbase;
	      t2=Aktzeit+(a*Zoom);
	      
	      /* Stelle in der Datei aufsuchen */
	     rewind (datei);
	     fgets(st1,1490,datei); /* Die Kopfzeile haben wir schon */

	     /* bis zur Startposition vorspulen */
		do
		 {
		  memset(st1,0,MAXLINELENGTH);
		  memset(&t,0,sizeof(t));
		  fgets(st1,MAXLINELENGTH-2,datei); /* eine Zeile einlesen */
		  ZeileNr++;
		  /* Zeitstempel lesen */
		  t1=ReadTime(st1,&cp);
		 }
		while ((t1<t2)&&(!feof(datei)));

	      /* Werte auswerten */
	      
	      tt=t2;	/* ganzzahliger Part */
	      fractpart=modf(t2,&intpart);
	      pTime=localtime(&tt);
	      fractpart+=pTime->tm_sec;
	      fprintf(tempfile,"geklickt %02d.%02d.%04d %02d:%02d:%09.6lf\n"
			       ,pTime->tm_mday,
					       pTime->tm_mon+1,
					       pTime->tm_year+1900,
					       pTime->tm_hour,
					       pTime->tm_min,
					       fractpart);
	      tt=t1;	/*ganzzahliger part */
	      pTime=localtime(&tt);
	      fractpart=modf(t1,&intpart);
	      fractpart+=pTime->tm_sec;
	      fprintf(tempfile,"gefunden %02d.%02d.%04d %02d:%02d:%09.6lf\n"
	                       "in Zeile Nr: %d\n"
			       "============================\n",pTime->tm_mday,
					       pTime->tm_mon+1,
					       pTime->tm_year+1900,
					       pTime->tm_hour,
					       pTime->tm_min,
					       fractpart,
					       ZeileNr);
		 for(a=0;a<ColumnCount;a++)
		  {
		    v=parse(&cp,0);
		    if(Spalten[a].aktiv)
		    {
		    fprintf(tempfile,"%s = %lf %s\n",Spalten[a].name,v,Spalten[a].einheit);
		    }
		  }	      
	      fclose(tempfile);
	      ShellExecute(0,"open",tempfilename,NULL,"",SW_RESTORE);
	      return 0;
	      }
	     }
	    return 0;
	   default:
	     return DefWindowProc (hWnd, uiMessage, wParam, lParam);  
	  }
	}


DLGPROC Dialog1_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam)
   {
   static int Spalte;
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
       char st1[20];
       Spalte=lParam;
       sprintf(st1,"%08X",Spalten[Spalte].farbe);
       SendMessage(hWnd,WM_SETICON,ICON_BIG,(LPARAM)LoadIcon(g_hInst,MAKEINTRESOURCE(IDI_ICON1)));
       SendMessage(hWnd,WM_SETTEXT,0,(LPARAM) Spalten[Spalte].name);
       SendMessage(GetDlgItem(hWnd,IDC_EDIT1),WM_SETTEXT,0,(LPARAM) Spalten[Spalte].name);
       SendMessage(GetDlgItem(hWnd,IDC_UNIT),WM_SETTEXT,0,(LPARAM) Spalten[Spalte].einheit);
       SendMessage(GetDlgItem(hWnd,IDC_COLOR),WM_SETTEXT,0,(LPARAM) st1);
       sprintf(st1,"%lf",Spalten[Spalte].offset);
       SendMessage(GetDlgItem(hWnd,IDC_OFFSET),WM_SETTEXT,0,(LPARAM) st1);       
       if(Spalten[Spalte].aktiv) SendMessage(GetDlgItem(hWnd,IDC_VISIBLE),BM_SETCHECK,BST_CHECKED,0);
       else SendMessage(GetDlgItem(hWnd,IDC_VISIBLE),BM_SETCHECK,BST_UNCHECKED,0);
       if(Pairmode) SendMessage(GetDlgItem(hWnd,IDC_PAIRMODE),BM_SETCHECK,BST_CHECKED,0);
       else SendMessage(GetDlgItem(hWnd,IDC_PAIRMODE),BM_SETCHECK,BST_UNCHECKED,0);

       SetWindowLong(GetDlgItem(hWnd,IDC_COLORSEL),GWL_STYLE,WS_VISIBLE | WS_CHILD|BS_BITMAP);
       SendMessage(GetDlgItem(hWnd,IDC_COLORSEL),BM_SETIMAGE,IMAGE_BITMAP,
			  (LPARAM) LoadBitmap((HINSTANCE) GetWindowLongPtr(hWnd, GWL_HINSTANCE),
					    (LPCTSTR) IDB_COLOR));
       switch(Spalten[Spalte].stil)
	{

	case PS_DASH:
	 {
	 SendMessage(GetDlgItem(hWnd,IDC_DASH),BM_SETCHECK,BST_CHECKED,0);
	 break;
	 }

	case PS_DOT:
	 {
	 SendMessage(GetDlgItem(hWnd,IDC_DOT),BM_SETCHECK,BST_CHECKED,0);
	 break;
	 }

	case PS_DASHDOT:
	 {
	 SendMessage(GetDlgItem(hWnd,IDC_DASHDOT),BM_SETCHECK,BST_CHECKED,0);
	 break;
	 }

	case PS_DASHDOTDOT:
	 {
	 SendMessage(GetDlgItem(hWnd,IDC_DASHDOTDOT),BM_SETCHECK,BST_CHECKED,0);
	 break;
	 }

	default: SendMessage(GetDlgItem(hWnd,IDC_SOLID),BM_SETCHECK,BST_CHECKED,0);
	}

      }
      break;
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDC_OK:
	{
	 char st1[100];
	 /* Eingegebene Werte speichern */

	 SendMessage(GetDlgItem(hWnd,IDC_EDIT1),WM_GETTEXT,20,(LPARAM) Spalten[Spalte].name);
	 SendMessage(GetDlgItem(hWnd,IDC_UNIT),WM_GETTEXT,20,(LPARAM) Spalten[Spalte].einheit);
	 if(SendMessage(GetDlgItem(hWnd,IDC_VISIBLE),BM_GETCHECK,0,0)==BST_CHECKED)
	  Spalten[Spalte].aktiv=1;
	 else
	  Spalten[Spalte].aktiv=0;
	 if(SendMessage(GetDlgItem(hWnd,IDC_PAIRMODE),BM_GETCHECK,0,0)==BST_CHECKED)
	  Pairmode=1;
	 else
	  Pairmode=0;
	 SendMessage(GetDlgItem(hWnd,IDC_COLOR),WM_GETTEXT,20,(LPARAM) st1);
	 sscanf(st1,"%x",&Spalten[Spalte].farbe);
	 SendMessage(GetDlgItem(hWnd,IDC_OFFSET),WM_GETTEXT,20,(LPARAM) st1);
	 sscanf(st1,"%lf",&Spalten[Spalte].offset);
	 Spalten[Spalte].stil=PS_SOLID;
	 if(SendMessage(GetDlgItem(hWnd,IDC_DASH),BM_GETCHECK,0,0)==BST_CHECKED) Spalten[Spalte].stil=PS_DASH;
	 if(SendMessage(GetDlgItem(hWnd,IDC_DOT),BM_GETCHECK,0,0)==BST_CHECKED) Spalten[Spalte].stil=PS_DOT;
	 if(SendMessage(GetDlgItem(hWnd,IDC_DASHDOT),BM_GETCHECK,0,0)==BST_CHECKED) Spalten[Spalte].stil=PS_DASHDOT;
	 if(SendMessage(GetDlgItem(hWnd,IDC_DASHDOTDOT),BM_GETCHECK,0,0)==BST_CHECKED) Spalten[Spalte].stil=PS_DASHDOTDOT;
	 EndDialog(hWnd,1);
	}
	break;
	
       case IDC_COLORSEL:
	{
	char st1[20];
	CHOOSECOLOR chk;
	COLORREF cc[16];
	ZeroMemory(&chk,sizeof(chk));
	SendMessage(GetDlgItem(hWnd,IDC_COLOR),WM_GETTEXT,19,(LPARAM) st1);
	sscanf(st1,"%x",&chk.rgbResult);
	chk.lStructSize=sizeof(chk);
	chk.hwndOwner=hWnd;
	chk.lpCustColors=cc;
	chk.Flags=CC_RGBINIT;
	if(ChooseColor(&chk))
	 {
	  sprintf(st1,"%08X",chk.rgbResult);
	  SendMessage(GetDlgItem(hWnd,IDC_COLOR),WM_SETTEXT,0,(LPARAM) st1);
	 }
	}
	break;
       
       case IDC_OTHERSOFF:
	{
	int a;
	for(a=0;a<ColumnCount;a++)
	 {
	 if(a!=Spalte) Spalten[a].aktiv=0;
	 }
	SendMessage(GetDlgItem(hWnd,IDC_VISIBLE),BM_SETCHECK,BST_CHECKED,0); 
	}
	break;
		
       }  
      }
     break;
     case WM_SYSCOMMAND:
      {
       switch(wParam)
	{
	 case SC_CLOSE:
	 {
	 EndDialog(hWnd,0);
	 }
	 break;
	}
      }
      break;  
     }
   return FALSE; 
   }


DLGPROC Dialog2_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam)
   {
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
      char st1[65536],*cp,*cp1;
      FILE *datei;
      SendMessage(hWnd,WM_SETTEXT,0,(LPARAM) "Lizenzinformationen");
      GetModuleFileName(0,st1,290);
      cp=strrchr(st1,'\\');     /* wollen nur das Verzeichnis */
      if(cp) strcpy(cp,"\\gpl.txt");
      datei=fopen(st1,"rb");
      if(datei)
      {
      cp=st1;
      while(!feof(datei))
       {
       fgets(cp,200,datei);
       if(cp1=strchr(cp,13)) *cp1=0;
       strcat(cp,"\r\n");
       cp+=strlen(cp);
       }
      fclose(datei);
      cp=st1;
      }
      SendMessage(GetDlgItem(hWnd,IDC_DLG2_EDIT),WM_SETTEXT,0,(LPARAM) st1);
      }
      break;
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDC_DLG2_OK:
	{
	 EndDialog(hWnd,1);
	}
	break;
       }
      }
     break;
     case WM_SYSCOMMAND:
      {
       switch(wParam)
	{
	 case SC_CLOSE:
	 {
	 EndDialog(hWnd,0);
	 }
	 break;
	}
      }
      break;  
     }
   return FALSE; 
   }

DLGPROC Dialog3_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam)
   {
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
      char st1[200];
      sprintf(st1,"%d",littlestep);
      SendMessage(GetDlgItem(hWnd,IDC_LITTLESTEP),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",bigstep);
      SendMessage(GetDlgItem(hWnd,IDC_BIGSTEP),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%lf",Zoom);
      SendMessage(GetDlgItem(hWnd,IDC_HZOOM),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%f",Scale);
      SendMessage(GetDlgItem(hWnd,IDC_VZOOM),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%f",offset);
      SendMessage(GetDlgItem(hWnd,IDC_OFFSET),WM_SETTEXT,0,(LPARAM) st1);
      SendMessage(GetDlgItem(hWnd,IDC_FONT),WM_SETTEXT,0,(LPARAM) FontName);
      SendMessage(GetDlgItem(hWnd,IDC_DEFUNIT),WM_SETTEXT,0,(LPARAM) DefUnit);
      sprintf(st1,"%d",MouseXscroll);
      SendMessage(GetDlgItem(hWnd,IDC_MOUSEXSCROLL),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",MouseYscroll);
      SendMessage(GetDlgItem(hWnd,IDC_MOUSEYSCROLL),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",SeparatorChar);
      SendMessage(GetDlgItem(hWnd,IDC_SEPARATOR),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",Refreshtime);
      SendMessage(GetDlgItem(hWnd,IDC_REFRESHTIME),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",TempVerfall);
      SendMessage(GetDlgItem(hWnd,IDC_TEMPAGE),WM_SETTEXT,0,(LPARAM) st1);
      SetFocus(GetDlgItem(hWnd,IDOK));
      }
      break;
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDOK:
	{
	 char st1[200];
	 SendMessage(GetDlgItem(hWnd,IDC_LITTLESTEP),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%d",&littlestep);
	 SendMessage(GetDlgItem(hWnd,IDC_BIGSTEP),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%d",&bigstep);
	 SendMessage(GetDlgItem(hWnd,IDC_HZOOM),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%lf",&Zoom);	
	 SendMessage(GetDlgItem(hWnd,IDC_VZOOM),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%f",&Scale);	
	 SendMessage(GetDlgItem(hWnd,IDC_OFFSET),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%f",&offset);	
	 SendMessage(GetDlgItem(hWnd,IDC_FONT),WM_GETTEXT,190,(LPARAM) FontName);
	 SendMessage(GetDlgItem(hWnd,IDC_DEFUNIT),WM_GETTEXT,190,(LPARAM) DefUnit);
	 SendMessage(GetDlgItem(hWnd,IDC_MOUSEXSCROLL),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%d",&MouseXscroll);
	 SendMessage(GetDlgItem(hWnd,IDC_MOUSEYSCROLL),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%d",&MouseYscroll);
	 SendMessage(GetDlgItem(hWnd,IDC_SEPARATOR),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%d",&SeparatorChar);
	 SendMessage(GetDlgItem(hWnd,IDC_REFRESHTIME),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%d",&Refreshtime);
	 SendMessage(GetDlgItem(hWnd,IDC_TEMPAGE),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%d",&TempVerfall);
	 if(Zoom<0.0000001) Zoom=0.0000001;
	 InvalidateRect(g_hWnd,0,TRUE);
	 EndDialog(hWnd,1);
	}
	break;
       case IDC_SELFONT:
	{
	 CHOOSEFONT font;
	 LOGFONT lf;
	 SendMessage(GetDlgItem(hWnd,IDC_FONT),WM_GETTEXT,190,(LPARAM) lf.lfFaceName);
	 lf.lfHeight=15;
	 lf.lfWidth=10;
	 lf.lfWeight=FW_NORMAL;
	 
	 memset(&font,0,sizeof(font));
	 memset(&lf,0,sizeof(lf));
	 font.lStructSize=sizeof(font);
	 font.lpLogFont=&lf;
	 font.nSizeMin=1;
	 font.nSizeMax=50;
	 font.hwndOwner=hWnd;
	 font.Flags=CF_BOTH|CF_TTONLY;
	 
	 if(ChooseFont(&font))
	  {	
	   SendMessage(GetDlgItem(hWnd,IDC_FONT),WM_SETTEXT,0,(LPARAM) lf.lfFaceName);
	  }
	return 0;
	}
       }  
      }
     break;
     case WM_SYSCOMMAND:
      {
       switch(wParam)
	{
	 case SC_CLOSE:
	 {
	 EndDialog(hWnd,0);
	 }
	 break;
	}
      }
      break;  
     }
   return FALSE; 
   }


DLGPROC Dialog4_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam)
   {
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
      char st1[200];
      struct tm *tmBuf;
      time_t tt;
      tt=Aktzeit;      
      tmBuf=localtime(&tt);
      sprintf(st1,"%02d.%02d.%04d",
		tmBuf->tm_mday,tmBuf->tm_mon+1,tmBuf->tm_year+1900);
      SendMessage(GetDlgItem(hWnd,IDC_DATE),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%02d:%02d:%02d",
		tmBuf->tm_hour,tmBuf->tm_min,tmBuf->tm_sec);
      SendMessage(GetDlgItem(hWnd,IDC_TIME),WM_SETTEXT,0,(LPARAM) st1);
      SetFocus(GetDlgItem(hWnd,IDOK));
      }
      break;
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDOK:
	{
	 int monat,jahr;
	 char st1[200];
	 struct tm t;
	 time_t t1;
	 memset(&t,0,sizeof(t));
	 SendMessage(GetDlgItem(hWnd,IDC_DATE),WM_GETTEXT,190,(LPARAM) st1);
		  sscanf(st1,"%d.%d.%d",&t.tm_mday,&monat,&jahr);

	 SendMessage(GetDlgItem(hWnd,IDC_TIME),WM_GETTEXT,190,(LPARAM) st1);
	 sscanf(st1,"%d:%d:%d",&t.tm_hour,&t.tm_min,&t.tm_sec);
	 t.tm_mon=monat-1;
	 t.tm_year=jahr-1900;
	 t.tm_isdst=-1;
	 t1=mktime(&t);
	 if((t1<Startzeit)||(t1>Endzeit))
	  {
	  MessageBox(hWnd,"Uhrzeit nicht innerhalb der Aufzeichnung!","Fehler",MB_OK);
	  return 0;
	  }
	 Aktzeit=t1;
	 InvalidateRect(g_hWnd,0,TRUE);
	 EndDialog(hWnd,1);
	}
	break;			
       }  
      }
     break;
     case WM_SYSCOMMAND:
      {
       switch(wParam)
	{
	 case SC_CLOSE:
	 {
	 EndDialog(hWnd,0);
	 }
	 break;
	}
      }
      break;  
     }
   return FALSE; 
   }

DLGPROC Dialog5_DlgProc(HWND hWnd,
		    UINT wMsg,
		    WPARAM wParam,
		    LPARAM lParam)
   {
   static int ActItem=-1,Modify=0;
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
       int a;
       char st1[300];
       /* Das ListView erzeugen */
	LV_COLUMN lvc;
	LV_ITEM lvitem;
	FILTER *fp;

	if(Testmode) SendMessage(GetDlgItem(hWnd,IDC_TESTMODE),BM_SETCHECK,BST_CHECKED,0);
	else SendMessage(GetDlgItem(hWnd,IDC_TESTMODE),BM_SETCHECK,BST_UNCHECKED,0);
	g_hWndLv=CreateWindowEx(0,WC_LISTVIEW,"", 
			       WS_CHILD|WS_VISIBLE|WS_BORDER|WS_VSCROLL
			       |WS_HSCROLL|LVS_REPORT|WS_TABSTOP
			       |LVS_SHOWSELALWAYS, 
			       5,5,530,150, 
			       hWnd,(HMENU) IDC_LISTVIEW,
			       g_hInst,NULL);       

	ListView_SetExtendedListViewStyle(g_hWndLv, LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
	
	//Die Columnen erzeugen      
	lvc.mask=LVCF_TEXT| LVCF_WIDTH| LVCF_SUBITEM;
	lvc.fmt=LVCFMT_LEFT;
	lvc.cx=40;
	lvc.cchTextMax=40;
	lvc.iSubItem=0;
	lvc.pszText="Erweiterung";
	ListView_InsertColumn(g_hWndLv,0,&lvc);
	//Die zweite Spalte erzeugen
	lvc.iSubItem=1;
	lvc.cx=160;
	lvc.cchTextMax=160;
	lvc.pszText="Name";
	ListView_InsertColumn(g_hWndLv,1,&lvc);
	//Die dritte Spalte erzeugen
	lvc.iSubItem=2;
	lvc.cx=160;
	lvc.cchTextMax=160;
	lvc.pszText="Konverter";
	ListView_InsertColumn(g_hWndLv,2,&lvc);
	//Die vierte Spalte erzeugen
	lvc.iSubItem=3;
	lvc.cx=160;
	lvc.cchTextMax=160;
	lvc.pszText="Konfig";
	ListView_InsertColumn(g_hWndLv,3,&lvc);
	
	a=0;
	fp=Filter;
	while(fp)
	 {
	  lvitem.mask=LVIF_TEXT;
	  lvitem.iItem=a+1;
	  lvitem.state=0;
	  lvitem.pszText=fp->ext;
	  lvitem.cchTextMax=20;
	  lvitem.lParam=0;
	  lvitem.iSubItem=0;
	  ListView_InsertItem(g_hWndLv, &lvitem);
	  ListView_SetItemText(g_hWndLv,a,1,fp->name);
	  ListView_SetItemText(g_hWndLv,a,2,fp->konverter);
	  ListView_SetItemText(g_hWndLv,a,3,fp->konfig);
	  fp=fp->next;
	  a++;
	 }
	
      SetFocus(GetDlgItem(hWnd,IDOK));
      }
      break;
      
     case WM_NOTIFY:
      {
      switch(wParam)
       {
       case IDC_LISTVIEW:
	{
	NM_LISTVIEW *lv=(NM_LISTVIEW*)lParam;
	
	if(lv->hdr.code==LVN_ITEMCHANGED)
	 {
	 char st1[400];
	 if(Modify) return 0;
	 if((lv->uChanged & LVIF_STATE)
	  &&(lv->uNewState & LVIS_SELECTED)) /* neue Selektion */
	  ActItem=lv->iItem;
	  ListView_GetItemText(g_hWndLv,lv->iItem,0,st1,390);
	  SendMessage(GetDlgItem(hWnd,IDC_EXTENSION),WM_SETTEXT,0,(LPARAM) st1);
	  ListView_GetItemText(g_hWndLv,lv->iItem,1,st1,390);
	  SendMessage(GetDlgItem(hWnd,IDC_NAME),WM_SETTEXT,0,(LPARAM) st1);
	  ListView_GetItemText(g_hWndLv,lv->iItem,2,st1,390);
	  SendMessage(GetDlgItem(hWnd,IDC_KONVERTER),WM_SETTEXT,0,(LPARAM) st1);
	  ListView_GetItemText(g_hWndLv,lv->iItem,3,st1,390);
	  SendMessage(GetDlgItem(hWnd,IDC_KONFIG),WM_SETTEXT,0,(LPARAM) st1);
	 }
	return 0;
	}
       }
      return 0;
      }
      
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDOK:
	{
	 char st1[300];
	 /* alte Struktur abrumen */
	 PFILTER *fpp;
	 FILTER *fp;
	 int a,c;
	 FiltClear();
	 c=ListView_GetItemCount(g_hWndLv);
	 fpp=&Filter;
	 for(a=0;a<c;a++)
	  {
	  *fpp=calloc(1,sizeof(FILTER));
	  fp=*fpp;
	  ListView_GetItemText(g_hWndLv,a,0,fp->ext,19);
	  ListView_GetItemText(g_hWndLv,a,1,fp->name,29);
	  ListView_GetItemText(g_hWndLv,a,2,fp->konverter,299);
	  ListView_GetItemText(g_hWndLv,a,3,fp->konfig,299);
	  fp->next=NULL;
	  fpp=&(fp->next);
	  }	 
	  if(SendMessage(GetDlgItem(hWnd,IDC_TESTMODE),BM_GETCHECK,0,0)==BST_CHECKED)
	   Testmode=1;
	  else
	   Testmode=0;
	 EndDialog(hWnd,1);
	 return 0;
	}
	
       case IDC_DEL:
	{
	if(ActItem<0) return 0;
	ListView_DeleteItem(g_hWndLv,ActItem);
	/* das, jetzt hochgerutschte, Item markieren */	
	ListView_SetItemState(g_hWndLv,ActItem,LVIS_SELECTED,LVIS_SELECTED);
	return 0;
	}
	
       case IDC_SELKONVERT:
	{
	 OPENFILENAME ofn;
	 char FileName[300];
	 SendMessage(GetDlgItem(hWnd,IDC_KONVERTER),WM_GETTEXT,290,(LPARAM) FileName);
	 ZeroMemory(&ofn,sizeof(ofn));
	 ofn.lStructSize=sizeof(ofn);
	 ofn.lpstrFilter="Programme\0*.exe\0"
			 "Batchdateien\0*.bat\0"
			 "alle Dateien\0*.*\0";
	 ofn.hwndOwner=hWnd;
	 ofn.lpstrFile=FileName;
	 ofn.nMaxFile=300;
	 ofn.lpstrTitle="Konverter Programm whlen!";
	 ofn.Flags=OFN_FILEMUSTEXIST;
		     
	 if(GetOpenFileName(&ofn))
	   {
	    SendMessage(GetDlgItem(hWnd,IDC_KONVERTER),WM_SETTEXT,0,(LPARAM) FileName);
	   }
	return 0;
	}
	
       case IDC_SELKONFIG:
	{
	 OPENFILENAME ofn;
	 char FileName[300];
	 SendMessage(GetDlgItem(hWnd,IDC_KONFIG),WM_GETTEXT,290,(LPARAM) FileName);
	 ZeroMemory(&ofn,sizeof(ofn));
	 ofn.lStructSize=sizeof(ofn);
	 ofn.lpstrFilter="Textdateien\0*.txt\0"
			 "CSV-Dateien\0*.csv\0"
			 "alle Dateien\0*.*\0";
	 ofn.hwndOwner=hWnd;
	 ofn.lpstrFile=FileName;
	 ofn.nMaxFile=300;
	 ofn.lpstrTitle="Konfig Datei whlen!";
	 ofn.Flags=OFN_FILEMUSTEXIST;
		     
	 if(GetOpenFileName(&ofn))
	   {
	    SendMessage(GetDlgItem(hWnd,IDC_KONFIG),WM_SETTEXT,0,(LPARAM) FileName);
	   }
	return 0;
	}
	
       case IDC_ADD:
	{
	char st1[400];
	LV_ITEM lvitem;
	strcpy(st1,"");
	lvitem.mask=LVIF_TEXT;
	if(ActItem<0) ActItem=ListView_GetItemCount(g_hWndLv);
	lvitem.iItem=ActItem;
	lvitem.state=0;
	lvitem.pszText=st1;
	lvitem.cchTextMax=20;
	lvitem.lParam=0;
	lvitem.iSubItem=0;
	ListView_InsertItem(g_hWndLv, &lvitem);
	Modify=1;
	SendMessage(GetDlgItem(hWnd,IDC_EXTENSION),WM_GETTEXT,390,(LPARAM) st1);
	ListView_SetItemText(g_hWndLv,ActItem,0,st1);
	SendMessage(GetDlgItem(hWnd,IDC_NAME),WM_GETTEXT,390,(LPARAM) st1);
	ListView_SetItemText(g_hWndLv,ActItem,1,st1);
	SendMessage(GetDlgItem(hWnd,IDC_KONVERTER),WM_GETTEXT,390,(LPARAM) st1);
	ListView_SetItemText(g_hWndLv,ActItem,2,st1);
	SendMessage(GetDlgItem(hWnd,IDC_KONFIG),WM_GETTEXT,390,(LPARAM) st1);
	ListView_SetItemText(g_hWndLv,ActItem,3,st1);
	Modify=0;

	return 0;
	}
       case IDC_MODIFY:
	{
	char st1[400];
	if(ActItem<0) return 0;
	Modify=1;
	SendMessage(GetDlgItem(hWnd,IDC_EXTENSION),WM_GETTEXT,390,(LPARAM) st1);
	ListView_SetItemText(g_hWndLv,ActItem,0,st1);
	SendMessage(GetDlgItem(hWnd,IDC_NAME),WM_GETTEXT,390,(LPARAM) st1);
	ListView_SetItemText(g_hWndLv,ActItem,1,st1);
	SendMessage(GetDlgItem(hWnd,IDC_KONVERTER),WM_GETTEXT,390,(LPARAM) st1);
	ListView_SetItemText(g_hWndLv,ActItem,2,st1);
	SendMessage(GetDlgItem(hWnd,IDC_KONFIG),WM_GETTEXT,390,(LPARAM) st1);
	ListView_SetItemText(g_hWndLv,ActItem,3,st1);
	Modify=0;
	return 0;
	}
       case IDCANCEL:
	{
	EndDialog(hWnd,0);
	return 0;
	}
       }
      return 0;
      }

     case WM_SYSCOMMAND:
      {
       switch(wParam)
	{
	 case SC_CLOSE:
	 {
	 EndDialog(hWnd,0);
	 }
	 break;
	}
      }
      break;  
     }
   return FALSE; 
   }
