/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:
 known Problems: none
 Version:        03.11.2007
 Description:    Webserver Config-File

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der
 GNU General Public License, wie von der Free Software Foundation verffentlicht,
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder
 (nach Ihrer Option) jeder spteren Version.

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 Programm erhalten haben.
 Falls nicht, schreiben Sie an die Free Software Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*---------------------------------------------------------------------------
* History:
* 06.02.2012 - Build 04 : -> communication watchdog and reconnecet included
* 05.02.2012 - Build 03 : -> time conversion included
* 04.02.2012 - Build 02 : -> RS232 communication established
* 03.02.2012 - Build 01 : -> initial build
*---------------------------------------------------------------------------
* MARKUS KOTSCHENREUTHER
*-------------------------------------------------------------------------*/

#ifndef _CONFIG_H_
	#define _CONFIG_H_

	//********************
	#define BUILD	4
	//********************

	//Webserver mit Passwort? (0 == mit Passwort)
	#define HTTP_AUTH_DEFAULT	1
	//fr Username:Passwort
	#define HTTP_AUTH_STRING "test:test"

	//Debug level
	// 0 - OFF
	// 1 - lowest
	#define DEBUG_LEVEL		0

	//Baudrate der seriellen Schnittstelle
	#define BAUDRATE 9600UL

    //Watchdog timer for the ENC2860, resets the stack if timeout occurs
    #define WTT 1200 //Watchdog timer in timer interrupt

	//Umrechnung von IP zu unsigned long
	#define IP(a,b,c,d) ((unsigned long)(d)<<24)+((unsigned long)(c)<<16)+((unsigned long)(b)<<8)+a

	//IP / MAC
	#define MYIP	IP(192,168,0,99)
	#define MYMAC1	0x00
	#define MYMAC2	0x22
	#define MYMAC3	0xF9
	#define MYMAC4	0x01
	#define MYMAC5	0x2B
	#define MYMAC6	0x4F

	//Netzwerkmaske
	#define NETMASK		IP(255,255,255,0)

	//Taktfrequenz
    #define F_CPU 16000000UL

	//Timertakt intern oder extern
	#define EXTCLOCK 0 //0=Intern 1=Externer Uhrenquarz

#endif //_CONFIG_H


